/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.tools.ConfigureWindowsService;

public class WindowsServicePanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 6415350296295459469L;
    private JLabel lState;
    private JButton bEnable;
    private JButton bDisable;
    private boolean previousLocal = true;
    private boolean isWindowsServiceEnabled;

    public WindowsServicePanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_WINDOWS_SERVICE_TITLE.get();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        String text = AdminToolMessages.INFO_CTRL_PANEL_WINDOWS_SERVICE_PANEL_TEXT.get().toString();
        JEditorPane pane = Utilities.makeHtmlPane(text, ColorAndFontConstants.defaultFont);
        Utilities.updatePreferredSize(pane, 100, text, ColorAndFontConstants.defaultFont, false);
        gbc.weighty = 0.0;
        this.add((Component)pane, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        JLabel lWindowsService = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_WINDOWS_SERVICE_INTEGRATION_LABEL.get());
        gbc.insets.top = 10;
        this.add((Component)lWindowsService, gbc);
        this.lState = Utilities.createDefaultLabel();
        this.lState.setText(this.isWindowsServiceEnabled ? AdminToolMessages.INFO_ENABLED_LABEL.get().toString() : AdminToolMessages.INFO_DISABLED_LABEL.get().toString());
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.add((Component)this.lState, gbc);
        this.bEnable = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ENABLE_WINDOWS_SERVICE_BUTTON.get());
        this.bDisable = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DISABLE_WINDOWS_SERVICE_BUTTON.get());
        this.bEnable.setOpaque(false);
        this.bDisable.setOpaque(false);
        int maxWidth = Math.max(this.bEnable.getPreferredSize().width, this.bDisable.getPreferredSize().width);
        int maxHeight = Math.max(this.bEnable.getPreferredSize().height, this.bDisable.getPreferredSize().height);
        this.bEnable.setPreferredSize(new Dimension(maxWidth, maxHeight));
        this.bDisable.setPreferredSize(new Dimension(maxWidth, maxHeight));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                WindowsServicePanel.this.updateWindowsService();
            }
        };
        this.bEnable.addActionListener(listener);
        this.bDisable.addActionListener(listener);
        gbc.gridx = 2;
        this.add((Component)this.bEnable, gbc);
        this.add((Component)this.bDisable, gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 3;
        this.add(Box.createHorizontalGlue(), gbc);
        this.bEnable.setVisible(!this.isWindowsServiceEnabled);
        this.bDisable.setVisible(this.isWindowsServiceEnabled);
        this.addBottomGlue(gbc);
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.CLOSE;
    }

    @Override
    public Component getPreferredFocusComponent() {
        if (!this.isWindowsServiceEnabled) {
            return this.bEnable;
        }
        return this.bDisable;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        boolean previousValue = this.isWindowsServiceEnabled;
        this.isWindowsServiceEnabled = ev.getNewDescriptor().isWindowsServiceEnabled();
        final boolean isLocal = ev.getNewDescriptor().isLocal();
        if (isLocal != this.previousLocal || this.isWindowsServiceEnabled != previousValue) {
            this.previousLocal = isLocal;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowsServicePanel.this.lState.setText(WindowsServicePanel.this.isWindowsServiceEnabled ? AdminToolMessages.INFO_ENABLED_LABEL.get().toString() : AdminToolMessages.INFO_DISABLED_LABEL.get().toString());
                    WindowsServicePanel.this.bEnable.setVisible(!WindowsServicePanel.this.isWindowsServiceEnabled);
                    WindowsServicePanel.this.bDisable.setVisible(WindowsServicePanel.this.isWindowsServiceEnabled);
                    if (!isLocal) {
                        WindowsServicePanel.this.displayErrorMessage(AdminToolMessages.INFO_CTRL_PANEL_SERVER_REMOTE_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_SERVER_MUST_BE_LOCAL_WINDOWS_SERVICE_SUMMARY.get());
                        WindowsServicePanel.this.packParentDialog();
                    } else {
                        WindowsServicePanel.this.displayMainPanel();
                    }
                }
            });
        }
    }

    @Override
    public void okClicked() {
    }

    private void updateWindowsService() {
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
        WindowsServiceTask newTask = new WindowsServiceTask(this.getInfo(), progressDialog, !this.isWindowsServiceEnabled);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.isEmpty()) {
            if (this.isWindowsServiceEnabled) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DISABLING_WINDOWS_SERVICE_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DISABLING_WINDOWS_SERVICE_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DISABLING_WINDOWS_SERVICE_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_DISABLING_WINDOWS_SERVICE_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_DISABLING_WINDOWS_SERVICE_ERROR_DETAILS, progressDialog);
            } else {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_ENABLING_WINDOWS_SERVICE_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_ENABLING_WINDOWS_SERVICE_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_ENABLING_WINDOWS_SERVICE_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_ENABLING_WINDOWS_SERVICE_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_ENABLING_WINDOWS_SERVICE_ERROR_DETAILS, progressDialog);
            }
            progressDialog.setVisible(true);
        } else {
            this.displayErrorDialog(errors);
        }
    }

    protected class WindowsServiceTask
    extends Task {
        Set<String> backendSet;
        private boolean enableService;

        public WindowsServiceTask(ControlPanelInfo info, ProgressDialog dlg, boolean enableService) {
            super(info, dlg);
            this.enableService = enableService;
            this.backendSet = new HashSet<String>();
        }

        @Override
        public Task.Type getType() {
            if (this.enableService) {
                return Task.Type.ENABLE_WINDOWS_SERVICE;
            }
            return Task.Type.DISABLE_WINDOWS_SERVICE;
        }

        @Override
        public Message getTaskDescription() {
            if (this.enableService) {
                return AdminToolMessages.INFO_CTRL_PANEL_ENABLE_WINDOWS_SERVICE_TASK_DESCRIPTION.get();
            }
            return AdminToolMessages.INFO_CTRL_PANEL_DISABLE_WINDOWS_SERVICE_TASK_DESCRIPTION.get();
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched) && (taskToBeLaunched.getType() == Task.Type.ENABLE_WINDOWS_SERVICE || taskToBeLaunched.getType() == Task.Type.DISABLE_WINDOWS_SERVICE)) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
            return canLaunch;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                if (this.enableService) {
                    this.returnCode = ConfigureWindowsService.enableService(this.outPrintStream, this.errorPrintStream);
                    this.state = this.returnCode != 1 && this.returnCode != 0 ? Task.State.FINISHED_WITH_ERROR : Task.State.FINISHED_SUCCESSFULLY;
                } else {
                    this.returnCode = ConfigureWindowsService.disableService(this.outPrintStream, this.errorPrintStream);
                    this.state = this.returnCode != 1 && this.returnCode != 0 ? Task.State.FINISHED_WITH_ERROR : Task.State.FINISHED_SUCCESSFULLY;
                }
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        protected ArrayList<String> getCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            if (this.enableService) {
                args.add("--enableService");
            } else {
                args.add("--disableService");
            }
            return args;
        }

        @Override
        protected String getCommandLinePath() {
            return this.getCommandLinePath("windows-service");
        }
    }
}

