/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opends.guitools.controlpanel.datamodel.SortableListModel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class AddRemovePanel<T>
extends JPanel {
    private static final long serialVersionUID = 461800576153651284L;
    private SortableListModel<T> availableListModel;
    private SortableListModel<T> selectedListModel;
    private JLabel selectedLabel;
    private JLabel availableLabel;
    private JButton add;
    private JButton remove;
    private JButton addAll;
    private JButton removeAll;
    private JScrollPane availableScroll;
    private JScrollPane selectedScroll;
    private JList availableList;
    private JList selectedList;
    private Class<T> theClass;
    public static final int DISPLAY_REMOVE_ALL = 1;
    public static final int DISPLAY_ADD_ALL = 16;

    public AddRemovePanel(Class<T> theClass) {
        this(17, theClass);
    }

    public AddRemovePanel(int displayOptions, Class<T> theClass) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.theClass = theClass;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.availableLabel = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_AVAILABLE_LABEL.get());
        this.add((Component)this.availableLabel, gbc);
        gbc.gridx = 2;
        this.selectedLabel = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_SELECTED_LABEL.get());
        this.add((Component)this.selectedLabel, gbc);
        ++gbc.gridy;
        ListDataListener listDataListener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent ev) {
                AddRemovePanel.this.updateButtonEnabling();
            }

            @Override
            public void intervalAdded(ListDataEvent ev) {
                AddRemovePanel.this.updateButtonEnabling();
            }

            @Override
            public void contentsChanged(ListDataEvent ev) {
                AddRemovePanel.this.updateButtonEnabling();
            }
        };
        MouseAdapter doubleClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AddRemovePanel.this.isEnabled() && e.getClickCount() == 2) {
                    if (e.getSource() == AddRemovePanel.this.availableList) {
                        if (AddRemovePanel.this.availableList.getSelectedValue() != null) {
                            AddRemovePanel.this.addClicked();
                        }
                    } else if (e.getSource() == AddRemovePanel.this.selectedList && AddRemovePanel.this.selectedList.getSelectedValue() != null) {
                        AddRemovePanel.this.removeClicked();
                    }
                }
            }
        };
        this.availableListModel = new SortableListModel();
        this.availableListModel.addListDataListener(listDataListener);
        this.availableList = new JList();
        this.availableList.setModel(this.availableListModel);
        this.availableList.setVisibleRowCount(15);
        this.availableList.addMouseListener(doubleClickListener);
        this.selectedListModel = new SortableListModel();
        this.selectedListModel.addListDataListener(listDataListener);
        this.selectedList = new JList();
        this.selectedList.setModel(this.selectedListModel);
        this.selectedList.setVisibleRowCount(15);
        this.selectedList.addMouseListener(doubleClickListener);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridheight = 3;
        if ((displayOptions & 0x10) != 0) {
            ++gbc.gridheight;
        }
        if ((displayOptions & 1) != 0) {
            ++gbc.gridheight;
        }
        int listGridHeight = gbc.gridheight;
        int listGridY = gbc.gridy++;
        gbc.gridx = 0;
        gbc.insets.top = 5;
        this.availableScroll = Utilities.createScrollPane(this.availableList);
        gbc.fill = 1;
        this.add((Component)this.availableScroll, gbc);
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_ADD_BUTTON.get());
        this.add.setOpaque(false);
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddRemovePanel.this.addClicked();
            }
        });
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.add, gbc);
        if ((displayOptions & 0x10) != 0) {
            this.addAll = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_ADD_ALL_BUTTON.get());
            this.addAll.setOpaque(false);
            this.addAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    AddRemovePanel.this.selectedListModel.addAll(AddRemovePanel.this.availableListModel.getData());
                    AddRemovePanel.this.availableListModel.clear();
                    AddRemovePanel.this.selectedListModel.fireContentsChanged(AddRemovePanel.this.selectedListModel, 0, AddRemovePanel.this.selectedListModel.getSize());
                    AddRemovePanel.this.availableListModel.fireContentsChanged(AddRemovePanel.this.availableListModel, 0, AddRemovePanel.this.availableListModel.getSize());
                }
            });
            this.add((Component)this.addAll, gbc);
        }
        this.remove = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REMOVE_BUTTON.get());
        this.remove.setOpaque(false);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddRemovePanel.this.removeClicked();
            }
        });
        ++gbc.gridy;
        gbc.insets.top = 10;
        this.add((Component)this.remove, gbc);
        if ((displayOptions & 1) != 0) {
            this.removeAll = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REMOVE_ALL_BUTTON.get());
            this.removeAll.setOpaque(false);
            this.removeAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    AddRemovePanel.this.availableListModel.addAll(AddRemovePanel.this.selectedListModel.getData());
                    AddRemovePanel.this.selectedListModel.clear();
                    AddRemovePanel.this.selectedListModel.fireContentsChanged(AddRemovePanel.this.selectedListModel, 0, AddRemovePanel.this.selectedListModel.getSize());
                    AddRemovePanel.this.availableListModel.fireContentsChanged(AddRemovePanel.this.availableListModel, 0, AddRemovePanel.this.availableListModel.getSize());
                }
            });
            ++gbc.gridy;
            gbc.insets.top = 5;
            this.add((Component)this.removeAll, gbc);
        }
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        gbc.fill = 3;
        this.add(Box.createVerticalGlue(), gbc);
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridheight = listGridHeight;
        gbc.gridy = listGridY;
        gbc.gridx = 2;
        gbc.fill = 1;
        this.selectedScroll = Utilities.createScrollPane(this.selectedList);
        this.add((Component)this.selectedScroll, gbc);
        this.selectedList.getSelectionModel().setSelectionMode(2);
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                AddRemovePanel.this.updateButtonEnabling();
            }
        };
        this.selectedList.getSelectionModel().addListSelectionListener(listener);
        this.availableList.getSelectionModel().setSelectionMode(2);
        this.availableList.getSelectionModel().addListSelectionListener(listener);
        this.add.setEnabled(false);
        this.remove.setEnabled(false);
        Component comp = this.availableList.getCellRenderer().getListCellRendererComponent(this.availableList, "The cell that we want to display", 0, true, true);
        Dimension d = new Dimension(comp.getPreferredSize().width, this.availableScroll.getPreferredSize().height);
        this.availableScroll.setPreferredSize(d);
        this.selectedScroll.setPreferredSize(d);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.selectedLabel.setEnabled(enable);
        this.availableLabel.setEnabled(enable);
        this.availableList.setEnabled(enable);
        this.selectedList.setEnabled(enable);
        this.availableScroll.setEnabled(enable);
        this.selectedScroll.setEnabled(enable);
        this.updateButtonEnabling();
    }

    public JLabel getAvailableLabel() {
        return this.availableLabel;
    }

    public SortableListModel<T> getAvailableListModel() {
        return this.availableListModel;
    }

    public JLabel getSelectedLabel() {
        return this.selectedLabel;
    }

    public SortableListModel<T> getSelectedListModel() {
        return this.selectedListModel;
    }

    private void updateButtonEnabling() {
        int index = this.availableList.getSelectedIndex();
        this.add.setEnabled(index != -1 && index < this.availableListModel.getSize() && this.isEnabled());
        index = this.selectedList.getSelectedIndex();
        this.remove.setEnabled(index != -1 && index < this.selectedListModel.getSize() && this.isEnabled());
        if (this.addAll != null) {
            this.addAll.setEnabled(this.availableListModel.getSize() > 0 && this.isEnabled());
        }
        if (this.removeAll != null) {
            this.removeAll.setEnabled(this.selectedListModel.getSize() > 0 && this.isEnabled());
        }
    }

    public JList getAvailableList() {
        return this.availableList;
    }

    public JList getSelectedList() {
        return this.selectedList;
    }

    private void addClicked() {
        Object[] selectedObjects = this.availableList.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            T value = this.theClass.cast(selectedObjects[i]);
            this.selectedListModel.add(value);
            this.availableListModel.remove(value);
        }
        this.selectedListModel.fireContentsChanged(this.selectedListModel, 0, this.selectedListModel.getSize());
        this.availableListModel.fireContentsChanged(this.availableListModel, 0, this.availableListModel.getSize());
    }

    private void removeClicked() {
        Object[] selectedObjects = this.selectedList.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            T value = this.theClass.cast(selectedObjects[i]);
            this.availableListModel.add(value);
            this.selectedListModel.remove(value);
        }
        this.selectedListModel.fireContentsChanged(this.selectedListModel, 0, this.selectedListModel.getSize());
        this.availableListModel.fireContentsChanged(this.availableListModel, 0, this.availableListModel.getSize());
    }
}

