/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opends.guitools.controlpanel.datamodel.SortableListModel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class DoubleAddRemovePanel<T>
extends JPanel {
    private static final long serialVersionUID = 6881453848780359594L;
    private SortableListModel<T> availableListModel;
    private SortableListModel<T> selectedListModel1;
    private SortableListModel<T> selectedListModel2;
    private JLabel selectedLabel1;
    private JLabel selectedLabel2;
    private JLabel availableLabel;
    private JButton add1;
    private JButton remove1;
    private JButton add2;
    private JButton remove2;
    private JButton addAll1;
    private JButton removeAll1;
    private JButton addAll2;
    private JButton removeAll2;
    private JScrollPane availableScroll;
    private JScrollPane selectedScroll1;
    private JScrollPane selectedScroll2;
    private JList availableList;
    private JList selectedList1;
    private JList selectedList2;
    private Class<T> theClass;
    private Collection<T> unmovableItems = new ArrayList<T>();
    private boolean ignoreListEvents;
    public static final int DISPLAY_REMOVE_ALL = 1;
    public static final int DISPLAY_ADD_ALL = 16;

    public DoubleAddRemovePanel(Class<T> theClass) {
        this(17, theClass);
    }

    public DoubleAddRemovePanel(int displayOptions, Class<T> theClass) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.theClass = theClass;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.availableLabel = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_AVAILABLE_LABEL.get());
        this.add((Component)this.availableLabel, gbc);
        gbc.gridx = 2;
        this.selectedLabel1 = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_SELECTED_LABEL.get());
        this.add((Component)this.selectedLabel1, gbc);
        ++gbc.gridy;
        ListDataListener listDataListener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent ev) {
                DoubleAddRemovePanel.this.listSelectionChanged();
            }

            @Override
            public void intervalAdded(ListDataEvent ev) {
                DoubleAddRemovePanel.this.listSelectionChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent ev) {
                DoubleAddRemovePanel.this.listSelectionChanged();
            }
        };
        MouseAdapter doubleClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DoubleAddRemovePanel.this.isEnabled() && e.getClickCount() == 2) {
                    if (e.getSource() == DoubleAddRemovePanel.this.availableList) {
                        if (DoubleAddRemovePanel.this.availableList.getSelectedValue() != null) {
                            DoubleAddRemovePanel.this.add1Clicked();
                        }
                    } else if (e.getSource() == DoubleAddRemovePanel.this.selectedList1) {
                        if (DoubleAddRemovePanel.this.selectedList1.getSelectedValue() != null) {
                            DoubleAddRemovePanel.this.remove1Clicked();
                        }
                    } else if (e.getSource() == DoubleAddRemovePanel.this.selectedList2 && DoubleAddRemovePanel.this.selectedList2.getSelectedValue() != null) {
                        DoubleAddRemovePanel.this.remove2Clicked();
                    }
                }
            }
        };
        this.availableListModel = new SortableListModel();
        this.availableListModel.addListDataListener(listDataListener);
        this.availableList = new JList();
        this.availableList.setModel(this.availableListModel);
        this.availableList.setVisibleRowCount(15);
        this.availableList.addMouseListener(doubleClickListener);
        this.selectedListModel1 = new SortableListModel();
        this.selectedListModel1.addListDataListener(listDataListener);
        this.selectedList1 = new JList();
        this.selectedList1.setModel(this.selectedListModel1);
        this.selectedList1.setVisibleRowCount(7);
        this.selectedList1.addMouseListener(doubleClickListener);
        this.selectedListModel2 = new SortableListModel();
        this.selectedListModel2.addListDataListener(listDataListener);
        this.selectedList2 = new JList();
        this.selectedList2.setModel(this.selectedListModel2);
        this.selectedList2.setVisibleRowCount(7);
        this.selectedList2.addMouseListener(doubleClickListener);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridheight = 7;
        if ((displayOptions &= 0x10) != 0) {
            gbc.gridheight += 2;
        }
        if ((displayOptions &= 1) != 0) {
            gbc.gridheight += 2;
        }
        int listGridY = gbc.gridy++;
        gbc.gridx = 0;
        gbc.insets.top = 5;
        this.availableScroll = Utilities.createScrollPane(this.availableList);
        gbc.fill = 1;
        this.add((Component)this.availableScroll, gbc);
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add1 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_ADD_BUTTON.get());
        this.add1.setOpaque(false);
        this.add1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DoubleAddRemovePanel.this.add1Clicked();
            }
        });
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.add1, gbc);
        if ((displayOptions &= 0x10) != 0) {
            this.addAll1 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_ADD_ALL_BUTTON.get());
            this.addAll1.setOpaque(false);
            this.addAll1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    DoubleAddRemovePanel.this.moveAll(DoubleAddRemovePanel.this.availableListModel, DoubleAddRemovePanel.this.selectedListModel1);
                }
            });
            this.add((Component)this.addAll1, gbc);
        }
        this.remove1 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REMOVE_BUTTON.get());
        this.remove1.setOpaque(false);
        this.remove1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DoubleAddRemovePanel.this.remove1Clicked();
            }
        });
        ++gbc.gridy;
        gbc.insets.top = 10;
        this.add((Component)this.remove1, gbc);
        if ((displayOptions &= 1) != 0) {
            this.removeAll1 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REMOVE_ALL_BUTTON.get());
            this.removeAll1.setOpaque(false);
            this.removeAll1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    DoubleAddRemovePanel.this.moveAll(DoubleAddRemovePanel.this.selectedListModel1, DoubleAddRemovePanel.this.availableListModel);
                }
            });
            ++gbc.gridy;
            gbc.insets.top = 5;
            this.add((Component)this.removeAll1, gbc);
        }
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        gbc.gridheight = 1;
        gbc.fill = 3;
        this.add(Box.createVerticalGlue(), gbc);
        gbc.gridy += 2;
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add2 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_ADD_BUTTON.get());
        this.add2.setOpaque(false);
        this.add2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DoubleAddRemovePanel.this.add2Clicked();
            }
        });
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.add2, gbc);
        if ((displayOptions &= 0x10) != 0) {
            this.addAll2 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_ADD_ALL_BUTTON.get());
            this.addAll2.setOpaque(false);
            this.addAll2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    DoubleAddRemovePanel.this.moveAll(DoubleAddRemovePanel.this.availableListModel, DoubleAddRemovePanel.this.selectedListModel2);
                }
            });
            ++gbc.gridy;
            this.add((Component)this.addAll2, gbc);
        }
        this.remove2 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REMOVE_BUTTON.get());
        this.remove2.setOpaque(false);
        this.remove2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DoubleAddRemovePanel.this.remove2Clicked();
            }
        });
        ++gbc.gridy;
        gbc.insets.top = 10;
        this.add((Component)this.remove2, gbc);
        if ((displayOptions &= 1) != 0) {
            this.removeAll2 = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REMOVE_ALL_BUTTON.get());
            this.removeAll2.setOpaque(false);
            this.removeAll2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    DoubleAddRemovePanel.this.moveAll(DoubleAddRemovePanel.this.selectedListModel2, DoubleAddRemovePanel.this.availableListModel);
                }
            });
            ++gbc.gridy;
            gbc.insets.top = 5;
            this.add((Component)this.removeAll2, gbc);
        }
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        gbc.gridheight = 1;
        gbc.fill = 3;
        this.add(Box.createVerticalGlue(), gbc);
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridheight = 3;
        if ((displayOptions &= 0x10) != 0) {
            ++gbc.gridheight;
        }
        if ((displayOptions &= 1) != 0) {
            ++gbc.gridheight;
        }
        gbc.gridy = listGridY;
        gbc.gridx = 2;
        gbc.fill = 1;
        this.selectedScroll1 = Utilities.createScrollPane(this.selectedList1);
        gbc.weighty = 1.0;
        this.add((Component)this.selectedScroll1, gbc);
        gbc.gridy += gbc.gridheight;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.insets.top = 10;
        gbc.fill = 2;
        this.selectedLabel2 = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_SELECTED_LABEL.get());
        this.add((Component)this.selectedLabel2, gbc);
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridheight = 3;
        if ((displayOptions &= 0x10) != 0) {
            ++gbc.gridheight;
        }
        if ((displayOptions &= 1) != 0) {
            ++gbc.gridheight;
        }
        ++gbc.gridy;
        gbc.fill = 1;
        this.selectedScroll2 = Utilities.createScrollPane(this.selectedList2);
        gbc.weighty = 1.0;
        this.add((Component)this.selectedScroll2, gbc);
        this.selectedList1.getSelectionModel().setSelectionMode(2);
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                DoubleAddRemovePanel.this.listSelectionChanged();
            }
        };
        this.selectedList1.getSelectionModel().addListSelectionListener(listener);
        this.selectedList2.getSelectionModel().setSelectionMode(2);
        this.selectedList2.getSelectionModel().addListSelectionListener(listener);
        this.availableList.getSelectionModel().setSelectionMode(2);
        this.availableList.getSelectionModel().addListSelectionListener(listener);
        this.add1.setEnabled(false);
        this.remove1.setEnabled(false);
        this.add2.setEnabled(false);
        this.remove2.setEnabled(false);
        Component comp = this.availableList.getCellRenderer().getListCellRendererComponent(this.availableList, "The cell that we want to display", 0, true, true);
        Dimension d = new Dimension(comp.getPreferredSize().width, this.availableScroll.getPreferredSize().height);
        this.availableScroll.setPreferredSize(d);
        d = new Dimension(comp.getPreferredSize().width, this.selectedScroll1.getPreferredSize().height);
        this.selectedScroll1.setPreferredSize(d);
        this.selectedScroll2.setPreferredSize(d);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.selectedLabel1.setEnabled(enable);
        this.selectedLabel2.setEnabled(enable);
        this.availableLabel.setEnabled(enable);
        this.availableList.setEnabled(enable);
        this.selectedList1.setEnabled(enable);
        this.selectedList2.setEnabled(enable);
        this.availableScroll.setEnabled(enable);
        this.selectedScroll2.setEnabled(enable);
        this.selectedScroll2.setEnabled(enable);
        this.listSelectionChanged();
    }

    public JLabel getAvailableLabel() {
        return this.availableLabel;
    }

    public SortableListModel<T> getAvailableListModel() {
        return this.availableListModel;
    }

    public JLabel getSelectedLabel1() {
        return this.selectedLabel1;
    }

    public SortableListModel<T> getSelectedListModel1() {
        return this.selectedListModel1;
    }

    public JLabel getSelectedLabel2() {
        return this.selectedLabel2;
    }

    public SortableListModel<T> getSelectedListModel2() {
        return this.selectedListModel2;
    }

    private void listSelectionChanged() {
        boolean onlyUnmovable;
        JList[] lists;
        if (this.ignoreListEvents) {
            return;
        }
        this.ignoreListEvents = true;
        for (JList list : lists = new JList[]{this.availableList, this.selectedList1, this.selectedList2}) {
            for (T element : this.unmovableItems) {
                int[] indexes = list.getSelectedIndices();
                if (indexes == null) continue;
                for (int i = 0; i < indexes.length; ++i) {
                    if (indexes[i] >= list.getModel().getSize() || !list.getModel().getElementAt(indexes[i]).equals(element)) continue;
                    list.getSelectionModel().removeIndexInterval(indexes[i], indexes[i]);
                }
            }
        }
        this.ignoreListEvents = false;
        int index = this.availableList.getSelectedIndex();
        this.add1.setEnabled(index != -1 && index < this.availableListModel.getSize() && this.isEnabled());
        this.add2.setEnabled(this.add1.isEnabled());
        index = this.selectedList1.getSelectedIndex();
        this.remove1.setEnabled(index != -1 && index < this.selectedListModel1.getSize() && this.isEnabled());
        index = this.selectedList2.getSelectedIndex();
        this.remove2.setEnabled(index != -1 && index < this.selectedListModel2.getSize() && this.isEnabled());
        if (this.addAll1 != null) {
            onlyUnmovable = this.unmovableItems.containsAll(this.availableListModel.getData());
            this.addAll1.setEnabled(this.availableListModel.getSize() > 0 && this.isEnabled() && !onlyUnmovable);
            this.addAll2.setEnabled(this.addAll1.isEnabled());
        }
        if (this.removeAll1 != null) {
            onlyUnmovable = this.unmovableItems.containsAll(this.selectedListModel1.getData());
            this.removeAll1.setEnabled(this.selectedListModel1.getSize() > 0 && this.isEnabled() && !onlyUnmovable);
        }
        if (this.removeAll2 != null) {
            onlyUnmovable = this.unmovableItems.containsAll(this.selectedListModel2.getData());
            this.removeAll2.setEnabled(this.selectedListModel2.getSize() > 0 && this.isEnabled() && !onlyUnmovable);
        }
    }

    public JList getAvailableList() {
        return this.availableList;
    }

    public JList getSelectedList1() {
        return this.selectedList1;
    }

    public JList getSelectedList2() {
        return this.selectedList2;
    }

    private void add1Clicked() {
        Object[] selectedObjects = this.availableList.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            T value = this.theClass.cast(selectedObjects[i]);
            this.selectedListModel1.add(value);
            this.availableListModel.remove(value);
        }
        this.selectedListModel1.fireContentsChanged(this.selectedListModel1, 0, this.selectedListModel1.getSize());
        this.availableListModel.fireContentsChanged(this.availableListModel, 0, this.availableListModel.getSize());
    }

    private void add2Clicked() {
        Object[] selectedObjects = this.availableList.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            T value = this.theClass.cast(selectedObjects[i]);
            this.selectedListModel2.add(value);
            this.availableListModel.remove(value);
        }
        this.selectedListModel2.fireContentsChanged(this.selectedListModel2, 0, this.selectedListModel2.getSize());
        this.availableListModel.fireContentsChanged(this.availableListModel, 0, this.availableListModel.getSize());
    }

    private void remove1Clicked() {
        Object[] selectedObjects = this.selectedList1.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            T value = this.theClass.cast(selectedObjects[i]);
            this.availableListModel.add(value);
            this.selectedListModel1.remove(value);
        }
        this.selectedListModel1.fireContentsChanged(this.selectedListModel1, 0, this.selectedListModel1.getSize());
        this.availableListModel.fireContentsChanged(this.availableListModel, 0, this.availableListModel.getSize());
    }

    private void remove2Clicked() {
        Object[] selectedObjects = this.selectedList2.getSelectedValues();
        for (int i = 0; i < selectedObjects.length; ++i) {
            T value = this.theClass.cast(selectedObjects[i]);
            this.availableListModel.add(value);
            this.selectedListModel2.remove(value);
        }
        this.selectedListModel2.fireContentsChanged(this.selectedListModel2, 0, this.selectedListModel2.getSize());
        this.availableListModel.fireContentsChanged(this.availableListModel, 0, this.availableListModel.getSize());
    }

    public void setUnmovableItems(Collection<T> unmovableItems) {
        this.unmovableItems.clear();
        this.unmovableItems.addAll(unmovableItems);
    }

    private void moveAll(SortableListModel<T> fromModel, SortableListModel<T> toModel) {
        SortedSet<T> toKeep = fromModel.getData();
        toKeep.retainAll(this.unmovableItems);
        SortedSet<T> toMove = fromModel.getData();
        toMove.removeAll(this.unmovableItems);
        toModel.addAll(toMove);
        fromModel.clear();
        fromModel.addAll(toKeep);
        fromModel.fireContentsChanged(this.selectedListModel1, 0, this.selectedListModel1.getSize());
        toModel.fireContentsChanged(this.availableListModel, 0, this.availableListModel.getSize());
    }
}

