/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.opends.guitools.controlpanel.datamodel.BinaryValue;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.ui.BinaryAttributeEditorPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.ObjectClassEditorPanel;
import org.opends.guitools.controlpanel.ui.components.BinaryCellPanel;
import org.opends.guitools.controlpanel.ui.components.ObjectClassCellPanel;
import org.opends.guitools.controlpanel.ui.renderer.CustomCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;

public class AttributeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1979354208925355746L;
    private BinaryCellPanel binaryPanel;
    private ObjectClassCellPanel ocPanel;
    private ObjectClassValue ocValue;
    private byte[] value;
    private BinaryValue binaryValue;
    private TableCellEditor defaultEditor;
    private TableCellEditor passwordEditor;
    private GenericDialog editBinaryDlg;
    private BinaryAttributeEditorPanel editBinaryPanel;
    private GenericDialog editOcDlg;
    private ObjectClassEditorPanel editOcPanel;
    private JTable table;
    private JTextField textField = Utilities.createTextField();
    private JPasswordField passwordField;
    private ControlPanelInfo info;
    private String attrName;

    public AttributeCellEditor() {
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                if (!AttributeCellEditor.this.textField.hasFocus()) {
                    AttributeCellEditor.this.textField.requestFocusInWindow();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }
        });
        this.passwordField = Utilities.createPasswordField();
        this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                if (!AttributeCellEditor.this.passwordField.hasFocus()) {
                    AttributeCellEditor.this.passwordField.requestFocusInWindow();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }
        });
        this.defaultEditor = new DefaultCellEditor(this.textField);
        this.passwordEditor = new DefaultCellEditor(this.passwordField);
        this.binaryPanel = new BinaryCellPanel();
        this.binaryPanel.addEditActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AttributeCellEditor.this.editBinaryDlg == null) {
                    AttributeCellEditor.this.editBinaryPanel = new BinaryAttributeEditorPanel();
                    AttributeCellEditor.this.editBinaryPanel.setInfo(AttributeCellEditor.this.getInfo());
                    AttributeCellEditor.this.editBinaryDlg = new GenericDialog(Utilities.getFrame(AttributeCellEditor.this.table), AttributeCellEditor.this.editBinaryPanel);
                    AttributeCellEditor.this.editBinaryDlg.setModal(true);
                    Utilities.centerGoldenMean(AttributeCellEditor.this.editBinaryDlg, Utilities.getParentDialog(AttributeCellEditor.this.table));
                }
                if (AttributeCellEditor.this.binaryValue != null) {
                    AttributeCellEditor.this.editBinaryPanel.setValue(AttributeCellEditor.this.attrName, AttributeCellEditor.this.binaryValue);
                } else if (AttributeCellEditor.this.value != null) {
                    if (AttributeCellEditor.this.value.length > 0) {
                        AttributeCellEditor.this.editBinaryPanel.setValue(AttributeCellEditor.this.attrName, BinaryValue.createBase64(AttributeCellEditor.this.value));
                    } else {
                        AttributeCellEditor.this.editBinaryPanel.setValue(AttributeCellEditor.this.attrName, null);
                    }
                } else {
                    AttributeCellEditor.this.editBinaryPanel.setValue(AttributeCellEditor.this.attrName, null);
                }
                AttributeCellEditor.this.editBinaryDlg.setVisible(true);
                if (AttributeCellEditor.this.editBinaryPanel.valueChanged()) {
                    BinaryValue changedValue = AttributeCellEditor.this.editBinaryPanel.getBinaryValue();
                    AttributeCellEditor.this.binaryValue = changedValue;
                    AttributeCellEditor.access$702(AttributeCellEditor.this, null);
                    AttributeCellEditor.this.ocValue = null;
                }
                AttributeCellEditor.this.fireEditingStopped();
            }
        });
        this.ocPanel = new ObjectClassCellPanel();
        this.ocPanel.addEditActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AttributeCellEditor.this.editOcDlg == null) {
                    AttributeCellEditor.this.editOcPanel = new ObjectClassEditorPanel();
                    AttributeCellEditor.this.editOcPanel.setInfo(AttributeCellEditor.this.getInfo());
                    AttributeCellEditor.this.editOcDlg = new GenericDialog(null, AttributeCellEditor.this.editOcPanel);
                    AttributeCellEditor.this.editOcDlg.setModal(true);
                    Utilities.centerGoldenMean(AttributeCellEditor.this.editOcDlg, Utilities.getParentDialog(AttributeCellEditor.this.table));
                }
                if (AttributeCellEditor.this.ocValue != null) {
                    AttributeCellEditor.this.editOcPanel.setValue(AttributeCellEditor.this.ocValue);
                }
                AttributeCellEditor.this.editOcDlg.setVisible(true);
                if (AttributeCellEditor.this.editOcPanel.valueChanged()) {
                    AttributeCellEditor.this.binaryValue = null;
                    AttributeCellEditor.access$702(AttributeCellEditor.this, null);
                    AttributeCellEditor.this.ocValue = AttributeCellEditor.this.editOcPanel.getObjectClassValue();
                    AttributeCellEditor.this.fireEditingStopped();
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        if (this.isPassword(table, row)) {
            this.value = null;
            this.binaryValue = null;
            this.ocValue = null;
            return this.passwordEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        if (value instanceof ObjectClassValue) {
            this.value = null;
            this.binaryValue = null;
            this.ocValue = (ObjectClassValue)value;
            this.ocPanel.setValue(this.ocValue);
            this.ocPanel.setBorder(CustomCellRenderer.getDefaultFocusBorder(table, value, isSelected, row, column));
            return this.ocPanel;
        }
        if (value instanceof byte[] || value instanceof BinaryValue) {
            this.attrName = this.getAttributeName(table, row);
            boolean isImage = Utilities.hasImageSyntax(this.attrName, this.getInfo().getServerDescriptor().getSchema());
            if (value instanceof byte[]) {
                this.value = (byte[])value;
                this.binaryValue = null;
                this.ocValue = null;
                if (this.value.length > 0) {
                    this.binaryPanel.setValue(BinaryValue.createBase64(this.value), isImage);
                } else {
                    this.binaryPanel.setValue((byte[])null, isImage);
                }
            } else {
                this.value = null;
                this.ocValue = null;
                this.binaryValue = (BinaryValue)value;
                this.binaryPanel.setValue(this.binaryValue, isImage);
            }
            this.binaryPanel.setBorder(CustomCellRenderer.getDefaultFocusBorder(table, value, isSelected, row, column));
            return this.binaryPanel;
        }
        this.value = null;
        this.binaryValue = null;
        this.ocValue = null;
        return this.defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.binaryValue != null) {
            return this.binaryValue;
        }
        if (this.value != null) {
            return this.value;
        }
        if (this.ocValue != null) {
            return this.ocValue;
        }
        return this.defaultEditor.getCellEditorValue();
    }

    private boolean isPassword(JTable table, int row) {
        boolean isPassword = false;
        Object o = table.getValueAt(row, 0);
        if (Utilities.hasPasswordSyntax(String.valueOf(o), this.getInfo().getServerDescriptor().getSchema())) {
            isPassword = true;
        }
        return isPassword;
    }

    private String getAttributeName(JTable table, int row) {
        Object o = table.getValueAt(row, 0);
        String attrName = String.valueOf(o);
        return attrName;
    }

    public ControlPanelInfo getInfo() {
        return this.info;
    }

    public void setInfo(ControlPanelInfo info) {
        this.info = info;
    }

    static /* synthetic */ byte[] access$702(AttributeCellEditor x0, byte[] x1) {
        x0.value = x1;
        return x1;
    }
}

