/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.renderer;

import java.awt.Component;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.opends.guitools.controlpanel.datamodel.BackupDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackupTableModel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;

public class BackupTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -4645902129785751854L;
    private DateFormat formatter = DateFormat.getDateInstance(0);
    private File backupParentPath;
    private static final Border fullBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.gridColor), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private static final Border incrementalBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);

    public BackupTableCellRenderer() {
        this.setForeground(ColorAndFontConstants.tableForeground);
        this.setBackground(ColorAndFontConstants.tableBackground);
    }

    public void setParentPath(File backupParentPath) {
        this.backupParentPath = backupParentPath;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String s;
        boolean isFull;
        boolean isDate = false;
        boolean bl = isFull = ((BackupTableModel)table.getModel()).get(row).getType() == BackupDescriptor.Type.FULL;
        if (value instanceof File) {
            s = "";
            boolean isParent = false;
            for (File f = (File)value; f != null; f = f.getParentFile()) {
                if (!f.equals(this.backupParentPath)) {
                    if (s.length() == 0) {
                        s = f.getName();
                        continue;
                    }
                    s = f.getName() + File.separator + s;
                    continue;
                }
                isParent = true;
                break;
            }
            if (isParent) {
                if (!isFull) {
                    s = "  " + s;
                }
            } else {
                s = value.toString();
            }
        } else if (value instanceof Date) {
            isDate = true;
            s = this.formatter.format((Date)value);
        } else if (value instanceof BackupDescriptor.Type) {
            s = isFull ? "Full" : "Incremental";
        } else if (value instanceof String) {
            s = (String)value;
        } else {
            throw new IllegalArgumentException("Unknown class for " + value + ": " + " row: " + row + "column: " + column);
        }
        super.getTableCellRendererComponent(table, s, isSelected, hasFocus, row, column);
        if (isFull && row != 0) {
            this.setBorder(fullBorder);
        } else {
            this.setBorder(incrementalBorder);
        }
        if (isDate) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        return this;
    }
}

