/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;

public class CliUserInteraction
extends ConsoleApplication
implements UserInteraction {
    private static final Logger LOG = Logger.getLogger(CliUserInteraction.class.getName());
    private final boolean isInteractive;
    private final boolean isForceOnError;

    public CliUserInteraction(UserData ud) {
        super(System.in, (OutputStream)System.out, (OutputStream)System.err);
        this.isInteractive = ud == null || ud.isInteractive();
        this.isForceOnError = ud != null && ud.isForceOnError();
    }

    @Override
    public Object confirm(Message summary, Message details, Message title, UserInteraction.MessageType type, Message[] options, Message def) {
        return this.confirm(summary, details, null, title, type, options, def, null);
    }

    @Override
    public Object confirm(Message summary, Message details, Message fineDetails, Message title, UserInteraction.MessageType type, Message[] options, Message def, Message viewDetailsOption) {
        MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this);
        MessageBuilder b = new MessageBuilder();
        b.append(summary);
        b.append(Constants.LINE_SEPARATOR);
        b.append(details);
        builder.setPrompt(b.toMessage());
        int defInt = -1;
        for (int i = 0; i < options.length; ++i) {
            builder.addNumberedOption(options[i], MenuResult.success(i + 1), new Message[0]);
            if (!options[i].equals(def)) continue;
            defInt = i + 1;
        }
        if (fineDetails != null) {
            Message detailsPrompt = viewDetailsOption;
            if (detailsPrompt == null) {
                detailsPrompt = AdminToolMessages.INFO_CLI_VIEW_DETAILS.get();
            }
            builder.addNumberedOption(detailsPrompt, MenuResult.success(options.length + 1), new Message[0]);
        }
        builder.setDefault(Message.raw(String.valueOf(defInt), new Object[0]), MenuResult.success(defInt));
        Menu menu = builder.toMenu();
        Message returnValue = null;
        boolean menuDisplayed = false;
        while (returnValue == null) {
            int respInt;
            try {
                if (menuDisplayed) {
                    this.println();
                    builder.setPrompt(null);
                    menu = builder.toMenu();
                }
                MenuResult m = menu.run();
                menuDisplayed = true;
                if (!m.isSuccess()) {
                    throw new RuntimeException();
                }
                respInt = (Integer)m.getValue();
            }
            catch (CLIException ce) {
                respInt = defInt;
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
            if (fineDetails != null && respInt == options.length + 1) {
                this.println();
                this.println(String.valueOf(fineDetails));
                continue;
            }
            returnValue = options[respInt - 1];
        }
        return returnValue;
    }

    @Override
    public String createUnorderedList(List<?> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (Object o : list) {
                sb.append("* ");
                sb.append(o.toString());
                sb.append(Constants.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    private void println(String text) {
        text = Utils.convertHtmlBreakToLineSeparator(text);
        text = Utils.stripHtml(text);
        text = StaticUtils.wrapText(text, Utils.getCommandLineMaxLineWidth());
        this.getErrorStream().println(text);
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public boolean isMenuDrivenMode() {
        return true;
    }

    @Override
    public boolean isQuiet() {
        return false;
    }

    @Override
    public boolean isScriptFriendly() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    @Override
    public boolean isCLI() {
        return true;
    }

    @Override
    public boolean isForceOnError() {
        return this.isForceOnError;
    }
}

