/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import java.util.LinkedList;

public class NewSuffixOptions {
    private Type type;
    private LinkedList<String> baseDns = new LinkedList();
    private LinkedList<String> ldifPaths = new LinkedList();
    private String rejectedFile;
    private String skippedFile;
    private int numberEntries = 2000;

    private NewSuffixOptions(LinkedList<String> baseDns) {
        this.baseDns.addAll(baseDns);
    }

    public static NewSuffixOptions createBaseEntry(LinkedList<String> baseDNs) {
        NewSuffixOptions ops = new NewSuffixOptions(baseDNs);
        ops.type = Type.CREATE_BASE_ENTRY;
        return ops;
    }

    public static NewSuffixOptions createEmpty(LinkedList<String> baseDNs) {
        NewSuffixOptions ops = new NewSuffixOptions(baseDNs);
        ops.type = Type.LEAVE_DATABASE_EMPTY;
        return ops;
    }

    public static NewSuffixOptions createImportFromLDIF(LinkedList<String> baseDNs, LinkedList<String> ldifPaths, String rejectedFile, String skippedFile) {
        NewSuffixOptions ops = new NewSuffixOptions(baseDNs);
        ops.type = Type.IMPORT_FROM_LDIF_FILE;
        ops.ldifPaths.addAll(ldifPaths);
        ops.rejectedFile = rejectedFile;
        ops.skippedFile = skippedFile;
        return ops;
    }

    public static NewSuffixOptions createAutomaticallyGenerated(LinkedList<String> baseDNs, int numberEntries) {
        NewSuffixOptions ops = new NewSuffixOptions(baseDNs);
        ops.type = Type.IMPORT_AUTOMATICALLY_GENERATED_DATA;
        ops.numberEntries = numberEntries;
        return ops;
    }

    public Type getType() {
        return this.type;
    }

    public LinkedList<String> getLDIFPaths() {
        return new LinkedList<String>(this.ldifPaths);
    }

    public String getRejectedFile() {
        return this.rejectedFile;
    }

    public String getSkippedFile() {
        return this.skippedFile;
    }

    public int getNumberEntries() {
        return this.numberEntries;
    }

    public LinkedList<String> getBaseDns() {
        return new LinkedList<String>(this.baseDns);
    }

    public static enum Type {
        CREATE_BASE_ENTRY,
        LEAVE_DATABASE_EMPTY,
        IMPORT_FROM_LDIF_FILE,
        IMPORT_AUTOMATICALLY_GENERATED_DATA;

    }
}

