/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.event.ButtonEvent;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;

public class DataReplicationPanel
extends QuickSetupStepPanel {
    private static final long serialVersionUID = -1721551487477733587L;
    private Component lastFocusComponent;
    private UserData defaultUserData;
    private JRadioButton rbStandalone;
    private JRadioButton rbReplicated;
    private JCheckBox cbSecureReplication;
    private JCheckBox cbTopologyExists;
    private HashMap<FieldName, JLabel> hmLabels = new HashMap();
    private HashMap<FieldName, JTextComponent> hmFields = new HashMap();

    public DataReplicationPanel(GuiApplication application) {
        super(application);
        this.defaultUserData = application.getUserData();
        this.populateComponentMaps();
        this.addDocumentListeners();
        this.addFocusListeners();
        this.addActionListeners();
    }

    @Override
    public Object getFieldValue(FieldName fieldName) {
        Object value = null;
        if (fieldName == FieldName.REPLICATION_OPTIONS) {
            value = this.rbStandalone.isSelected() ? DataReplicationOptions.Type.STANDALONE : (this.cbTopologyExists.isSelected() ? DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY : DataReplicationOptions.Type.FIRST_IN_TOPOLOGY);
        } else if (fieldName == FieldName.REPLICATION_SECURE) {
            value = this.cbSecureReplication.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        } else {
            JTextComponent field = this.getField(fieldName);
            if (field != null) {
                value = field.getText();
            }
        }
        return value;
    }

    @Override
    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        JLabel label = this.getLabel(fieldName);
        if (label != null) {
            UIFactory.TextStyle style = invalid ? UIFactory.TextStyle.SECONDARY_FIELD_INVALID : UIFactory.TextStyle.SECONDARY_FIELD_VALID;
            UIFactory.setTextStyle(label, style);
        }
    }

    @Override
    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = UIFactory.getEmptyInsets();
        panel.add((Component)this.rbStandalone, gbc);
        gbc.insets.top = 0;
        panel.add((Component)this.rbReplicated, gbc);
        gbc.insets.top = 5;
        gbc.insets.left = 35;
        JPanel auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        panel.add((Component)auxPanel, gbc);
        panel.add((Component)this.cbTopologyExists, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 4;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.anchor = 17;
        auxPanel.add((Component)this.getLabel(FieldName.REPLICATION_PORT), gbc);
        --gbc.gridwidth;
        gbc.insets.left = 5;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        auxPanel.add((Component)this.getField(FieldName.REPLICATION_PORT), gbc);
        gbc.gridwidth = -1;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        auxPanel.add((Component)this.cbSecureReplication, gbc);
        gbc.gridwidth = 0;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        auxPanel.add(Box.createHorizontalGlue(), gbc);
        auxPanel = new JPanel(new GridBagLayout());
        auxPanel.setOpaque(false);
        gbc.insets.left = 70;
        panel.add((Component)auxPanel, gbc);
        FieldName[] fields = new FieldName[]{FieldName.REMOTE_SERVER_HOST, FieldName.REMOTE_SERVER_PORT, FieldName.REMOTE_SERVER_DN, FieldName.REMOTE_SERVER_PWD};
        gbc.insets = UIFactory.getEmptyInsets();
        for (int i = 0; i < fields.length; ++i) {
            gbc.insets.top = i != 0 ? 5 : 0;
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.left = 0;
            gbc.anchor = 17;
            auxPanel.add((Component)this.getLabel(fields[i]), gbc);
            JPanel aux2Panel = new JPanel(new GridBagLayout());
            aux2Panel.setOpaque(false);
            gbc.gridwidth = fields[i] == FieldName.REMOTE_SERVER_PORT ? 3 : -1;
            gbc.insets.left = 5;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            aux2Panel.add((Component)this.getField(fields[i]), gbc);
            gbc.gridwidth = 0;
            gbc.insets.left = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            aux2Panel.add(Box.createHorizontalGlue(), gbc);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = UIFactory.getEmptyInsets();
            gbc.gridwidth = 0;
            auxPanel.add((Component)aux2Panel, gbc);
        }
        this.addVerticalGlue(panel);
        return panel;
    }

    @Override
    protected Message getInstructions() {
        return QuickSetupMessages.INFO_DATA_REPLICATION_OPTIONS_PANEL_INSTRUCTIONS.get();
    }

    @Override
    protected Message getTitle() {
        return QuickSetupMessages.INFO_DATA_REPLICATION_OPTIONS_PANEL_TITLE.get();
    }

    @Override
    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    @Override
    protected Message getTextForIcon(UIFactory.IconType iconType) {
        Message text = iconType == UIFactory.IconType.WAIT && this.rbReplicated.isSelected() && this.cbTopologyExists.isSelected() ? QuickSetupMessages.INFO_CONTACTING_SERVER_LABEL.get() : super.getTextForIcon(iconType);
        return text;
    }

    private Object getDefaultValue(FieldName fieldName) {
        Object value;
        AuthenticationData auth = this.defaultUserData.getReplicationOptions().getAuthenticationData();
        switch (fieldName) {
            case REPLICATION_PORT: {
                value = this.defaultUserData.getReplicationOptions().getReplicationPort();
                break;
            }
            case REMOTE_SERVER_DN: {
                value = auth.getDn();
                break;
            }
            case REMOTE_SERVER_PWD: {
                value = auth.getPwd();
                break;
            }
            case REMOTE_SERVER_HOST: {
                value = auth.getHostName();
                break;
            }
            case REMOTE_SERVER_PORT: {
                value = auth.getPort();
                break;
            }
            case REPLICATION_OPTIONS: {
                value = this.defaultUserData.getReplicationOptions().getType();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown field name: " + (Object)((Object)fieldName));
            }
        }
        return value;
    }

    private String getDefaultStringValue(FieldName fieldName) {
        String value = null;
        Object v = this.getDefaultValue(fieldName);
        if (v != null) {
            value = v instanceof String ? (String)v : String.valueOf(v);
        }
        return value;
    }

    private void populateComponentMaps() {
        HashMap<FieldName, LabelFieldDescriptor> hm = new HashMap<FieldName, LabelFieldDescriptor>();
        hm.put(FieldName.REPLICATION_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_REPLICATION_PORT_LABEL.get(), QuickSetupMessages.INFO_REPLICATION_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.SECONDARY, 5));
        hm.put(FieldName.REMOTE_SERVER_DN, new LabelFieldDescriptor(QuickSetupMessages.INFO_REMOTE_SERVER_DN_LABEL.get(), QuickSetupMessages.INFO_REMOTE_SERVER_DN_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.SECONDARY, 20));
        hm.put(FieldName.REMOTE_SERVER_PWD, new LabelFieldDescriptor(QuickSetupMessages.INFO_REMOTE_SERVER_PWD_LABEL.get(), QuickSetupMessages.INFO_REMOTE_SERVER_PWD_TOOLTIP.get(), LabelFieldDescriptor.FieldType.PASSWORD, LabelFieldDescriptor.LabelType.SECONDARY, 15));
        hm.put(FieldName.REMOTE_SERVER_HOST, new LabelFieldDescriptor(QuickSetupMessages.INFO_REMOTE_SERVER_HOST_LABEL.get(), QuickSetupMessages.INFO_REMOTE_SERVER_HOST_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.SECONDARY, 20));
        hm.put(FieldName.REMOTE_SERVER_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_REMOTE_SERVER_PORT_LABEL.get(), QuickSetupMessages.INFO_REMOTE_SERVER_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.SECONDARY, 5));
        for (FieldName fieldName : hm.keySet()) {
            LabelFieldDescriptor desc = (LabelFieldDescriptor)hm.get((Object)fieldName);
            String defaultValue = this.getDefaultStringValue(fieldName);
            JTextComponent field = UIFactory.makeJTextComponent(desc, defaultValue);
            this.hmFields.put(fieldName, field);
            JLabel l = UIFactory.makeJLabel(desc);
            l.setLabelFor(field);
            this.hmLabels.put(fieldName, l);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbStandalone = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_STANDALONE_SERVER_LABEL.get(), QuickSetupMessages.INFO_STANDALONE_SERVER_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbStandalone.setOpaque(false);
        this.rbReplicated = UIFactory.makeJRadioButton(QuickSetupMessages.INFO_REPLICATED_SERVER_LABEL.get(), QuickSetupMessages.INFO_REPLICATED_SERVER_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.rbReplicated.setOpaque(false);
        buttonGroup.add(this.rbStandalone);
        buttonGroup.add(this.rbReplicated);
        DataReplicationOptions.Type type = this.defaultUserData.getReplicationOptions().getType();
        this.cbTopologyExists = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_TOPOLOGY_EXISTS_LABEL.get(), QuickSetupMessages.INFO_TOPOLOGY_EXISTS_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.cbTopologyExists.setOpaque(false);
        this.rbStandalone.setSelected(type == DataReplicationOptions.Type.STANDALONE);
        this.rbReplicated.setSelected(type != DataReplicationOptions.Type.STANDALONE);
        this.cbSecureReplication = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_SECURE_REPLICATION_LABEL.get(), QuickSetupMessages.INFO_SECURE_REPLICATION_TOOLTIP.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        this.cbSecureReplication.setSelected(this.defaultUserData.getReplicationOptions().useSecureReplication());
        this.cbTopologyExists.setSelected(type == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY);
        this.checkEnablingState();
    }

    private void addDocumentListeners() {
        FieldName[] fields;
        for (FieldName field : fields = new FieldName[]{FieldName.REMOTE_SERVER_DN, FieldName.REMOTE_SERVER_PWD, FieldName.REMOTE_SERVER_HOST, FieldName.REMOTE_SERVER_PORT}) {
            JTextComponent tf = this.getField(field);
            tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent ev) {
                    if (!DataReplicationPanel.this.rbReplicated.isSelected()) {
                        DataReplicationPanel.this.rbReplicated.setSelected(true);
                    }
                    if (!DataReplicationPanel.this.cbTopologyExists.isSelected()) {
                        DataReplicationPanel.this.cbTopologyExists.setSelected(true);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent ev) {
                    this.changedUpdate(ev);
                }

                @Override
                public void removeUpdate(DocumentEvent ev) {
                    this.changedUpdate(ev);
                }
            });
        }
    }

    private void addFocusListeners() {
        FocusListener l = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DataReplicationPanel.this.lastFocusComponent = e.getComponent();
                if (DataReplicationPanel.this.lastFocusComponent instanceof JTextComponent) {
                    DataReplicationPanel.this.rbReplicated.setSelected(true);
                    if (DataReplicationPanel.this.lastFocusComponent != DataReplicationPanel.this.getField(FieldName.REPLICATION_PORT)) {
                        DataReplicationPanel.this.cbTopologyExists.setSelected(true);
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        for (JTextComponent tf : this.hmFields.values()) {
            tf.addFocusListener(l);
        }
        this.rbReplicated.addFocusListener(l);
        this.rbStandalone.addFocusListener(l);
        this.cbTopologyExists.addFocusListener(l);
        this.cbSecureReplication.addFocusListener(l);
        this.lastFocusComponent = this.rbStandalone;
    }

    private void addActionListeners() {
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DataReplicationPanel.this.checkEnablingState();
                ButtonEvent be = new ButtonEvent(ev.getSource(), ButtonName.INPUT_PANEL_BUTTON);
                DataReplicationPanel.this.notifyButtonListeners(be);
            }
        };
        this.rbReplicated.addActionListener(l);
        this.rbStandalone.addActionListener(l);
        this.cbTopologyExists.addActionListener(l);
        this.cbTopologyExists.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DataReplicationPanel.this.cbTopologyExists.isSelected()) {
                    DataReplicationPanel.this.rbReplicated.setSelected(true);
                }
            }
        });
    }

    private void checkEnablingState() {
        boolean enableFields = this.rbReplicated.isSelected() && this.cbTopologyExists.isSelected();
        for (JTextComponent tf : this.hmFields.values()) {
            tf.setEnabled(enableFields);
        }
        for (JLabel l : this.hmLabels.values()) {
            l.setEnabled(enableFields);
        }
        this.cbTopologyExists.setEnabled(this.rbReplicated.isSelected());
        this.getLabel(FieldName.REPLICATION_PORT).setEnabled(this.rbReplicated.isSelected());
        this.getField(FieldName.REPLICATION_PORT).setEnabled(this.rbReplicated.isSelected());
        this.cbSecureReplication.setEnabled(this.rbReplicated.isSelected());
    }

    private JLabel getLabel(FieldName fieldName) {
        return this.hmLabels.get((Object)fieldName);
    }

    private JTextComponent getField(FieldName fieldName) {
        return this.hmFields.get((Object)fieldName);
    }
}

