/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.UIFactory;

public class GlobalAdministratorPanel
extends QuickSetupStepPanel {
    private static final long serialVersionUID = 4266485298770553875L;
    private UserData defaultUserData;
    private Component lastFocusComponent;
    private HashMap<FieldName, JLabel> hmLabels = new HashMap();
    private HashMap<FieldName, JTextComponent> hmFields = new HashMap();

    public GlobalAdministratorPanel(GuiApplication application) {
        super(application);
        this.defaultUserData = application.getUserData();
        this.populateLabelAndFieldMaps();
        this.addFocusListeners();
    }

    @Override
    public Object getFieldValue(FieldName fieldName) {
        String value = null;
        JTextComponent field = this.getField(fieldName);
        if (field != null) {
            value = field.getText();
        }
        return value;
    }

    @Override
    public void displayFieldInvalid(FieldName fieldName, boolean invalid) {
        JLabel label = this.getLabel(fieldName);
        if (label != null) {
            if (invalid) {
                UIFactory.setTextStyle(label, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
            } else {
                UIFactory.setTextStyle(label, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            }
        }
    }

    @Override
    protected Component createInputPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = UIFactory.getEmptyInsets();
        FieldName[] fields = new FieldName[]{FieldName.GLOBAL_ADMINISTRATOR_UID, FieldName.GLOBAL_ADMINISTRATOR_PWD, FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM};
        gbc.insets = UIFactory.getEmptyInsets();
        for (int i = 0; i < fields.length; ++i) {
            gbc.insets.top = i != 0 ? 5 : 0;
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.left = 0;
            gbc.anchor = 17;
            panel.add((Component)this.getLabel(fields[i]), gbc);
            JPanel auxPanel = new JPanel(new GridBagLayout());
            auxPanel.setOpaque(false);
            gbc.gridwidth = -1;
            gbc.insets.left = 5;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            auxPanel.add((Component)this.getField(fields[i]), gbc);
            gbc.gridwidth = 0;
            gbc.insets.left = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            auxPanel.add(Box.createHorizontalGlue(), gbc);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = UIFactory.getEmptyInsets();
            gbc.gridwidth = 0;
            panel.add((Component)auxPanel, gbc);
        }
        this.addVerticalGlue(panel);
        return panel;
    }

    @Override
    protected Message getInstructions() {
        return QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_PANEL_INSTRUCTIONS.get();
    }

    @Override
    protected Message getTitle() {
        return QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_PANEL_TITLE.get();
    }

    @Override
    public void endDisplay() {
        if (this.lastFocusComponent != null) {
            this.lastFocusComponent.requestFocusInWindow();
        }
    }

    private String getDefaultValue(FieldName fieldName) {
        String value;
        switch (fieldName) {
            case GLOBAL_ADMINISTRATOR_UID: {
                value = this.defaultUserData.getGlobalAdministratorUID();
                break;
            }
            case GLOBAL_ADMINISTRATOR_PWD: {
                value = this.defaultUserData.getGlobalAdministratorPassword();
                break;
            }
            case GLOBAL_ADMINISTRATOR_PWD_CONFIRM: {
                value = this.defaultUserData.getGlobalAdministratorPassword();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown field name: " + (Object)((Object)fieldName));
            }
        }
        return value;
    }

    private void populateLabelAndFieldMaps() {
        HashMap<FieldName, LabelFieldDescriptor> hm = new HashMap<FieldName, LabelFieldDescriptor>();
        hm.put(FieldName.GLOBAL_ADMINISTRATOR_UID, new LabelFieldDescriptor(QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_UID_LABEL.get(), QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_UID_TOOLTIP.get(), LabelFieldDescriptor.FieldType.TEXTFIELD, LabelFieldDescriptor.LabelType.PRIMARY, 15));
        hm.put(FieldName.GLOBAL_ADMINISTRATOR_PWD, new LabelFieldDescriptor(QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_PWD_LABEL.get(), QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_PWD_TOOLTIP.get(), LabelFieldDescriptor.FieldType.PASSWORD, LabelFieldDescriptor.LabelType.PRIMARY, 15));
        hm.put(FieldName.GLOBAL_ADMINISTRATOR_PWD_CONFIRM, new LabelFieldDescriptor(QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_PWD_CONFIRM_LABEL.get(), QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_PWD_CONFIRM_TOOLTIP.get(), LabelFieldDescriptor.FieldType.PASSWORD, LabelFieldDescriptor.LabelType.PRIMARY, 15));
        for (FieldName fieldName : hm.keySet()) {
            LabelFieldDescriptor desc = (LabelFieldDescriptor)hm.get((Object)fieldName);
            String defaultValue = this.getDefaultValue(fieldName);
            JTextComponent field = UIFactory.makeJTextComponent(desc, defaultValue);
            JLabel label = UIFactory.makeJLabel(desc);
            this.hmFields.put(fieldName, field);
            label.setLabelFor(field);
            this.hmLabels.put(fieldName, label);
        }
    }

    private JLabel getLabel(FieldName fieldName) {
        return this.hmLabels.get((Object)fieldName);
    }

    private JTextComponent getField(FieldName fieldName) {
        return this.hmFields.get((Object)fieldName);
    }

    private void addFocusListeners() {
        FocusListener l = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GlobalAdministratorPanel.this.lastFocusComponent = e.getComponent();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        for (JTextComponent tf : this.hmFields.values()) {
            tf.addFocusListener(l);
        }
        this.lastFocusComponent = this.getField(FieldName.GLOBAL_ADMINISTRATOR_PWD);
    }
}

