/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.opends.messages.Message;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;

public class Utilities {
    public static JPanel createBrowseButtonPanel(JLabel lbl, JTextComponent tf, JButton but) {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = UIFactory.makeJPanel();
        panel.setLayout(new GridBagLayout());
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 4;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        panel.add((Component)lbl, gbc);
        gbc.insets.left = 5;
        --gbc.gridwidth;
        gbc.weightx = 0.1;
        panel.add((Component)tf, gbc);
        gbc.insets.left = 10;
        gbc.gridwidth = -1;
        panel.add((Component)but, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        panel.add(Box.createHorizontalGlue(), gbc);
        return panel;
    }

    public static void setFrameIcon(JFrame frame) {
        UIFactory.IconType ic = Utils.isMacOS() ? UIFactory.IconType.MINIMIZED_MAC : UIFactory.IconType.MINIMIZED;
        frame.setIconImage(UIFactory.getImageIcon(ic).getImage());
    }

    public static void centerOnScreen(Component comp) {
        boolean multipleScreen;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)comp.getPreferredSize().getWidth();
        int height = (int)comp.getPreferredSize().getHeight();
        boolean bl = multipleScreen = screenSize.width / screenSize.height >= 2;
        if (multipleScreen) {
            comp.setLocation(screenSize.width / 4 - width / 2, (screenSize.height - height) / 2);
        } else {
            comp.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        }
    }

    public static void centerOnComponent(Window comp, Component ref) {
        comp.setLocationRelativeTo(ref);
    }

    public static boolean displayConfirmation(Component parent, Message msg, Message title) {
        return 0 == JOptionPane.showOptionDialog(parent, Utilities.wrapMsg(String.valueOf(msg), 100), String.valueOf(title), 0, 3, null, null, null);
    }

    public static void displayError(Component parent, Message msg, Message title) {
        JOptionPane.showMessageDialog(parent, Utilities.wrapMsg(String.valueOf(msg), 100), String.valueOf(title), 0);
    }

    public static void displayInformationMessage(JFrame parent, Message msg, Message title) {
        JOptionPane.showMessageDialog(parent, Utilities.wrapMsg(String.valueOf(msg), 100), String.valueOf(title), 1);
    }

    public static String wrapMsg(String msg, int width) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer lineTokenizer = new StringTokenizer(msg, "\n", true);
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken();
            if (line.equals("\n")) {
                buffer.append(line);
                continue;
            }
            if (line.length() < width) {
                buffer.append(line);
                continue;
            }
            StringBuilder lineBuffer = new StringBuilder();
            StringBuilder delimBuffer = new StringBuilder();
            StringTokenizer wordTokenizer = new StringTokenizer(line, " ", true);
            while (wordTokenizer.hasMoreTokens()) {
                String word = wordTokenizer.nextToken();
                if (word.equals(" ")) {
                    if (lineBuffer.length() <= 0) continue;
                    delimBuffer.append(word);
                    continue;
                }
                if (word.length() > width) {
                    if (lineBuffer.length() > 0) {
                        buffer.append((CharSequence)lineBuffer);
                        buffer.append("\n");
                        lineBuffer = new StringBuilder();
                    }
                    buffer.append(word);
                    if (wordTokenizer.hasMoreTokens()) {
                        wordTokenizer.nextToken();
                        if (wordTokenizer.hasMoreTokens()) {
                            buffer.append("\n");
                        }
                    }
                    if (delimBuffer.length() <= 0) continue;
                    delimBuffer = new StringBuilder();
                    continue;
                }
                int newLineLength = lineBuffer.length() + delimBuffer.length() + word.length();
                if (newLineLength < width) {
                    lineBuffer.append((CharSequence)delimBuffer).append(word);
                    if (delimBuffer.length() <= 0) continue;
                    delimBuffer = new StringBuilder();
                    continue;
                }
                buffer.append((CharSequence)lineBuffer);
                buffer.append("\n");
                lineBuffer = new StringBuilder();
                lineBuffer.append(word);
                if (delimBuffer.length() <= 0) continue;
                delimBuffer = new StringBuilder();
            }
            buffer.append((CharSequence)lineBuffer);
        }
        return buffer.toString();
    }
}

