/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.quicksetup.util.Utils;

public class UIKeyStore
extends KeyStore {
    private static KeyStore keyStore = null;
    private static final Logger LOG = Logger.getLogger(UIKeyStore.class.getName());

    private UIKeyStore() {
        super(null, null, null);
    }

    public static KeyStore getInstance() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (keyStore == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String keyStorePath = UIKeyStore.getKeyStorePath();
            File f = new File(keyStorePath);
            if (!f.exists()) {
                LOG.log(Level.INFO, "Path " + keyStorePath + " does not exist");
                keyStorePath = null;
            } else if (f.isDirectory()) {
                LOG.log(Level.SEVERE, "Path " + keyStorePath + " is a directory");
                keyStorePath = null;
            } else if (!f.canRead()) {
                LOG.log(Level.SEVERE, "Path " + keyStorePath + " is not readable");
                keyStorePath = null;
            } else if (!f.canWrite()) {
                LOG.log(Level.SEVERE, "Path " + keyStorePath + " is not writable");
                keyStorePath = null;
            }
            if (keyStorePath != null) {
                FileInputStream fos = new FileInputStream(keyStorePath);
                try {
                    keyStore.load(fos, null);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Error reading key store on " + keyStorePath, t);
                    keyStore.load(null, null);
                }
                fos.close();
            } else {
                keyStore.load(null, null);
            }
            UIKeyStore.loadLocalAdminTrustStore(keyStore);
        }
        return keyStore;
    }

    public static void acceptCertificate(X509Certificate[] chain) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        LOG.log(Level.INFO, "Accepting certificate chain.");
        KeyStore k = UIKeyStore.getInstance();
        for (X509Certificate aChain : chain) {
            if (UIKeyStore.containsCertificate(aChain, k)) continue;
            String alias = aChain.getSubjectDN().getName();
            int j = 1;
            while (k.containsAlias(alias)) {
                alias = aChain.getSubjectDN().getName() + "-" + j;
                ++j;
            }
            k.setCertificateEntry(alias, aChain);
        }
        String keyStorePath = UIKeyStore.getKeyStorePath();
        File f = new File(keyStorePath);
        if (!f.exists()) {
            Utils.createFile(f);
        }
        FileOutputStream fos = new FileOutputStream(UIKeyStore.getKeyStorePath(), false);
        k.store(fos, new char[0]);
        fos.close();
    }

    private static String getKeyStorePath() {
        return System.getProperty("user.home") + File.separator + ".opendj" + File.separator + "gui-keystore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLocalAdminTrustStore(KeyStore keyStore) {
        String adminTrustStorePath = UIKeyStore.getLocalAdminTrustStorePath();
        File f = new File(adminTrustStorePath);
        if (!f.exists()) {
            LOG.log(Level.INFO, "Path " + adminTrustStorePath + " does not exist");
            adminTrustStorePath = null;
        } else if (f.isDirectory()) {
            LOG.log(Level.SEVERE, "Path " + adminTrustStorePath + " is a directory");
            adminTrustStorePath = null;
        } else if (!f.canRead()) {
            LOG.log(Level.SEVERE, "Path " + adminTrustStorePath + " is not readable");
            adminTrustStorePath = null;
        }
        if (adminTrustStorePath != null) {
            FileInputStream fos = null;
            try {
                fos = new FileInputStream(adminTrustStorePath);
                KeyStore adminKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                adminKeyStore.load(fos, null);
                Enumeration<String> aliases = adminKeyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (adminKeyStore.isCertificateEntry(alias)) {
                        keyStore.setCertificateEntry(alias, adminKeyStore.getCertificate(alias));
                        continue;
                    }
                    keyStore.setEntry(alias, adminKeyStore.getEntry(alias, null), null);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error reading admin key store on " + adminTrustStorePath, t);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Error closing admin key store on " + adminTrustStorePath, t);
                }
            }
        }
    }

    private static String getLocalAdminTrustStorePath() {
        String instancePath = Utils.getInstancePathFromInstallPath(Utils.getInstallPathFromClasspath());
        return instancePath + File.separator + "config" + File.separator + "admin-truststore";
    }

    private static boolean containsCertificate(X509Certificate cert, KeyStore keyStore) throws KeyStoreException {
        boolean found = false;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements() && !found) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            Certificate c = keyStore.getCertificate(alias);
            found = c.equals(cert);
        }
        return found;
    }
}

