/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.EnumSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.util.Validator;

public final class AttributeTypePropertyDefinition
extends PropertyDefinition<AttributeType> {
    private static boolean isCheckSchema = true;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    public static boolean isCheckSchema() {
        return isCheckSchema;
    }

    public static void setCheckSchema(boolean value) {
        isCheckSchema = value;
    }

    private AttributeTypePropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<AttributeType> defaultBehavior) {
        super(d, AttributeType.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitAttributeType(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, AttributeType value, P p) {
        return v.visitAttributeType(this, value, p);
    }

    @Override
    public int compare(AttributeType o1, AttributeType o2) {
        return o1.getNameOrOID().compareToIgnoreCase(o2.getNameOrOID());
    }

    @Override
    public AttributeType decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        String name = value.trim().toLowerCase();
        AttributeType type = DirectoryServer.getAttributeType(name, !isCheckSchema);
        if (type == null) {
            throw new IllegalPropertyValueStringException(this, value);
        }
        try {
            this.validateValue(type);
            return type;
        }
        catch (IllegalPropertyValueException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
    }

    @Override
    public String encodeValue(AttributeType value) throws IllegalPropertyValueException {
        return value.getNameOrOID();
    }

    @Override
    public void validateValue(AttributeType value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
    }

    public static class Builder
    extends PropertyDefinition.AbstractBuilder<AttributeType, AttributeTypePropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected AttributeTypePropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<AttributeType> defaultBehavior) {
            return new AttributeTypePropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

