/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import org.opends.admin.ads.util.ApplicationKeyManager;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.AdministrationConnectorCfg;
import org.opends.server.admin.std.server.FileBasedTrustManagerProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.TrustManagerProviderCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public final class SecureConnectionCliArgs {
    public StringArgument hostNameArg = null;
    public IntegerArgument portArg = null;
    public StringArgument bindDnArg = null;
    public StringArgument adminUidArg = null;
    public FileBasedArgument bindPasswordFileArg = null;
    public StringArgument bindPasswordArg = null;
    public BooleanArgument trustAllArg = null;
    public StringArgument trustStorePathArg = null;
    public StringArgument trustStorePasswordArg = null;
    public FileBasedArgument trustStorePasswordFileArg = null;
    public StringArgument keyStorePathArg = null;
    public StringArgument keyStorePasswordArg = null;
    public FileBasedArgument keyStorePasswordFileArg = null;
    public StringArgument certNicknameArg = null;
    public BooleanArgument useSSLArg = null;
    public BooleanArgument useStartTLSArg = null;
    public StringArgument saslOptionArg = null;
    public IntegerArgument connectTimeoutArg = null;
    private LinkedHashSet<Argument> argList = null;
    private ApplicationTrustManager trustManager;
    private boolean configurationInitialized = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static String EOL = System.getProperty("line.separator");
    private static final Logger LOG = Logger.getLogger(SecureConnectionCliArgs.class.getName());
    private boolean alwaysSSL = false;

    public SecureConnectionCliArgs(boolean alwaysSSL) {
        if (alwaysSSL) {
            this.alwaysSSL = true;
        }
    }

    public boolean argumentsPresent() {
        boolean present = false;
        if (this.argList != null) {
            for (Argument arg : this.argList) {
                if (!arg.isPresent()) continue;
                present = true;
                break;
            }
        }
        return present;
    }

    public String getAdministratorUID() {
        if (this.adminUidArg.isPresent()) {
            return this.adminUidArg.getValue();
        }
        return this.adminUidArg.getDefaultValue();
    }

    public boolean useAdminUID() {
        return !this.adminUidArg.isHidden();
    }

    public String getBindDN() {
        if (this.bindDnArg.isPresent()) {
            return this.bindDnArg.getValue();
        }
        return this.bindDnArg.getDefaultValue();
    }

    public String getBindPassword(String dn, OutputStream out, OutputStream err, StringArgument clearArg, FileBasedArgument fileArg) {
        if (clearArg.isPresent()) {
            String bindPasswordValue = clearArg.getValue();
            if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
                try {
                    out.write(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(dn).getBytes());
                    out.flush();
                    char[] pwChars = PasswordReader.readPassword();
                    bindPasswordValue = new String(pwChars);
                }
                catch (Exception ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                    try {
                        err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                        err.write(EOL.getBytes());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return null;
                }
            }
            return bindPasswordValue;
        }
        if (fileArg.isPresent()) {
            return fileArg.getValue();
        }
        try {
            out.write(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(dn).toString().getBytes());
            out.flush();
            char[] pwChars = PasswordReader.readPassword();
            return new String(pwChars);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            try {
                err.write(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH).getBytes());
                err.write(EOL.getBytes());
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
    }

    public String getBindPassword(String dn, OutputStream out, OutputStream err) {
        return this.getBindPassword(dn, out, err, this.bindPasswordArg, this.bindPasswordFileArg);
    }

    public String getBindPassword(StringArgument clearArg, FileBasedArgument fileArg) {
        String pwd = clearArg.isPresent() ? clearArg.getValue() : (fileArg.isPresent() ? fileArg.getValue() : null);
        return pwd;
    }

    public String getBindPassword() {
        return this.getBindPassword(this.bindPasswordArg, this.bindPasswordFileArg);
    }

    public LinkedHashSet<Argument> createGlobalArguments() throws ArgumentException {
        String defaultHostName;
        this.argList = new LinkedHashSet();
        this.useSSLArg = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_DESCRIPTION_USE_SSL.get());
        this.useSSLArg.setPropertyName("useSSL");
        if (!this.alwaysSSL) {
            this.argList.add(this.useSSLArg);
        } else {
            this.useSSLArg.setPresent(true);
        }
        this.useStartTLSArg = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_DESCRIPTION_START_TLS.get());
        this.useStartTLSArg.setPropertyName("useStartTLS");
        if (!this.alwaysSSL) {
            this.argList.add(this.useStartTLSArg);
        }
        try {
            defaultHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            defaultHostName = "Unknown (" + e + ")";
        }
        this.hostNameArg = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), defaultHostName, null, ToolMessages.INFO_DESCRIPTION_HOST.get());
        this.hostNameArg.setPropertyName("hostname");
        this.argList.add(this.hostNameArg);
        Message portDescription = ToolMessages.INFO_DESCRIPTION_PORT.get();
        if (this.alwaysSSL) {
            portDescription = ToolMessages.INFO_DESCRIPTION_ADMIN_PORT.get();
        }
        this.portArg = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 4444, null, true, 1, true, 65535, portDescription);
        this.portArg.setPropertyName("port");
        this.argList.add(this.portArg);
        this.bindDnArg = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), "cn=Directory Manager", null, ToolMessages.INFO_DESCRIPTION_BINDDN.get());
        this.bindDnArg.setPropertyName("bindDN");
        this.argList.add(this.bindDnArg);
        this.adminUidArg = new StringArgument("adminUID", Character.valueOf('I'), "adminUID", false, false, true, ToolMessages.INFO_ADMINUID_PLACEHOLDER.get(), "admin", null, AdminToolMessages.INFO_DESCRIPTION_ADMIN_UID.get());
        this.adminUidArg.setPropertyName("adminUID");
        this.adminUidArg.setHidden(true);
        this.bindPasswordArg = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
        this.bindPasswordArg.setPropertyName("bindPassword");
        this.argList.add(this.bindPasswordArg);
        this.bindPasswordFileArg = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
        this.bindPasswordFileArg.setPropertyName("bindPasswordFile");
        this.argList.add(this.bindPasswordFileArg);
        this.saslOptionArg = new StringArgument("sasloption", Character.valueOf('o'), "saslOption", false, true, true, ToolMessages.INFO_SASL_OPTION_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDAP_CONN_DESCRIPTION_SASLOPTIONS.get());
        this.saslOptionArg.setPropertyName("saslOption");
        this.argList.add(this.saslOptionArg);
        this.trustAllArg = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", ToolMessages.INFO_DESCRIPTION_TRUSTALL.get());
        this.trustAllArg.setPropertyName("trustAll");
        this.argList.add(this.trustAllArg);
        this.trustStorePathArg = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, ToolMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get());
        this.trustStorePathArg.setPropertyName("trustStorePath");
        this.argList.add(this.trustStorePathArg);
        this.trustStorePasswordArg = new StringArgument("trustStorePassword", Character.valueOf('T'), "trustStorePassword", false, false, true, ToolMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get());
        this.trustStorePasswordArg.setPropertyName("trustStorePassword");
        this.argList.add(this.trustStorePasswordArg);
        this.trustStorePasswordFileArg = new FileBasedArgument("trustStorePasswordFile", Character.valueOf('U'), "trustStorePasswordFile", false, false, ToolMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get());
        this.trustStorePasswordFileArg.setPropertyName("trustStorePasswordFile");
        this.argList.add(this.trustStorePasswordFileArg);
        this.keyStorePathArg = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPATH.get());
        this.keyStorePathArg.setPropertyName("keyStorePath");
        this.argList.add(this.keyStorePathArg);
        this.keyStorePasswordArg = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, ToolMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD.get());
        this.keyStorePasswordArg.setPropertyName("keyStorePassword");
        this.argList.add(this.keyStorePasswordArg);
        this.keyStorePasswordFileArg = new FileBasedArgument("keystorePasswordFile", Character.valueOf('u'), "keyStorePasswordFile", false, false, ToolMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD_FILE.get());
        this.keyStorePasswordFileArg.setPropertyName("keyStorePasswordFile");
        this.argList.add(this.keyStorePasswordFileArg);
        this.certNicknameArg = new StringArgument("certNickname", Character.valueOf('N'), "certNickname", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
        this.certNicknameArg.setPropertyName("certNickname");
        this.argList.add(this.certNicknameArg);
        int defaultTimeout = ConnectionUtils.getDefaultLDAPTimeout();
        this.connectTimeoutArg = new IntegerArgument("connectTimeout", null, "connectTimeout", false, false, true, ToolMessages.INFO_TIMEOUT_PLACEHOLDER.get(), defaultTimeout, null, true, 0, false, Integer.MAX_VALUE, ToolMessages.INFO_DESCRIPTION_CONNECTION_TIMEOUT.get());
        this.connectTimeoutArg.setPropertyName("connectTimeout");
        this.argList.add(this.connectTimeoutArg);
        return this.argList;
    }

    public String getHostName() {
        if (this.hostNameArg.isPresent()) {
            return this.hostNameArg.getValue();
        }
        return this.hostNameArg.getDefaultValue();
    }

    public String getPort() {
        if (this.portArg.isPresent()) {
            return this.portArg.getValue();
        }
        return this.portArg.getDefaultValue();
    }

    public int validateGlobalOptions(MessageBuilder buf) {
        Message message;
        String value;
        Message message2;
        ArrayList<Message> errors = new ArrayList<Message>();
        if (this.bindPasswordArg.isPresent() && this.bindPasswordFileArg.isPresent()) {
            message2 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.bindPasswordArg.getLongIdentifier(), this.bindPasswordFileArg.getLongIdentifier());
            errors.add(message2);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePathArg.isPresent()) {
            message2 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustAllArg.getLongIdentifier(), this.trustStorePathArg.getLongIdentifier());
            errors.add(message2);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordArg.isPresent()) {
            message2 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustAllArg.getLongIdentifier(), this.trustStorePasswordArg.getLongIdentifier());
            errors.add(message2);
        }
        if (this.trustAllArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            message2 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustAllArg.getLongIdentifier(), this.trustStorePasswordFileArg.getLongIdentifier());
            errors.add(message2);
        }
        if (this.trustStorePasswordArg.isPresent() && this.trustStorePasswordFileArg.isPresent()) {
            message2 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.trustStorePasswordArg.getLongIdentifier(), this.trustStorePasswordFileArg.getLongIdentifier());
            errors.add(message2);
        }
        if (this.trustStorePathArg.isPresent()) {
            value = this.trustStorePathArg.getValue();
            if (!this.canRead(this.trustStorePathArg.getValue())) {
                message = ToolMessages.ERR_CANNOT_READ_TRUSTSTORE.get(value);
                errors.add(message);
            }
        }
        if (this.keyStorePathArg.isPresent()) {
            value = this.keyStorePathArg.getValue();
            if (!this.canRead(this.trustStorePathArg.getValue())) {
                message = ToolMessages.ERR_CANNOT_READ_KEYSTORE.get(value);
                errors.add(message);
            }
        }
        if (this.useStartTLSArg.isPresent() && this.useSSLArg.isPresent()) {
            message2 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.useStartTLSArg.getLongIdentifier(), this.useSSLArg.getLongIdentifier());
            errors.add(message2);
        }
        if (errors.size() > 0) {
            for (Message error : errors) {
                if (buf.length() > 0) {
                    buf.append(EOL);
                }
                buf.append(error);
            }
            return DsFrameworkCliReturnCode.CONFLICTING_ARGS.getReturnCode();
        }
        return DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode();
    }

    public int validateGlobalOptions(PrintStream err) {
        MessageBuilder buf = new MessageBuilder();
        int returnValue = this.validateGlobalOptions(buf);
        if (buf.length() > 0) {
            err.println(StaticUtils.wrapText(buf.toString(), ServerConstants.MAX_LINE_WIDTH));
        }
        return returnValue;
    }

    public boolean useSSL() {
        return this.useSSLArg.isPresent() || this.alwaysSSL();
    }

    public boolean useStartTLS() {
        return this.useStartTLSArg.isPresent();
    }

    public boolean alwaysSSL() {
        return this.alwaysSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationTrustManager getTrustManager() {
        if (this.trustManager == null) {
            KeyStore truststore = null;
            if (this.trustAllArg.isPresent()) {
                return null;
            }
            if (this.trustStorePathArg.isPresent()) {
                FileInputStream fos = null;
                try {
                    fos = new FileInputStream(this.trustStorePathArg.getValue());
                    String trustStorePasswordStringValue = null;
                    char[] trustStorePasswordValue = null;
                    if (this.trustStorePasswordArg.isPresent()) {
                        trustStorePasswordStringValue = this.trustStorePasswordArg.getValue();
                    } else if (this.trustStorePasswordFileArg.isPresent()) {
                        trustStorePasswordStringValue = this.trustStorePasswordFileArg.getValue();
                    }
                    if (trustStorePasswordStringValue != null) {
                        trustStorePasswordStringValue = System.getProperty("javax.net.ssl.trustStorePassword");
                    }
                    if (trustStorePasswordStringValue != null) {
                        trustStorePasswordValue = trustStorePasswordStringValue.toCharArray();
                    }
                    truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                    truststore.load(fos, trustStorePasswordValue);
                }
                catch (KeyStoreException e) {
                    LOG.log(Level.WARNING, "Error with the truststore", e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOG.log(Level.WARNING, "Error with the truststore", e);
                }
                catch (CertificateException e) {
                    LOG.log(Level.WARNING, "Error with the truststore", e);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Error with the truststore", e);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            this.trustManager = new ApplicationTrustManager(truststore);
        }
        return this.trustManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyManager getKeyManager() {
        KeyStore keyStore = null;
        String keyStorePasswordStringValue = null;
        char[] keyStorePasswordValue = null;
        if (this.keyStorePathArg.isPresent()) {
            FileInputStream fos = null;
            try {
                fos = new FileInputStream(this.keyStorePathArg.getValue());
                if (this.keyStorePasswordArg.isPresent()) {
                    keyStorePasswordStringValue = this.keyStorePasswordArg.getValue();
                } else if (this.keyStorePasswordFileArg.isPresent()) {
                    keyStorePasswordStringValue = this.keyStorePasswordFileArg.getValue();
                }
                if (keyStorePasswordStringValue != null) {
                    keyStorePasswordValue = keyStorePasswordStringValue.toCharArray();
                }
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(fos, keyStorePasswordValue);
            }
            catch (KeyStoreException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
            char[] password = null;
            if (keyStorePasswordStringValue != null) {
                password = keyStorePasswordStringValue.toCharArray();
            }
            ApplicationKeyManager akm = new ApplicationKeyManager(keyStore, password);
            if (this.certNicknameArg.isPresent()) {
                return new SelectableCertificateKeyManager(akm, this.certNicknameArg.getValue());
            }
            return akm;
        }
        return null;
    }

    private boolean canRead(String path) {
        File file = new File(path);
        boolean canRead = file.exists() ? file.canRead() : false;
        return canRead;
    }

    public String getTruststoreFileFromConfig() throws ConfigException {
        String trustManagerStr;
        RootCfg root;
        String truststoreFileAbsolute = null;
        TrustManagerProviderCfg trustManagerCfg = null;
        AdministrationConnectorCfg administrationConnectorCfg = null;
        boolean couldInitializeConfig = this.configurationInitialized;
        if (!this.configurationInitialized) {
            couldInitializeConfig = this.initializeConfiguration();
        }
        if (couldInitializeConfig && (trustManagerCfg = (root = ServerManagementContext.getInstance().getRootConfiguration()).getTrustManagerProvider(trustManagerStr = (administrationConnectorCfg = root.getAdministrationConnector()).getTrustManagerProvider())) instanceof FileBasedTrustManagerProviderCfg) {
            FileBasedTrustManagerProviderCfg fileBasedTrustManagerCfg = (FileBasedTrustManagerProviderCfg)trustManagerCfg;
            String truststoreFile = fileBasedTrustManagerCfg.getTrustStoreFile();
            truststoreFileAbsolute = truststoreFile.startsWith(File.separator) ? truststoreFile : DirectoryServer.getInstanceRoot() + File.separator + truststoreFile;
            File f = new File(truststoreFileAbsolute);
            if (!f.exists() || !f.canRead() || f.isDirectory()) {
                truststoreFileAbsolute = null;
            } else {
                try {
                    truststoreFileAbsolute = f.getCanonicalPath();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return truststoreFileAbsolute;
    }

    public int getAdminPortFromConfig() throws ConfigException {
        int port;
        boolean couldInitializeConfiguration = this.configurationInitialized;
        if (!this.configurationInitialized) {
            couldInitializeConfiguration = this.initializeConfiguration();
        }
        if (couldInitializeConfiguration) {
            RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
            port = root.getAdministrationConnector().getListenPort();
        } else {
            port = 4444;
        }
        return port;
    }

    private boolean initializeConfiguration() {
        try {
            ServerManagementContext.getInstance().getRootConfiguration().getAdministrationConnector();
        }
        catch (Throwable th) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
                DirectoryServer.getInstance().initializeConfiguration();
            }
            catch (Exception ex) {
                return false;
            }
        }
        this.configurationInitialized = true;
        return true;
    }

    public int getPortFromConfig() {
        int portNumber;
        if (this.alwaysSSL()) {
            portNumber = 4444;
            try {
                portNumber = this.getAdminPortFromConfig();
            }
            catch (ConfigException configException) {}
        } else {
            portNumber = 636;
        }
        return portNumber;
    }

    public void initArgumentsWithConfiguration() throws ConfigException {
        int portNumber = this.getPortFromConfig();
        this.portArg.setDefaultValue(String.valueOf(portNumber));
        String truststoreFileAbsolute = this.getTruststoreFileFromConfig();
        if (truststoreFileAbsolute != null) {
            this.trustStorePathArg.setDefaultValue(truststoreFileAbsolute);
        }
    }
}

