/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.DecodingException;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.util.Validator;

public class ConstraintViolationException
extends DecodingException {
    private static final long serialVersionUID = -4902443848460011875L;
    private final ServerManagedObject<?> managedObject;
    private final Collection<Message> messages;

    private static Message getDefaultMessage(Collection<Message> messages) {
        Validator.ensureNotNull(messages);
        Validator.ensureTrue(!messages.isEmpty());
        if (messages.size() == 1) {
            return AdminMessages.ERR_CONSTRAINT_VIOLATION_EXCEPTION_SINGLE.get(messages.iterator().next());
        }
        return AdminMessages.ERR_CONSTRAINT_VIOLATION_EXCEPTION_PLURAL.get(ConstraintViolationException.getSingleMessage(messages));
    }

    private static Message getSingleMessage(Collection<Message> messages) {
        if (messages.size() == 1) {
            return messages.iterator().next();
        }
        MessageBuilder builder = new MessageBuilder();
        boolean isFirst = true;
        for (Message m : messages) {
            if (!isFirst) {
                builder.append(";  ");
            }
            builder.append(m);
            isFirst = false;
        }
        return builder.toMessage();
    }

    public ConstraintViolationException(ServerManagedObject<?> managedObject, Collection<Message> messages) {
        super(ConstraintViolationException.getDefaultMessage(messages));
        this.managedObject = managedObject;
        this.messages = new ArrayList<Message>(messages);
    }

    public ConstraintViolationException(ServerManagedObject<?> managedObject, Message message) {
        this(managedObject, Collections.singleton(message));
    }

    public Collection<Message> getMessages() {
        return Collections.unmodifiableCollection(this.messages);
    }

    public Message getMessagesAsSingleMessage() {
        return ConstraintViolationException.getSingleMessage(this.messages);
    }

    public ServerManagedObject<?> getManagedObject() {
        return this.managedObject;
    }
}

