/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DefinitionResolver;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyNotFoundException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.Reference;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.admin.server.ConfigExceptionFactory;
import org.opends.server.admin.server.ConstraintViolationException;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.server.ServerManagedObjectDecodingException;
import org.opends.server.admin.std.meta.RootCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

public final class ServerManagementContext {
    private static final ServerManagementContext INSTANCE = new ServerManagementContext();
    private static final ServerManagedObject<RootCfg> ROOT = new ServerManagedObject<RootCfg>(ManagedObjectPath.emptyPath(), RootCfgDefn.getInstance(), Collections.<PropertyDefinition<?>, SortedSet<?>>emptyMap(), null);
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static ServerManagementContext getInstance() {
        return INSTANCE;
    }

    private ServerManagementContext() {
    }

    public <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<? extends S> getManagedObject(ManagedObjectPath<C, S> path) throws ConfigException {
        if (path.isEmpty()) {
            return this.getRootConfigurationManagedObject();
        }
        DN targetDN = DNBuilder.create(path);
        ConfigEntry configEntry = this.getManagedObjectConfigEntry(targetDN);
        try {
            ServerManagedObject<S> managedObject = this.decode(path, configEntry);
            managedObject.ensureIsUsable();
            return managedObject;
        }
        catch (DefinitionDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(targetDN, e);
        }
        catch (ServerManagedObjectDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(e);
        }
        catch (ConstraintViolationException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(e);
        }
    }

    public <C extends ConfigurationClient, S extends Configuration, PD> PD getPropertyValue(ManagedObjectPath<C, S> path, PropertyDefinition<PD> pd) throws IllegalArgumentException, ConfigException, PropertyException {
        SortedSet<PD> values = this.getPropertyValues(path, pd);
        if (values.isEmpty()) {
            return null;
        }
        return values.first();
    }

    public <C extends ConfigurationClient, S extends Configuration, PD> SortedSet<PD> getPropertyValues(ManagedObjectPath<C, S> path, PropertyDefinition<PD> pd) throws IllegalArgumentException, ConfigException, PropertyException {
        ManagedObjectDefinition<C, S> mod;
        AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
        PropertyDefinition<?> tmp = d.getPropertyDefinition(pd.getName());
        if (tmp != pd) {
            throw new IllegalArgumentException("The property " + pd.getName() + " is not associated with a " + d.getName());
        }
        DN dn = DNBuilder.create(path);
        ConfigEntry configEntry = this.getManagedObjectConfigEntry(dn);
        MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
        try {
            mod = d.resolveManagedObjectDefinition(resolver);
        }
        catch (DefinitionDecodingException e) {
            throw ConfigExceptionFactory.getInstance().createDecodingExceptionAdaptor(dn, e);
        }
        pd = mod.getPropertyDefinition(pd.getName());
        List<AttributeValue> values = this.getAttribute(mod, pd, configEntry);
        return this.decodeProperty(path.asSubType(mod), pd, values, null);
    }

    public RootCfg getRootConfiguration() {
        return this.getRootConfigurationManagedObject().getConfiguration();
    }

    public ServerManagedObject<RootCfg> getRootConfigurationManagedObject() {
        return ROOT;
    }

    public <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd) throws IllegalArgumentException {
        ConfigEntry configEntry;
        this.validateRelationDefinition(parent, rd);
        DN targetDN = DNBuilder.create(parent, rd);
        try {
            configEntry = DirectoryServer.getConfigEntry(targetDN);
        }
        catch (ConfigException e) {
            return new String[0];
        }
        if (configEntry == null) {
            return new String[0];
        }
        Set children = configEntry.getChildren().keySet();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (DN child : children) {
            AttributeValue av = child.getRDN().getAttributeValue(0);
            names.add(av.getValue().toString().trim());
        }
        return names.toArray(new String[names.size()]);
    }

    public <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd) throws IllegalArgumentException {
        ConfigEntry configEntry;
        this.validateRelationDefinition(parent, rd);
        DN targetDN = DNBuilder.create(parent, rd);
        try {
            configEntry = DirectoryServer.getConfigEntry(targetDN);
        }
        catch (ConfigException e) {
            return new String[0];
        }
        if (configEntry == null) {
            return new String[0];
        }
        Set children = configEntry.getChildren().keySet();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (DN child : children) {
            AttributeValue av = child.getRDN().getAttributeValue(0);
            names.add(((Object)av).toString().trim());
        }
        return names.toArray(new String[names.size()]);
    }

    public boolean managedObjectExists(ManagedObjectPath<?, ?> path) {
        DN targetDN = DNBuilder.create(path);
        try {
            return this.getManagedObjectConfigEntry(targetDN) != null;
        }
        catch (ConfigException e) {
            return false;
        }
    }

    <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<? extends S> decode(ManagedObjectPath<C, S> path, ConfigEntry configEntry) throws DefinitionDecodingException, ServerManagedObjectDecodingException {
        return this.decode(path, configEntry, null);
    }

    <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<? extends S> decode(ManagedObjectPath<C, S> path, ConfigEntry configEntry, ConfigEntry newConfigEntry) throws DefinitionDecodingException, ServerManagedObjectDecodingException {
        MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
        AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
        ManagedObjectDefinition<C, S> mod = d.resolveManagedObjectDefinition(resolver);
        LinkedList<PropertyException> exceptions = new LinkedList<PropertyException>();
        HashMap properties = new HashMap();
        for (PropertyDefinition<?> pd : mod.getAllPropertyDefinitions()) {
            List<AttributeValue> values = this.getAttribute(mod, pd, configEntry);
            try {
                SortedSet<?> pvalues = this.decodeProperty(path, pd, values, newConfigEntry);
                properties.put(pd, pvalues);
            }
            catch (PropertyException e) {
                exceptions.add(e);
            }
        }
        ServerManagedObject<S> mo = this.decodeAux(path, mod, properties, configEntry);
        if (exceptions.isEmpty()) {
            return mo;
        }
        throw new ServerManagedObjectDecodingException(mo, exceptions);
    }

    private <C extends ConfigurationClient, S extends Configuration> ServerManagedObject<S> decodeAux(ManagedObjectPath<? super C, ? super S> path, ManagedObjectDefinition<C, S> d, Map<PropertyDefinition<?>, SortedSet<?>> properties, ConfigEntry configEntry) {
        ManagedObjectPath<C, S> newPath = path.asSubType(d);
        return new ServerManagedObject<S>(newPath, d, properties, configEntry);
    }

    private <T> SortedSet<T> decodeProperty(ManagedObjectPath<?, ?> path, PropertyDefinition<T> pd, List<AttributeValue> values, ConfigEntry newConfigEntry) throws PropertyException {
        PropertyException exception = null;
        TreeSet<T> pvalues = new TreeSet<T>(pd);
        if (!values.isEmpty()) {
            for (AttributeValue value : values) {
                try {
                    pvalues.add(ValueDecoder.decode(pd, value));
                }
                catch (IllegalPropertyValueStringException e) {
                    exception = e;
                }
            }
        } else {
            try {
                pvalues.addAll(this.getDefaultValues(path, pd, newConfigEntry));
            }
            catch (DefaultBehaviorException e) {
                exception = e;
            }
        }
        if (pvalues.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
            exception = new PropertyIsSingleValuedException(pd);
            Object value = pvalues.first();
            pvalues.clear();
            pvalues.add(value);
        }
        if (pvalues.isEmpty() && pd.hasOption(PropertyOption.MANDATORY) && exception == null) {
            exception = new PropertyIsMandatoryException(pd);
        }
        if (exception != null) {
            throw exception;
        }
        return pvalues;
    }

    private List<AttributeValue> getAttribute(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd, ConfigEntry configEntry) {
        String attrID = LDAPProfile.getInstance().getAttributeName(d, pd);
        AttributeType type = DirectoryServer.getAttributeType(attrID, true);
        AttributeValueDecoder<AttributeValue> decoder = new AttributeValueDecoder<AttributeValue>(){

            @Override
            public AttributeValue decode(AttributeValue value) throws DirectoryException {
                return value;
            }
        };
        LinkedList<AttributeValue> values = new LinkedList<AttributeValue>();
        try {
            configEntry.getEntry().getAttributeValues(type, decoder, values);
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
        return values;
    }

    private <T> Collection<T> getDefaultValues(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd, ConfigEntry newConfigEntry) throws DefaultBehaviorException {
        DefaultValueFinder v = new DefaultValueFinder(newConfigEntry);
        return v.find(p, pd);
    }

    private ConfigEntry getManagedObjectConfigEntry(DN dn) throws ConfigException {
        ConfigEntry configEntry;
        try {
            configEntry = DirectoryServer.getConfigEntry(dn);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_GET_MANAGED_OBJECT.get(String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        if (configEntry == null) {
            Message message = AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DOES_NOT_EXIST.get(String.valueOf(dn));
            throw new ConfigException(message);
        }
        return configEntry;
    }

    private void validateRelationDefinition(ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> rd) throws IllegalArgumentException {
        AbstractManagedObjectDefinition<?, ?> d = path.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + d.getName());
        }
    }

    private static final class ValueDecoder
    extends PropertyDefinitionVisitor<Object, String> {
        public static <PD> PD decode(PropertyDefinition<PD> pd, AttributeValue value) throws IllegalPropertyValueStringException {
            String s = value.getValue().toString();
            return pd.castValue(pd.accept(new ValueDecoder(), s));
        }

        private ValueDecoder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> Object visitAggregation(AggregationPropertyDefinition<C, S> d, String p) {
            try {
                Reference<C, S> reference = Reference.parseDN(d.getParentPath(), d.getRelationDefinition(), p);
                return reference.getName();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalPropertyValueStringException(d, p);
            }
        }

        @Override
        public <T> Object visitUnknown(PropertyDefinition<T> d, String p) throws UnknownPropertyDefinitionException {
            return d.decodeValue(p);
        }
    }

    private class MyDefinitionResolver
    implements DefinitionResolver {
        private final ConfigEntry entry;

        private MyDefinitionResolver(ConfigEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean matches(AbstractManagedObjectDefinition<?, ?> d) {
            String oc = LDAPProfile.getInstance().getObjectClass(d);
            return this.entry.hasObjectClass(oc);
        }
    }

    private class DefaultValueFinder<T>
    implements DefaultBehaviorProviderVisitor<T, Collection<T>, Void> {
        private DefaultBehaviorException exception = null;
        private final ConfigEntry newConfigEntry;
        private ManagedObjectPath<?, ?> nextPath = null;
        private PropertyDefinition<T> nextProperty = null;

        private DefaultValueFinder(ConfigEntry newConfigEntry) {
            this.newConfigEntry = newConfigEntry;
        }

        @Override
        public Collection<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        @Override
        public Collection<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
            Collection<String> stringValues = d.getDefaultValues();
            ArrayList<T> values = new ArrayList<T>(stringValues.size());
            for (String stringValue : stringValues) {
                try {
                    values.add(this.nextProperty.decodeValue(stringValue));
                }
                catch (IllegalPropertyValueStringException e) {
                    this.exception = new DefaultBehaviorException(this.nextProperty, (Throwable)e);
                    break;
                }
            }
            return values;
        }

        @Override
        public Collection<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(this.nextPath), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        private Collection<T> find(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd) throws DefaultBehaviorException {
            this.nextPath = p;
            this.nextProperty = pd;
            Collection values = (Collection)this.nextProperty.getDefaultBehaviorProvider().accept(this, null);
            if (this.exception != null) {
                throw this.exception;
            }
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                throw new DefaultBehaviorException(pd, (Throwable)new PropertyIsSingleValuedException(pd));
            }
            return values;
        }

        private Collection<T> getInheritedProperty(ManagedObjectPath target, AbstractManagedObjectDefinition<?, ?> d, String propertyName) throws DefaultBehaviorException {
            AbstractManagedObjectDefinition supr = target.getManagedObjectDefinition();
            if (!supr.isParentOf(d)) {
                throw new DefaultBehaviorException(this.nextProperty, (Throwable)new DefinitionDecodingException(supr, DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION));
            }
            PropertyDefinition<T> pd1 = this.nextProperty;
            try {
                PropertyDefinition pd2;
                DN dn = DNBuilder.create(target);
                ConfigEntry configEntry = this.newConfigEntry != null && this.newConfigEntry.getDN().equals(dn) ? this.newConfigEntry : ServerManagementContext.this.getManagedObjectConfigEntry(dn);
                MyDefinitionResolver resolver = new MyDefinitionResolver(configEntry);
                ManagedObjectDefinition<?, ?> mod = d.resolveManagedObjectDefinition(resolver);
                try {
                    PropertyDefinition<?> pdTmp = mod.getPropertyDefinition(propertyName);
                    pd2 = (PropertyDefinition)pd1.getClass().cast(pdTmp);
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                catch (ClassCastException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                List values = ServerManagementContext.this.getAttribute(mod, pd2, configEntry);
                if (values.isEmpty()) {
                    Collection<T> tmp = this.find(target, pd2);
                    ArrayList<T> pvalues = new ArrayList<T>(tmp.size());
                    for (T value : tmp) {
                        pd1.validateValue(value);
                        pvalues.add(value);
                    }
                    return pvalues;
                }
                ArrayList<T> pvalues = new ArrayList<T>(values.size());
                for (AttributeValue value : values) {
                    pvalues.add(ValueDecoder.decode(pd1, value));
                }
                return pvalues;
            }
            catch (DefinitionDecodingException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (PropertyNotFoundException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (IllegalPropertyValueException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (IllegalPropertyValueStringException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (ConfigException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
        }
    }
}

