/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.CollationMatchingRuleCfgClient;
import org.opends.server.admin.std.meta.MatchingRuleCfgDefn;
import org.opends.server.admin.std.server.CollationMatchingRuleCfg;
import org.opends.server.admin.std.server.MatchingRuleCfg;
import org.opends.server.types.DN;

public final class CollationMatchingRuleCfgDefn
extends ManagedObjectDefinition<CollationMatchingRuleCfgClient, CollationMatchingRuleCfg> {
    private static final CollationMatchingRuleCfgDefn INSTANCE = new CollationMatchingRuleCfgDefn();
    private static final StringPropertyDefinition PD_COLLATION;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final EnumPropertyDefinition<MatchingRuleType> PD_MATCHING_RULE_TYPE;

    public static CollationMatchingRuleCfgDefn getInstance() {
        return INSTANCE;
    }

    private CollationMatchingRuleCfgDefn() {
        super("collation-matching-rule", MatchingRuleCfgDefn.getInstance());
    }

    @Override
    public CollationMatchingRuleCfgClient createClientConfiguration(ManagedObject<? extends CollationMatchingRuleCfgClient> impl) {
        return new CollationMatchingRuleCfgClientImpl(impl);
    }

    @Override
    public CollationMatchingRuleCfg createServerConfiguration(ServerManagedObject<? extends CollationMatchingRuleCfg> impl) {
        return new CollationMatchingRuleCfgServerImpl(impl);
    }

    @Override
    public Class<CollationMatchingRuleCfg> getServerConfigurationClass() {
        return CollationMatchingRuleCfg.class;
    }

    public StringPropertyDefinition getCollationPropertyDefinition() {
        return PD_COLLATION;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return MatchingRuleCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public EnumPropertyDefinition<MatchingRuleType> getMatchingRuleTypePropertyDefinition() {
        return PD_MATCHING_RULE_TYPE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "collation");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "collation"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^[a-z-A-Z]+:[0-9.]+\\d$", "LOCALE:OID");
        PD_COLLATION = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_COLLATION);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.schema.CollationMatchingRuleFactory");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.MatchingRuleFactory");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "matching-rule-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "matching-rule-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(MatchingRuleType.class);
        PD_MATCHING_RULE_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MATCHING_RULE_TYPE);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class CollationMatchingRuleCfgServerImpl
    implements CollationMatchingRuleCfg {
        private ServerManagedObject<? extends CollationMatchingRuleCfg> impl;
        private final SortedSet<String> pCollation;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final SortedSet<MatchingRuleType> pMatchingRuleType;

        private CollationMatchingRuleCfgServerImpl(ServerManagedObject<? extends CollationMatchingRuleCfg> impl) {
            this.impl = impl;
            this.pCollation = impl.getPropertyValues((PropertyDefinition)INSTANCE.getCollationPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pMatchingRuleType = impl.getPropertyValues(INSTANCE.getMatchingRuleTypePropertyDefinition());
        }

        @Override
        public void addCollationChangeListener(ConfigurationChangeListener<CollationMatchingRuleCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCollationChangeListener(ConfigurationChangeListener<CollationMatchingRuleCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<MatchingRuleCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<MatchingRuleCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<String> getCollation() {
            return this.pCollation;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public SortedSet<MatchingRuleType> getMatchingRuleType() {
            return this.pMatchingRuleType;
        }

        @Override
        public Class<? extends CollationMatchingRuleCfg> configurationClass() {
            return CollationMatchingRuleCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class CollationMatchingRuleCfgClientImpl
    implements CollationMatchingRuleCfgClient {
        private ManagedObject<? extends CollationMatchingRuleCfgClient> impl;

        private CollationMatchingRuleCfgClientImpl(ManagedObject<? extends CollationMatchingRuleCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<String> getCollation() {
            return this.impl.getPropertyValues(INSTANCE.getCollationPropertyDefinition());
        }

        @Override
        public void setCollation(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getCollationPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<MatchingRuleType> getMatchingRuleType() {
            return this.impl.getPropertyValues(INSTANCE.getMatchingRuleTypePropertyDefinition());
        }

        @Override
        public void setMatchingRuleType(Collection<MatchingRuleType> values) {
            this.impl.setPropertyValues(INSTANCE.getMatchingRuleTypePropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends CollationMatchingRuleCfgClient, ? extends CollationMatchingRuleCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    public static enum MatchingRuleType {
        EQUALITY("equality"),
        GREATER_THAN("greater-than"),
        GREATER_THAN_OR_EQUAL_TO("greater-than-or-equal-to"),
        LESS_THAN("less-than"),
        LESS_THAN_OR_EQUAL_TO("less-than-or-equal-to"),
        SUBSTRING("substring");

        private final String name;

        private MatchingRuleType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

