/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.ConnectionHandlerCfgClient;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.types.AddressMask;
import org.opends.server.types.DN;

public final class ConnectionHandlerCfgDefn
extends ManagedObjectDefinition<ConnectionHandlerCfgClient, ConnectionHandlerCfg> {
    private static final ConnectionHandlerCfgDefn INSTANCE = new ConnectionHandlerCfgDefn();
    private static final IPAddressMaskPropertyDefinition PD_ALLOWED_CLIENT;
    private static final IPAddressMaskPropertyDefinition PD_DENIED_CLIENT;
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static ConnectionHandlerCfgDefn getInstance() {
        return INSTANCE;
    }

    private ConnectionHandlerCfgDefn() {
        super("connection-handler", TopCfgDefn.getInstance());
    }

    @Override
    public ConnectionHandlerCfgClient createClientConfiguration(ManagedObject<? extends ConnectionHandlerCfgClient> impl) {
        return new ConnectionHandlerCfgClientImpl(impl);
    }

    @Override
    public ConnectionHandlerCfg createServerConfiguration(ServerManagedObject<? extends ConnectionHandlerCfg> impl) {
        return new ConnectionHandlerCfgServerImpl(impl);
    }

    @Override
    public Class<ConnectionHandlerCfg> getServerConfigurationClass() {
        return ConnectionHandlerCfg.class;
    }

    public IPAddressMaskPropertyDefinition getAllowedClientPropertyDefinition() {
        return PD_ALLOWED_CLIENT;
    }

    public IPAddressMaskPropertyDefinition getDeniedClientPropertyDefinition() {
        return PD_DENIED_CLIENT;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = IPAddressMaskPropertyDefinition.createBuilder(INSTANCE, "allowed-client");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-client"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "allowed-client"));
        PD_ALLOWED_CLIENT = (IPAddressMaskPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ALLOWED_CLIENT);
        builder = IPAddressMaskPropertyDefinition.createBuilder(INSTANCE, "denied-client");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "denied-client"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "denied-client"));
        PD_DENIED_CLIENT = (IPAddressMaskPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DENIED_CLIENT);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.ConnectionHandler");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class ConnectionHandlerCfgServerImpl
    implements ConnectionHandlerCfg {
        private ServerManagedObject<? extends ConnectionHandlerCfg> impl;
        private final SortedSet<AddressMask> pAllowedClient;
        private final SortedSet<AddressMask> pDeniedClient;
        private final boolean pEnabled;
        private final String pJavaClass;

        private ConnectionHandlerCfgServerImpl(ServerManagedObject<? extends ConnectionHandlerCfg> impl) {
            this.impl = impl;
            this.pAllowedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getAllowedClientPropertyDefinition());
            this.pDeniedClient = impl.getPropertyValues((PropertyDefinition)INSTANCE.getDeniedClientPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ConnectionHandlerCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.pAllowedClient;
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.pDeniedClient;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends ConnectionHandlerCfg> configurationClass() {
            return ConnectionHandlerCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    private static class ConnectionHandlerCfgClientImpl
    implements ConnectionHandlerCfgClient {
        private ManagedObject<? extends ConnectionHandlerCfgClient> impl;

        private ConnectionHandlerCfgClientImpl(ManagedObject<? extends ConnectionHandlerCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<AddressMask> getAllowedClient() {
            return this.impl.getPropertyValues(INSTANCE.getAllowedClientPropertyDefinition());
        }

        @Override
        public void setAllowedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getAllowedClientPropertyDefinition(), values);
        }

        @Override
        public SortedSet<AddressMask> getDeniedClient() {
            return this.impl.getPropertyValues(INSTANCE.getDeniedClientPropertyDefinition());
        }

        @Override
        public void setDeniedClient(Collection<AddressMask> values) {
            this.impl.setPropertyValues(INSTANCE.getDeniedClientPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ConnectionHandlerCfgClient, ? extends ConnectionHandlerCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

