/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.AuthenticationPolicyState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SubEntry;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public abstract class AuthenticationPolicy {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static final AuthenticationPolicy forUser(Entry userEntry, boolean useDefaultOnError) throws DirectoryException {
        List<SubEntry> pwpSubEntries;
        String userDNString = userEntry.getDN().toString();
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-policy-dn", true);
        List<Attribute> attrList = userEntry.getAttribute(type);
        if (attrList != null) {
            for (Attribute a : attrList) {
                DN subentryDN;
                if (a.isEmpty()) continue;
                AttributeValue v = a.iterator().next();
                try {
                    subentryDN = DN.decode(v.getValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("Could not parse password policy subentry DN %s for user %s: %s", v.getValue().toString(), userDNString, StaticUtils.stackTraceToSingleLineString(e));
                    }
                    Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_SUBENTRY_VALUE_AS_DN.get(v.getValue().toString(), userDNString, e.getMessage());
                    if (useDefaultOnError) {
                        ErrorLogger.logError(message);
                        return DirectoryServer.getDefaultPasswordPolicy();
                    }
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, e);
                }
                AuthenticationPolicy policy = DirectoryServer.getAuthenticationPolicy(subentryDN);
                if (policy == null) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("Password policy subentry %s for user %s is not defined in the Directory Server.", String.valueOf(subentryDN), userDNString);
                    }
                    Message message = CoreMessages.ERR_PWPSTATE_NO_SUCH_POLICY.get(userDNString, String.valueOf(subentryDN));
                    if (useDefaultOnError) {
                        ErrorLogger.logError(message);
                        return DirectoryServer.getDefaultPasswordPolicy();
                    }
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Using password policy subentry %s for user %s.", String.valueOf(subentryDN), userDNString);
                }
                return policy;
            }
        }
        if ((pwpSubEntries = DirectoryServer.getSubentryManager().getSubentries(userEntry)) != null && !pwpSubEntries.isEmpty()) {
            for (SubEntry subentry : pwpSubEntries) {
                try {
                    if (!subentry.getEntry().isPasswordPolicySubentry()) continue;
                    AuthenticationPolicy policy = DirectoryServer.getAuthenticationPolicy(subentry.getDN());
                    if (policy == null) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugError("Found unknown password policy subentry DN %s for user %s", subentry.getDN().toString(), userDNString);
                        }
                        break;
                    }
                    return policy;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugError("Could not parse password policy subentry DN %s for user %s: %s", subentry.getDN().toString(), userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Using the default password policy for user %s", userDNString);
        }
        return DirectoryServer.getDefaultPasswordPolicy();
    }

    protected AuthenticationPolicy() {
    }

    public abstract DN getDN();

    public boolean isPasswordPolicy() {
        return false;
    }

    public AuthenticationPolicyState createAuthenticationPolicyState(Entry userEntry) throws DirectoryException {
        return this.createAuthenticationPolicyState(userEntry, TimeThread.getTime());
    }

    public abstract AuthenticationPolicyState createAuthenticationPolicyState(Entry var1, long var2) throws DirectoryException;

    public void finalizeAuthenticationPolicy() {
    }
}

