/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public class CompressedSchema {
    private final List<Map.Entry<AttributeType, Set<String>>> adDecodeMap = new CopyOnWriteArrayList<Map.Entry<AttributeType, Set<String>>>();
    private final Map<Map.Entry<AttributeType, Set<String>>, Integer> adEncodeMap;
    private final List<Map<ObjectClass, String>> ocDecodeMap = new CopyOnWriteArrayList<Map<ObjectClass, String>>();
    private final Map<Map<ObjectClass, String>, Integer> ocEncodeMap;

    public CompressedSchema() {
        this.adEncodeMap = new ConcurrentHashMap<Map.Entry<AttributeType, Set<String>>, Integer>();
        this.ocEncodeMap = new ConcurrentHashMap<Map<ObjectClass, String>, Integer>();
    }

    public final Attribute decodeAttribute(ByteSequenceReader reader) throws DirectoryException {
        int numValues;
        int length = reader.getBERLength();
        byte[] idBytes = new byte[length];
        reader.get(idBytes);
        int id = this.decodeId(idBytes);
        Map.Entry<AttributeType, Set<String>> ad = this.adDecodeMap.get(id);
        if (ad == null) {
            Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_UNRECOGNIZED_AD_TOKEN.get(String.valueOf(id));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        AttributeType attrType = ad.getKey();
        Set<String> options = ad.getValue();
        if (attrType.isDirty()) {
            ad = this.loadAttribute(idBytes, attrType.getNameOrOID(), options);
            attrType = ad.getKey();
            options = ad.getValue();
        }
        if ((numValues = reader.getBERLength()) == 1 && options.isEmpty()) {
            int valueLength = reader.getBERLength();
            ByteString valueBytes = reader.getByteSequence(valueLength).toByteString();
            return Attributes.create(attrType, AttributeValues.create(attrType, valueBytes));
        }
        AttributeBuilder builder = new AttributeBuilder(attrType);
        builder.setOptions(options);
        builder.setInitialCapacity(numValues);
        for (int i = 0; i < numValues; ++i) {
            int valueLength = reader.getBERLength();
            ByteString valueBytes = reader.getByteSequence(valueLength).toByteString();
            builder.add(AttributeValues.create(attrType, valueBytes));
        }
        return builder.toAttribute();
    }

    public final Map<ObjectClass, String> decodeObjectClasses(ByteSequenceReader reader) throws DirectoryException {
        int length = reader.getBERLength();
        byte[] idBytes = new byte[length];
        reader.get(idBytes);
        int id = this.decodeId(idBytes);
        Map<ObjectClass, String> ocMap = this.ocDecodeMap.get(id);
        if (ocMap != null) {
            for (ObjectClass oc : ocMap.keySet()) {
                if (!oc.isDirty()) continue;
                return this.loadObjectClasses(idBytes, ocMap.values());
            }
            return ocMap;
        }
        Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_UNKNOWN_OC_TOKEN.get(String.valueOf(id));
        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encodeAttribute(ByteStringBuilder builder, Attribute attribute) throws DirectoryException {
        Set<String> options;
        AttributeType type = attribute.getAttributeType();
        AbstractMap.SimpleImmutableEntry<AttributeType, Set<String>> ad = new AbstractMap.SimpleImmutableEntry<AttributeType, Set<String>>(type, options = attribute.getOptions());
        Integer id = this.adEncodeMap.get(ad);
        if (id == null) {
            Map<Map.Entry<AttributeType, Set<String>>, Integer> map = this.adEncodeMap;
            synchronized (map) {
                id = this.adEncodeMap.get(ad);
                if (id == null) {
                    id = this.adDecodeMap.size();
                    this.adDecodeMap.add(ad);
                    this.adEncodeMap.put(ad, id);
                    this.storeAttribute(this.encodeId(id), type.getNameOrOID(), options);
                }
            }
        }
        byte[] idBytes = this.encodeId(id);
        builder.appendBERLength(idBytes.length);
        builder.append(idBytes);
        builder.appendBERLength(attribute.size());
        for (AttributeValue v : attribute) {
            builder.appendBERLength(v.getValue().length());
            builder.append(v.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encodeObjectClasses(ByteStringBuilder builder, Map<ObjectClass, String> objectClasses) throws DirectoryException {
        Integer id = this.ocEncodeMap.get(objectClasses);
        if (id == null) {
            Map<Map<ObjectClass, String>, Integer> map = this.ocEncodeMap;
            synchronized (map) {
                id = this.ocEncodeMap.get(objectClasses);
                if (id == null) {
                    id = this.ocDecodeMap.size();
                    this.ocDecodeMap.add(objectClasses);
                    this.ocEncodeMap.put(objectClasses, id);
                    this.storeObjectClasses(this.encodeId(id), objectClasses.values());
                }
            }
        }
        byte[] idBytes = this.encodeId(id);
        builder.appendBERLength(idBytes.length);
        builder.append(idBytes);
    }

    protected final Iterable<Map.Entry<byte[], Map.Entry<String, Collection<String>>>> getAllAttributes() {
        return new Iterable<Map.Entry<byte[], Map.Entry<String, Collection<String>>>>(){

            @Override
            public Iterator<Map.Entry<byte[], Map.Entry<String, Collection<String>>>> iterator() {
                return new Iterator<Map.Entry<byte[], Map.Entry<String, Collection<String>>>>(){
                    private int id = 0;

                    @Override
                    public boolean hasNext() {
                        return this.id < CompressedSchema.this.adDecodeMap.size();
                    }

                    @Override
                    public Map.Entry<byte[], Map.Entry<String, Collection<String>>> next() {
                        byte[] encodedAttribute = CompressedSchema.this.encodeId(this.id);
                        Map.Entry ad = (Map.Entry)CompressedSchema.this.adDecodeMap.get(this.id++);
                        return new AbstractMap.SimpleImmutableEntry<byte[], Map.Entry<String, Collection<String>>>(encodedAttribute, new AbstractMap.SimpleImmutableEntry(((AttributeType)ad.getKey()).getNameOrOID(), ad.getValue()));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    protected final Iterable<Map.Entry<byte[], Collection<String>>> getAllObjectClasses() {
        return new Iterable<Map.Entry<byte[], Collection<String>>>(){

            @Override
            public Iterator<Map.Entry<byte[], Collection<String>>> iterator() {
                return new Iterator<Map.Entry<byte[], Collection<String>>>(){
                    private int id = 0;

                    @Override
                    public boolean hasNext() {
                        return this.id < CompressedSchema.this.ocDecodeMap.size();
                    }

                    @Override
                    public Map.Entry<byte[], Collection<String>> next() {
                        byte[] encodedObjectClasses = CompressedSchema.this.encodeId(this.id);
                        Map ocMap = (Map)CompressedSchema.this.ocDecodeMap.get(this.id++);
                        return new AbstractMap.SimpleImmutableEntry<byte[], Collection<String>>(encodedObjectClasses, ocMap.values());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map.Entry<AttributeType, Set<String>> loadAttribute(byte[] encodedAttribute, String attributeName, Collection<String> attributeOptions) {
        Set<Object> options;
        AttributeType type = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(attributeName), true);
        switch (attributeOptions.size()) {
            case 0: {
                options = Collections.emptySet();
                break;
            }
            case 1: {
                options = Collections.singleton(attributeOptions.iterator().next());
                break;
            }
            default: {
                options = new LinkedHashSet<String>(attributeOptions);
            }
        }
        AbstractMap.SimpleImmutableEntry<AttributeType, Set<String>> ad = new AbstractMap.SimpleImmutableEntry<AttributeType, Set<String>>(type, options);
        int id = this.decodeId(encodedAttribute);
        Map<Map.Entry<AttributeType, Set<String>>, Integer> map = this.adEncodeMap;
        synchronized (map) {
            this.adEncodeMap.put(ad, id);
            if (id < this.adDecodeMap.size()) {
                this.adDecodeMap.set(id, ad);
            } else {
                while (id > this.adDecodeMap.size()) {
                    this.adDecodeMap.add(null);
                }
                this.adDecodeMap.add(ad);
            }
        }
        return ad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<ObjectClass, String> loadObjectClasses(byte[] encodedObjectClasses, Collection<String> objectClassNames) {
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(objectClassNames.size());
        for (String name : objectClassNames) {
            String lowerName = StaticUtils.toLowerCase(name);
            ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
            ocMap.put(oc, name);
        }
        int id = this.decodeId(encodedObjectClasses);
        Map<Map<ObjectClass, String>, Integer> map = this.ocEncodeMap;
        synchronized (map) {
            this.ocEncodeMap.put(ocMap, id);
            if (id < this.ocDecodeMap.size()) {
                this.ocDecodeMap.set(id, ocMap);
            } else {
                while (id > this.ocDecodeMap.size()) {
                    this.ocDecodeMap.add(null);
                }
                this.ocDecodeMap.add(ocMap);
            }
        }
        return ocMap;
    }

    protected void storeAttribute(byte[] encodedAttribute, String attributeName, Collection<String> attributeOptions) throws DirectoryException {
    }

    protected void storeObjectClasses(byte[] encodedObjectClasses, Collection<String> objectClassNames) throws DirectoryException {
    }

    private int decodeId(byte[] idBytes) {
        int id = 0;
        for (byte b : idBytes) {
            id <<= 8;
            id |= b & 0xFF;
        }
        return id - 1;
    }

    private byte[] encodeId(int id) {
        int value = id + 1;
        byte[] idBytes = value <= 255 ? new byte[]{(byte)(value & 0xFF)} : (value <= 65535 ? new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)} : (value <= 0xFFFFFF ? new byte[]{(byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)} : new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)}));
        return idBytes;
    }
}

