/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DirectoryThread;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.monitors.ConnectionHandlerMonitor;
import org.opends.server.types.DN;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class ConnectionHandler<T extends ConnectionHandlerCfg>
extends DirectoryThread {
    private ConnectionHandlerMonitor monitor = null;
    private boolean isAdminConnectionHandler = false;

    protected ConnectionHandler(String threadName) {
        super(threadName);
    }

    public abstract void finalizeConnectionHandler(Message var1);

    public abstract String getConnectionHandlerName();

    public Collection<String> getEnabledSSLCipherSuites() {
        return Collections.emptyList();
    }

    public Collection<String> getEnabledSSLProtocols() {
        return Collections.emptyList();
    }

    public abstract DN getComponentEntryDN();

    public abstract String getProtocol();

    public abstract Collection<HostPort> getListeners();

    public abstract Collection<ClientConnection> getClientConnections();

    public abstract void initializeConnectionHandler(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public abstract void run();

    public final ConnectionHandlerMonitor getConnectionHandlerMonitor() {
        return this.monitor;
    }

    public final void setConnectionHandlerMonitor(ConnectionHandlerMonitor monitor) {
        this.monitor = monitor;
    }

    public void setAdminConnectionHandler() {
        this.isAdminConnectionHandler = true;
    }

    public boolean isAdminConnectionHandler() {
        return this.isAdminConnectionHandler;
    }

    public int getNumRequestHandlers(Integer numRequestHandlers, String friendlyName) {
        if (numRequestHandlers == null) {
            int cpus = Runtime.getRuntime().availableProcessors();
            int value = Math.max(2, cpus / 2);
            Message message = ProtocolMessages.INFO_ERGONOMIC_SIZING_OF_REQUEST_HANDLER_THREADS.get(friendlyName, value);
            ErrorLogger.logError(message);
            return value;
        }
        return numRequestHandlers;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);
}

