/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.DebugLogPublisherCfg;
import org.opends.server.api.LogPublisher;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.TraceSettings;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class DebugLogPublisher<T extends DebugLogPublisherCfg>
implements LogPublisher<T> {
    private static final String GLOBAL = "_global";
    private Map<String, TraceSettings> classTraceSettings = null;
    private Map<String, Map<String, TraceSettings>> methodTraceSettings = null;

    protected DebugLogPublisher() {
        this.addTraceSettings(null, new TraceSettings(DebugLogLevel.DISABLED));
    }

    @Override
    public boolean isConfigurationAcceptable(T configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public final Map<String, TraceSettings> getMethodSettings(String className) {
        if (this.methodTraceSettings == null) {
            return null;
        }
        return this.methodTraceSettings.get(className);
    }

    public final TraceSettings getClassSettings(String className) {
        TraceSettings settings = TraceSettings.DISABLED;
        if (this.classTraceSettings != null) {
            String searchName = className;
            TraceSettings value = null;
            value = this.classTraceSettings.get(searchName);
            while (value == null && searchName != null) {
                int clipPoint = searchName.lastIndexOf(36);
                if (clipPoint == -1) {
                    clipPoint = searchName.lastIndexOf(46);
                }
                if (clipPoint != -1) {
                    searchName = searchName.substring(0, clipPoint);
                    value = this.classTraceSettings.get(searchName);
                    continue;
                }
                searchName = null;
            }
            if (value == null) {
                value = this.classTraceSettings.get(GLOBAL);
            }
            if (value != null) {
                settings = value;
            }
        }
        return settings;
    }

    public final void addTraceSettings(String scope, TraceSettings settings) {
        if (scope == null) {
            this.setClassSettings(GLOBAL, settings);
        } else {
            int methodPt = scope.lastIndexOf(35);
            if (methodPt != -1) {
                String methodName = scope.substring(methodPt + 1);
                scope = scope.substring(0, methodPt);
                this.setMethodSettings(scope, methodName, settings);
            } else {
                this.setClassSettings(scope, settings);
            }
        }
    }

    public final TraceSettings getTraceSettings(String scope) {
        if (scope == null) {
            if (this.classTraceSettings != null) {
                return this.classTraceSettings.get(GLOBAL);
            }
            return null;
        }
        int methodPt = scope.lastIndexOf(35);
        if (methodPt != -1) {
            String methodName = scope.substring(methodPt + 1);
            scope = scope.substring(0, methodPt);
            if (this.methodTraceSettings != null) {
                Map<String, TraceSettings> methodLevels = this.methodTraceSettings.get(scope);
                if (methodLevels != null) {
                    return methodLevels.get(methodName);
                }
                return null;
            }
            return null;
        }
        if (this.classTraceSettings != null) {
            return this.classTraceSettings.get(scope);
        }
        return null;
    }

    public final TraceSettings removeTraceSettings(String scope) {
        TraceSettings removedSettings = null;
        if (scope == null) {
            if (this.classTraceSettings != null) {
                removedSettings = this.classTraceSettings.remove(GLOBAL);
            }
        } else {
            int methodPt = scope.lastIndexOf(35);
            if (methodPt != -1) {
                Map<String, TraceSettings> methodLevels;
                String methodName = scope.substring(methodPt + 1);
                scope = scope.substring(0, methodPt);
                if (this.methodTraceSettings != null && (methodLevels = this.methodTraceSettings.get(scope)) != null) {
                    removedSettings = methodLevels.remove(methodName);
                    if (methodLevels.isEmpty()) {
                        this.methodTraceSettings.remove(scope);
                    }
                }
            } else if (this.classTraceSettings != null) {
                removedSettings = this.classTraceSettings.remove(scope);
            }
        }
        return removedSettings;
    }

    private final synchronized void setClassSettings(String className, TraceSettings settings) {
        if (this.classTraceSettings == null) {
            this.classTraceSettings = new HashMap<String, TraceSettings>();
        }
        this.classTraceSettings.put(className, settings);
    }

    private final synchronized void setMethodSettings(String className, String methodName, TraceSettings settings) {
        Map<String, TraceSettings> methodLevels;
        if (this.methodTraceSettings == null) {
            this.methodTraceSettings = new HashMap<String, Map<String, TraceSettings>>();
        }
        if ((methodLevels = this.methodTraceSettings.get(className)) == null) {
            methodLevels = new TreeMap<String, TraceSettings>();
            this.methodTraceSettings.put(className, methodLevels);
        }
        methodLevels.put(methodName, settings);
    }

    public abstract void traceConstructor(LogLevel var1, TraceSettings var2, String var3, String var4, Object[] var5, StackTraceElement[] var6);

    public abstract void traceMethodEntry(LogLevel var1, TraceSettings var2, String var3, String var4, Object var5, Object[] var6, StackTraceElement[] var7);

    public abstract void traceStaticMethodEntry(LogLevel var1, TraceSettings var2, String var3, String var4, Object[] var5, StackTraceElement[] var6);

    public abstract void traceReturn(LogLevel var1, TraceSettings var2, String var3, String var4, Object var5, StackTraceElement[] var6);

    public abstract void traceMessage(LogLevel var1, TraceSettings var2, String var3, String var4, String var5, StackTraceElement[] var6);

    public abstract void traceThrown(LogLevel var1, TraceSettings var2, String var3, String var4, Throwable var5, StackTraceElement[] var6);

    public abstract void traceCaught(LogLevel var1, TraceSettings var2, String var3, String var4, Throwable var5, StackTraceElement[] var6);

    public abstract void traceJEAccess(LogLevel var1, TraceSettings var2, String var3, String var4, OperationStatus var5, Database var6, Transaction var7, DatabaseEntry var8, DatabaseEntry var9, StackTraceElement[] var10);

    public abstract void traceData(LogLevel var1, TraceSettings var2, String var3, String var4, byte[] var5, StackTraceElement[] var6);

    public abstract void traceProtocolElement(LogLevel var1, TraceSettings var2, String var3, String var4, String var5, StackTraceElement[] var6);
}

