/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class PasswordStorageScheme<T extends PasswordStorageSchemeCfg> {
    public abstract void initializePasswordStorageScheme(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizePasswordStorageScheme() {
    }

    public abstract String getStorageSchemeName();

    public abstract ByteString encodePassword(ByteSequence var1) throws DirectoryException;

    public abstract ByteString encodePasswordWithScheme(ByteSequence var1) throws DirectoryException;

    public abstract boolean passwordMatches(ByteSequence var1, ByteSequence var2);

    public abstract boolean supportsAuthPasswordSyntax();

    public String getAuthPasswordSchemeName() {
        return this.getStorageSchemeName();
    }

    public abstract ByteString encodeAuthPassword(ByteSequence var1) throws DirectoryException;

    public abstract boolean authPasswordMatches(ByteSequence var1, String var2, String var3);

    public abstract boolean isReversible();

    public abstract ByteString getPlaintextValue(ByteSequence var1) throws DirectoryException;

    public abstract ByteString getAuthPasswordPlaintextValue(String var1, String var2) throws DirectoryException;

    public abstract boolean isStorageSchemeSecure();
}

