/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.net.InetAddress;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.Group;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumAuthMethod;
import org.opends.server.authorization.dseecompat.EnumEvalReason;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.controls.GetEffectiveRightsRequestControl;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.SearchOperation;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;

public abstract class AciContainer
implements AciTargetMatchContext,
AciEvalContext {
    private LinkedList<Aci> denyList;
    private LinkedList<Aci> allowList;
    private AttributeType attributeType;
    private AttributeValue attributeValue;
    private boolean isFirst = false;
    private boolean isEntryTestRule = false;
    private boolean isDenyEval;
    private boolean isAddOp = false;
    private int rightsMask;
    private Entry resourceEntry;
    private final ClientConnection clientConnection;
    private final Operation operation;
    private boolean targAttrFiltersMatch = false;
    private Entry authorizationEntry;
    private final Entry saveAuthorizationEntry;
    private Entry origAuthorizationEntry = null;
    private boolean proxiedAuthorization = false;
    private boolean seenEntry = false;
    private boolean isGetEffectiveRightsEval = false;
    private boolean hasGetEffectiveRightsControl = false;
    private DN authzid = null;
    private boolean useAuthzid = false;
    private List<AttributeType> specificAttrs = null;
    private final HashMap<Aci, Aci> targAttrFilterAcis = new HashMap();
    private String targAttrFiltersAciName = null;
    private int targAttrMatch = 0;
    private Aci decidingAci = null;
    private EnumEvalReason evalReason = null;
    private String summaryString = null;
    private int evalAllAttributes = 0;
    private String controlOID;
    private String extOpOID;
    private AuthenticationInfo authInfo;

    protected AciContainer(Operation operation, int rights, Entry entry) {
        this.resourceEntry = entry;
        this.operation = operation;
        this.clientConnection = operation.getClientConnection();
        if (operation instanceof AddOperationBasis) {
            this.isAddOp = true;
        }
        this.authInfo = this.clientConnection.getAuthenticationInfo();
        this.origAuthorizationEntry = (Entry)operation.getAttachment("origAuthorizationEntry");
        if (this.origAuthorizationEntry != null) {
            this.proxiedAuthorization = true;
        }
        this.authorizationEntry = operation.getAuthorizationEntry();
        if (rights == 4) {
            String allOpAttrs;
            String allUserAttrs;
            GetEffectiveRightsRequestControl getEffectiveRightsControl = (GetEffectiveRightsRequestControl)operation.getAttachment("1.3.6.1.4.1.42.2.27.9.5.2");
            if (getEffectiveRightsControl != null && operation instanceof SearchOperation) {
                this.hasGetEffectiveRightsControl = true;
                this.authzid = getEffectiveRightsControl.getAuthzDN() == null ? this.getClientDN() : getEffectiveRightsControl.getAuthzDN();
                this.specificAttrs = getEffectiveRightsControl.getAttributes();
            }
            if ((allUserAttrs = (String)operation.getAttachment("allUserAttrsMatched")) != null) {
                this.evalAllAttributes |= 8;
            }
            if ((allOpAttrs = (String)operation.getAttachment("allOpAttrsMatched")) != null) {
                this.evalAllAttributes |= 4;
            }
        }
        this.saveAuthorizationEntry = this.authorizationEntry;
        this.rightsMask = rights;
    }

    protected AciContainer(Operation operation, Entry e, AuthenticationInfo authInfo, int rights) {
        this.resourceEntry = e;
        this.operation = operation;
        this.clientConnection = operation.getClientConnection();
        this.authInfo = authInfo;
        this.saveAuthorizationEntry = this.authorizationEntry = authInfo.getAuthorizationEntry();
        this.rightsMask = rights;
    }

    public boolean hasSeenEntry() {
        return this.seenEntry;
    }

    public void setSeenEntry(boolean val) {
        this.seenEntry = val;
    }

    @Override
    public boolean isProxiedAuthorization() {
        return this.proxiedAuthorization;
    }

    @Override
    public boolean isGetEffectiveRightsEval() {
        return this.isGetEffectiveRightsEval;
    }

    public void setGetEffectiveRightsEval() {
        this.isGetEffectiveRightsEval = true;
    }

    public boolean hasGetEffectiveRightsControl() {
        return this.hasGetEffectiveRightsControl;
    }

    public void useAuthzid(boolean v) {
        this.useAuthzid = v;
    }

    public List<AttributeType> getSpecificAttributes() {
        return this.specificAttrs;
    }

    @Override
    public void addTargAttrFiltersMatchAci(Aci aci) {
        this.targAttrFilterAcis.put(aci, aci);
    }

    @Override
    public boolean hasTargAttrFiltersMatchAci(Aci aci) {
        return this.targAttrFilterAcis.containsKey(aci);
    }

    @Override
    public boolean isTargAttrFilterMatchAciEmpty() {
        return this.targAttrFilterAcis.isEmpty();
    }

    public void resetEffectiveRightsParams() {
        this.targAttrFilterAcis.clear();
        this.decidingAci = null;
        this.evalReason = null;
        this.targAttrFiltersMatch = false;
        this.summaryString = null;
        this.targAttrMatch = 0;
    }

    @Override
    public void setTargAttrFiltersAciName(String name) {
        this.targAttrFiltersAciName = name;
    }

    @Override
    public String getTargAttrFiltersAciName() {
        return this.targAttrFiltersAciName;
    }

    @Override
    public void setTargAttrFiltersMatchOp(int flag) {
        this.targAttrMatch |= flag;
    }

    @Override
    public boolean hasTargAttrFiltersMatchOp(int flag) {
        return (this.targAttrMatch & flag) != 0;
    }

    @Override
    public void setDecidingAci(Aci aci) {
        this.decidingAci = aci;
    }

    @Override
    public String getDecidingAciName() {
        if (this.decidingAci != null) {
            return this.decidingAci.getName();
        }
        return null;
    }

    @Override
    public void setEvalReason(EnumEvalReason reason) {
        this.evalReason = reason;
    }

    @Override
    public EnumEvalReason getEvalReason() {
        return this.evalReason;
    }

    @Override
    public void setEvalSummary(String summary) {
        this.summaryString = summary;
    }

    @Override
    public String getEvalSummary() {
        return this.summaryString;
    }

    public boolean isAuthzidAuthorizationDN() {
        return this.authzid.equals(this.authorizationEntry.getDN());
    }

    public void useOrigAuthorizationEntry(boolean val) {
        this.authorizationEntry = val ? this.origAuthorizationEntry : this.saveAuthorizationEntry;
    }

    @Override
    public void setDenyList(LinkedList<Aci> denys) {
        this.denyList = denys;
    }

    @Override
    public void setAllowList(LinkedList<Aci> allows) {
        this.allowList = allows;
    }

    @Override
    public AttributeType getCurrentAttributeType() {
        return this.attributeType;
    }

    @Override
    public AttributeValue getCurrentAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public void setCurrentAttributeType(AttributeType type) {
        this.attributeType = type;
    }

    @Override
    public void setCurrentAttributeValue(AttributeValue value) {
        this.attributeValue = value;
    }

    @Override
    public boolean isFirstAttribute() {
        return this.isFirst;
    }

    @Override
    public void setIsFirstAttribute(boolean val) {
        this.isFirst = val;
    }

    @Override
    public boolean hasEntryTestRule() {
        return this.isEntryTestRule;
    }

    @Override
    public void setEntryTestRule(boolean val) {
        this.isEntryTestRule = val;
    }

    @Override
    public Entry getResourceEntry() {
        return this.resourceEntry;
    }

    @Override
    public Entry getClientEntry() {
        return this.authorizationEntry;
    }

    @Override
    public LinkedList<Aci> getDenyList() {
        return this.denyList;
    }

    @Override
    public LinkedList<Aci> getAllowList() {
        return this.allowList;
    }

    @Override
    public boolean isDenyEval() {
        return this.isDenyEval;
    }

    @Override
    public boolean isAnonymousUser() {
        return !this.authInfo.isAuthenticated();
    }

    @Override
    public void setDenyEval(boolean val) {
        this.isDenyEval = val;
    }

    @Override
    public DN getClientDN() {
        if (this.useAuthzid) {
            return this.authzid;
        }
        if (this.authorizationEntry == null) {
            return DN.nullDN();
        }
        return this.authorizationEntry.getDN();
    }

    @Override
    public DN getResourceDN() {
        return this.resourceEntry.getDN();
    }

    @Override
    public boolean hasRights(int rights) {
        return (this.rightsMask & rights) != 0;
    }

    @Override
    public int getRights() {
        return this.rightsMask;
    }

    @Override
    public void setRights(int rights) {
        this.rightsMask = rights;
    }

    @Override
    public String getHostName() {
        return this.clientConnection.getRemoteAddress().getCanonicalHostName();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.clientConnection.getRemoteAddress();
    }

    @Override
    public boolean isAddOperation() {
        return this.isAddOp;
    }

    @Override
    public void setTargAttrFiltersMatch(boolean v) {
        this.targAttrFiltersMatch = v;
    }

    @Override
    public boolean getTargAttrFiltersMatch() {
        return this.targAttrFiltersMatch;
    }

    @Override
    public String getControlOID() {
        return this.controlOID;
    }

    @Override
    public String getExtOpOID() {
        return this.extOpOID;
    }

    protected void setControlOID(String oid) {
        this.controlOID = oid;
    }

    protected void setExtOpOID(String oid) {
        this.extOpOID = oid;
    }

    @Override
    public EnumEvalResult hasAuthenticationMethod(EnumAuthMethod authMethod, String saslMech) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        if (authMethod == EnumAuthMethod.AUTHMETHOD_NONE) {
            matched = EnumEvalResult.TRUE;
        } else if (this.authInfo.isAuthenticated()) {
            if (authMethod == EnumAuthMethod.AUTHMETHOD_SIMPLE) {
                if (this.authInfo.hasAuthenticationType(AuthenticationType.SIMPLE)) {
                    matched = EnumEvalResult.TRUE;
                }
            } else if (authMethod == EnumAuthMethod.AUTHMETHOD_SSL) {
                LDAPClientConnection lc;
                Certificate[] certChain;
                if (this.authInfo.hasAuthenticationType(AuthenticationType.SASL) && this.authInfo.hasSASLMechanism(saslMech) && this.clientConnection instanceof LDAPClientConnection && (certChain = (lc = (LDAPClientConnection)this.clientConnection).getClientCertificateChain()).length != 0) {
                    matched = EnumEvalResult.TRUE;
                }
            } else if (this.authInfo.hasAuthenticationType(AuthenticationType.SASL) && this.authInfo.hasSASLMechanism(saslMech)) {
                matched = EnumEvalResult.TRUE;
            }
        }
        return matched;
    }

    @Override
    public boolean isMemberOf(Group<?> group) {
        boolean ret;
        try {
            Entry e;
            ret = this.useAuthzid ? group.isMember(this.authzid) : ((e = this.getClientEntry()) != null ? group.isMember(e) : group.isMember(this.getClientDN()));
        }
        catch (DirectoryException ex) {
            ret = false;
        }
        return ret;
    }

    @Override
    public String rightToString() {
        if (this.hasRights(2)) {
            return "search";
        }
        if (this.hasRights(1)) {
            return "compare";
        }
        if (this.hasRights(4)) {
            return "read";
        }
        if (this.hasRights(16)) {
            return "delete";
        }
        if (this.hasRights(32)) {
            return "add";
        }
        if (this.hasRights(8)) {
            return "write";
        }
        if (this.hasRights(128)) {
            return "proxy";
        }
        if (this.hasRights(256)) {
            return "import";
        }
        if (this.hasRights(512)) {
            return "export";
        }
        if (this.hasRights(8) && this.hasRights(64)) {
            return "selfwrite";
        }
        return null;
    }

    @Override
    public void setEvalUserAttributes(int v) {
        if (this.operation instanceof SearchOperation && this.rightsMask == 4) {
            if (v == 16) {
                this.evalAllAttributes |= 0x10;
                this.evalAllAttributes &= 0xFFFFFFF7;
            } else {
                this.evalAllAttributes |= 8;
            }
        }
    }

    @Override
    public void setEvalOpAttributes(int v) {
        if (this.operation instanceof SearchOperation && this.rightsMask == 4) {
            if (v == 32) {
                this.evalAllAttributes |= 0x20;
                this.evalAllAttributes &= 0xFFFFFFFB;
            } else {
                this.evalAllAttributes |= 4;
            }
        }
    }

    @Override
    public boolean hasEvalUserAttributes() {
        return (this.evalAllAttributes & 0x10) == 16;
    }

    @Override
    public boolean hasEvalOpAttributes() {
        return (this.evalAllAttributes & 0x20) == 32;
    }

    public boolean hasAllUserAttributes() {
        return (this.evalAllAttributes & 8) == 8;
    }

    public boolean hasAllOpAttributes() {
        return (this.evalAllAttributes & 4) == 4;
    }

    @Override
    public void clearEvalAttributes(int v) {
        this.evalAllAttributes = v == 0 ? 0 : (this.evalAllAttributes &= ~v);
    }

    @Override
    public int getCurrentSSF() {
        return this.clientConnection.getSSF();
    }
}

