/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumAuthMethod;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;

public class AuthMethod
implements KeywordBindRule {
    private EnumAuthMethod authMethod = null;
    private String saslMech = null;
    private EnumBindRuleType type = null;

    private AuthMethod(EnumAuthMethod method, String saslMech, EnumBindRuleType type) {
        this.authMethod = method;
        this.saslMech = saslMech;
        this.type = type;
    }

    public static KeywordBindRule decode(String expr, EnumBindRuleType type) throws AciException {
        String lowerExpr = expr.toLowerCase();
        if (lowerExpr.equals("none")) {
            return new AuthMethod(EnumAuthMethod.AUTHMETHOD_NONE, null, type);
        }
        if (lowerExpr.equals("simple")) {
            return new AuthMethod(EnumAuthMethod.AUTHMETHOD_SIMPLE, null, type);
        }
        if (lowerExpr.equals("ssl")) {
            return new AuthMethod(EnumAuthMethod.AUTHMETHOD_SSL, "EXTERNAL", type);
        }
        if (expr.length() > 5 && lowerExpr.startsWith("sasl ")) {
            String saslMech = expr.substring(5);
            if (DirectoryServer.getSASLMechanismHandler(saslMech) == null) {
                ErrorLogger.logError(AccessControlMessages.NOTE_ACI_SYNTAX_DUBIOUS_AUTHMETHOD_SASL_MECHANISM.get(saslMech));
            }
            return new AuthMethod(EnumAuthMethod.AUTHMETHOD_SASL, saslMech, type);
        }
        Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_AUTHMETHOD_EXPRESSION.get(expr);
        throw new AciException(message);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = evalCtx.hasAuthenticationMethod(this.authMethod, this.saslMech);
        return matched.getRet(this.type, false);
    }
}

