/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciEvalContext;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.EnumBindRuleType;
import org.opends.server.authorization.dseecompat.EnumDayOfWeek;
import org.opends.server.authorization.dseecompat.EnumEvalResult;
import org.opends.server.authorization.dseecompat.KeywordBindRule;

public class DayOfWeek
implements KeywordBindRule {
    LinkedList<EnumDayOfWeek> days = null;
    private EnumBindRuleType type = null;

    private DayOfWeek(LinkedList<EnumDayOfWeek> days, EnumBindRuleType type) {
        this.days = days;
        this.type = type;
    }

    public static KeywordBindRule decode(String expr, EnumBindRuleType type) throws AciException {
        LinkedList<EnumDayOfWeek> days = new LinkedList<EnumDayOfWeek>();
        String[] dayArray = expr.split(",", -1);
        int m = dayArray.length;
        for (int i = 0; i < m; ++i) {
            EnumDayOfWeek day = EnumDayOfWeek.createDayOfWeek(dayArray[i]);
            if (day == null) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_DAYOFWEEK.get(expr);
                throw new AciException(message);
            }
            days.add(day);
        }
        return new DayOfWeek(days, type);
    }

    @Override
    public EnumEvalResult evaluate(AciEvalContext evalCtx) {
        EnumEvalResult matched = EnumEvalResult.FALSE;
        GregorianCalendar calendar = new GregorianCalendar();
        EnumDayOfWeek dayofweek = EnumDayOfWeek.getDayOfWeek(calendar.get(7));
        if (this.days.contains((Object)dayofweek)) {
            matched = EnumEvalResult.TRUE;
        }
        return matched.getRet(this.type, false);
    }
}

