/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.HashSet;
import org.opends.messages.AccessControlMessages;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;

public class TargetControl {
    private HashSet<String> controlOIDS = new HashSet();
    private EnumTargetOperator op = EnumTargetOperator.EQUALITY;

    private TargetControl(EnumTargetOperator op, HashSet<String> controlOIDS) {
        this.controlOIDS = controlOIDS;
        this.op = op;
    }

    public static TargetControl decode(EnumTargetOperator operator, String expr) throws AciException {
        HashSet<String> controlOIDs = Aci.decodeOID(expr, AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGETCONTROL_EXPRESSION.get(expr));
        return new TargetControl(operator, controlOIDs);
    }

    public boolean isApplicable(AciTargetMatchContext matchCtx) {
        if (matchCtx.getControlOID() == null) {
            return false;
        }
        boolean ret = false;
        for (String oid : this.controlOIDS) {
            if (!oid.equals("*") && !matchCtx.getControlOID().equals(oid)) continue;
            ret = true;
            break;
        }
        if (this.op.equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
            ret = !ret;
        }
        return ret;
    }
}

