/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;

public class DN2ID
extends DatabaseContainer {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private final int prefixRDNComponents;

    DN2ID(String name, Environment env, EntryContainer entryContainer) throws DatabaseException {
        super(name, env, entryContainer);
        this.prefixRDNComponents = entryContainer.getBaseDN().getNumComponents();
        DatabaseConfig dn2idConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dn2idConfig.setReadOnly(true);
            dn2idConfig.setAllowCreate(false);
            dn2idConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dn2idConfig.setAllowCreate(true);
            dn2idConfig.setTransactional(false);
            dn2idConfig.setDeferredWrite(true);
        } else {
            dn2idConfig.setAllowCreate(true);
            dn2idConfig.setTransactional(true);
        }
        this.dbConfig = dn2idConfig;
        this.dbConfig.setKeyPrefixing(true);
        this.dbConfig.setBtreeComparator(this.comparator.getClass());
    }

    public boolean insert(Transaction txn, DN dn, EntryID id) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
        OperationStatus status = this.insert(txn, key, data = id.getDatabaseEntry());
        return status == OperationStatus.SUCCESS;
    }

    public boolean put(Transaction txn, DN dn, EntryID id) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
        OperationStatus status = this.put(txn, key, data = id.getDatabaseEntry());
        return status == OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return super.put(txn, key, data);
    }

    public boolean remove(Transaction txn, DN dn) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
        OperationStatus status = this.delete(txn, key);
        return status == OperationStatus.SUCCESS;
    }

    @Override
    protected OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        return super.delete(txn, key);
    }

    public EntryID get(Transaction txn, DN dn, LockMode lockMode) throws DatabaseException {
        DatabaseEntry data;
        DatabaseEntry key = new DatabaseEntry(JebFormat.dnToDNKey(dn, this.prefixRDNComponents));
        OperationStatus status = this.read(txn, key, data = new DatabaseEntry(), LockMode.DEFAULT);
        if (status != OperationStatus.SUCCESS) {
            return null;
        }
        return new EntryID(data);
    }

    @Override
    public OperationStatus read(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        return super.read(txn, key, data, lockMode);
    }

    public Comparator<byte[]> getComparator() {
        return this.comparator;
    }
}

