/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.File;
import java.io.FilenameFilter;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

public class EnvManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final FilenameFilter jeAllFilesFilter = new FilenameFilter(){

        @Override
        public boolean accept(File d, String name) {
            return name.endsWith(".jdb") || name.endsWith(".del") || name.startsWith("je.");
        }
    };

    public static void createHomeDir(String homeDir) throws JebException {
        File dir = new File(homeDir);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                Message message = JebMessages.ERR_JEB_DIRECTORY_INVALID.get(homeDir);
                throw new JebException(message);
            }
            EnvManager.removeFiles(homeDir);
        } else {
            try {
                dir.mkdir();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = JebMessages.ERR_JEB_CREATE_FAIL.get(e.getMessage());
                throw new JebException(message, (Throwable)e);
            }
        }
    }

    public static void removeFiles(String homeDir) throws JebException {
        File dir = new File(homeDir);
        if (!dir.exists()) {
            Message message = JebMessages.ERR_JEB_DIRECTORY_DOES_NOT_EXIST.get(homeDir);
            throw new JebException(message);
        }
        if (!dir.isDirectory()) {
            Message message = JebMessages.ERR_JEB_DIRECTORY_INVALID.get(homeDir);
            throw new JebException(message);
        }
        try {
            File[] jdbFiles;
            for (File f : jdbFiles = dir.listFiles(jeAllFilesFilter)) {
                f.delete();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_REMOVE_FAIL.get(e.getMessage());
            throw new JebException(message, (Throwable)e);
        }
    }
}

