/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public final class JECompressedSchema
extends CompressedSchema {
    private static final String DB_NAME_AD = "compressed_attributes";
    private static final String DB_NAME_OC = "compressed_object_classes";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Database adDatabase;
    private Environment environment;
    private Database ocDatabase;
    private final ByteStringBuilder storeAttributeWriterBuffer = new ByteStringBuilder();
    private final ASN1Writer storeAttributeWriter = ASN1.getWriter(this.storeAttributeWriterBuffer);
    private final ByteStringBuilder storeObjectClassesWriterBuffer = new ByteStringBuilder();
    private final ASN1Writer storeObjectClassesWriter = ASN1.getWriter(this.storeObjectClassesWriterBuffer);

    public JECompressedSchema(Environment environment) throws DatabaseException, InitializationException {
        this.environment = environment;
        this.load();
    }

    public void close() {
        try {
            this.adDatabase.sync();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.adDatabase.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ocDatabase.sync();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ocDatabase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adDatabase = null;
        this.ocDatabase = null;
        this.environment = null;
    }

    @Override
    protected void storeAttribute(byte[] encodedAttribute, String attributeName, Collection<String> attributeOptions) throws DirectoryException {
        try {
            this.storeAttributeWriterBuffer.clear();
            this.storeAttributeWriter.writeStartSequence();
            this.storeAttributeWriter.writeOctetString(attributeName);
            for (String option : attributeOptions) {
                this.storeAttributeWriter.writeOctetString(option);
            }
            this.storeAttributeWriter.writeEndSequence();
            this.store(this.adDatabase, encodedAttribute, this.storeAttributeWriterBuffer);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    protected void storeObjectClasses(byte[] encodedObjectClasses, Collection<String> objectClassNames) throws DirectoryException {
        try {
            this.storeObjectClassesWriterBuffer.clear();
            this.storeObjectClassesWriter.writeStartSequence();
            for (String ocName : objectClassNames) {
                this.storeObjectClassesWriter.writeOctetString(ocName);
            }
            this.storeObjectClassesWriter.writeEndSequence();
            this.store(this.ocDatabase, encodedObjectClasses, this.storeObjectClassesWriterBuffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load() throws DatabaseException, InitializationException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        if (this.environment.getConfig().getReadOnly()) {
            dbConfig.setReadOnly(true);
            dbConfig.setAllowCreate(false);
            dbConfig.setTransactional(false);
        } else if (!this.environment.getConfig().getTransactional()) {
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(false);
            dbConfig.setDeferredWrite(true);
        } else {
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(true);
        }
        this.adDatabase = this.environment.openDatabase(null, DB_NAME_AD, dbConfig);
        this.ocDatabase = this.environment.openDatabase(null, DB_NAME_OC, dbConfig);
        Cursor ocCursor = this.ocDatabase.openCursor(null, null);
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = ocCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                byte[] encodedObjectClasses = keyEntry.getData();
                ASN1Reader reader = ASN1.getReader(valueEntry.getData());
                reader.readStartSequence();
                LinkedList<String> objectClassNames = new LinkedList<String>();
                while (reader.hasNextElement()) {
                    objectClassNames.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.loadObjectClasses(encodedObjectClasses, objectClassNames);
                status = ocCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_DECODE_OC_TOKEN.get(ae.getMessage());
            throw new InitializationException(m, (Throwable)ae);
        }
        finally {
            ocCursor.close();
        }
        Cursor adCursor = this.adDatabase.openCursor(null, null);
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = adCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                byte[] encodedAttribute = keyEntry.getData();
                ASN1Reader reader = ASN1.getReader(valueEntry.getData());
                reader.readStartSequence();
                String attributeName = reader.readOctetStringAsString();
                LinkedList<String> attributeOptions = new LinkedList<String>();
                while (reader.hasNextElement()) {
                    attributeOptions.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.loadAttribute(encodedAttribute, attributeName, attributeOptions);
                status = adCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_DECODE_AD_TOKEN.get(ae.getMessage());
            throw new InitializationException(m, (Throwable)ae);
        }
        finally {
            adCursor.close();
        }
    }

    private void store(Database database, byte[] key, ByteStringBuilder value) throws DirectoryException {
        boolean successful = false;
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry valueEntry = new DatabaseEntry(value.getBackingArray(), 0, value.length());
        for (int i = 0; i < 3; ++i) {
            try {
                OperationStatus status = database.putNoOverwrite(null, keyEntry, valueEntry);
                if (status != OperationStatus.SUCCESS) {
                    Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_STATUS.get(status.toString());
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
                }
                successful = true;
                break;
            }
            catch (LockConflictException ce) {
                continue;
            }
            catch (DatabaseException de) {
                Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_EX.get(de.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, de);
            }
        }
        if (!successful) {
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_MULTIPLE_FAILURES.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
        }
    }
}

