/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

public class PresenceIndexer
extends Indexer {
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private AttributeType attributeType;

    public PresenceIndexer(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public String toString() {
        return this.attributeType.getNameOrOID() + ".presence";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Entry entry, Set<byte[]> keys) {
        List<Attribute> attrList = entry.getAttribute(this.attributeType);
        if (attrList != null && !attrList.isEmpty()) {
            keys.add(AttributeIndex.presenceKey.getData());
        }
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, Map<byte[], Boolean> modifiedKeys) {
        List<Attribute> newAttributes = newEntry.getAttribute(this.attributeType, true);
        List<Attribute> oldAttributes = oldEntry.getAttribute(this.attributeType, true);
        if (oldAttributes == null) {
            if (newAttributes != null) {
                modifiedKeys.put(AttributeIndex.presenceKey.getData(), true);
            }
        } else if (newAttributes == null) {
            modifiedKeys.put(AttributeIndex.presenceKey.getData(), false);
        }
    }

    @Override
    public void modifyEntry(Entry oldEntry, Entry newEntry, List<Modification> mods, Map<byte[], Boolean> modifiedKeys) {
        List<Attribute> newAttributes = newEntry.getAttribute(this.attributeType, true);
        List<Attribute> oldAttributes = oldEntry.getAttribute(this.attributeType, true);
        if (oldAttributes == null) {
            if (newAttributes != null) {
                modifiedKeys.put(AttributeIndex.presenceKey.getData(), true);
            }
        } else if (newAttributes == null) {
            modifiedKeys.put(AttributeIndex.presenceKey.getData(), false);
        }
    }
}

