/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ExternalChangelogRequestControl
extends Control {
    private MultiDomainServerState cookie;
    public static final ControlDecoder<ExternalChangelogRequestControl> DECODER = new Decoder();

    public ExternalChangelogRequestControl(boolean isCritical, MultiDomainServerState cookie) {
        super("1.3.6.1.4.1.26027.1.5.4", isCritical);
        this.cookie = cookie;
    }

    public MultiDomainServerState getCookie() {
        return this.cookie;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ExternalChangelogRequestControl(cookie=");
        this.cookie.toString(buffer);
        buffer.append(")");
    }

    @Override
    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeOctetString(this.cookie.toString());
        writer.writeEndSequence();
    }

    private static final class Decoder
    implements ControlDecoder<ExternalChangelogRequestControl> {
        private Decoder() {
        }

        @Override
        public ExternalChangelogRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            MultiDomainServerState mdss;
            if (value == null) {
                mdss = new MultiDomainServerState();
            } else {
                ASN1Reader reader = ASN1.getReader(value);
                String mdssValue = null;
                try {
                    mdssValue = reader.readOctetStringAsString();
                    mdss = new MultiDomainServerState(mdssValue);
                }
                catch (Exception e) {
                    try {
                        mdssValue = value.toString();
                        mdss = new MultiDomainServerState(mdssValue);
                    }
                    catch (Exception e2) {
                        Message message = ProtocolMessages.ERR_CANNOT_DECODE_CONTROL_VALUE.get(this.getOID() + " x=" + value.toHex() + " v=" + mdssValue, StaticUtils.getExceptionMessage(e).toString());
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
                    }
                }
            }
            return new ExternalChangelogRequestControl(isCritical, mdss);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.26027.1.5.4";
        }
    }
}

