/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

public final class DefaultCompressedSchema
extends CompressedSchema {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Object saveLock = new Object();

    public DefaultCompressedSchema() {
        this.load();
    }

    @Override
    protected void storeAttribute(byte[] encodedAttribute, String attributeName, Collection<String> attributeOptions) throws DirectoryException {
        this.save();
    }

    @Override
    protected void storeObjectClasses(byte[] encodedObjectClasses, Collection<String> objectClassNames) throws DirectoryException {
        this.save();
    }

    private void load() {
        FileInputStream inputStream = null;
        try {
            String path = DirectoryServer.getInstanceRoot() + File.separator + "config" + File.separator + "schematokens.dat";
            if (!new File(path).exists()) {
                return;
            }
            inputStream = new FileInputStream(path);
            ASN1Reader reader = ASN1.getReader(inputStream);
            reader.readStartSequence();
            while (reader.hasNextElement()) {
                reader.readStartSequence();
                byte[] encodedObjectClasses = reader.readOctetString().toByteArray();
                LinkedList<String> objectClassNames = new LinkedList<String>();
                while (reader.hasNextElement()) {
                    objectClassNames.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.loadObjectClasses(encodedObjectClasses, objectClassNames);
            }
            reader.readEndSequence();
            reader.readInteger();
            reader.readStartSequence();
            while (reader.hasNextElement()) {
                reader.readStartSequence();
                byte[] encodedAttribute = reader.readOctetString().toByteArray();
                String attributeName = reader.readOctetStringAsString();
                LinkedList<String> attributeOptions = new LinkedList<String>();
                while (reader.hasNextElement()) {
                    attributeOptions.add(reader.readOctetStringAsString());
                }
                reader.readEndSequence();
                this.loadAttribute(encodedAttribute, attributeName, attributeOptions);
            }
            reader.readEndSequence();
            reader.readInteger();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new RuntimeException(e);
        }
        finally {
            block20: {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block20;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws DirectoryException {
        Object object = this.saveLock;
        synchronized (object) {
            FileOutputStream outputStream = null;
            try {
                String path = DirectoryServer.getInstanceRoot() + File.separator + "config" + File.separator + "schematokens.dat";
                String tempPath = path + ".tmp";
                outputStream = new FileOutputStream(tempPath);
                ASN1Writer writer = ASN1.getWriter(outputStream);
                writer.writeStartSequence();
                int ocCounter = 1;
                for (Map.Entry<byte[], Collection<String>> mapEntry : this.getAllObjectClasses()) {
                    writer.writeStartSequence();
                    writer.writeOctetString(ByteString.wrap(mapEntry.getKey()));
                    Collection<String> objectClassNames = mapEntry.getValue();
                    for (String ocName : objectClassNames) {
                        writer.writeOctetString(ocName);
                    }
                    writer.writeEndSequence();
                    ++ocCounter;
                }
                writer.writeEndSequence();
                writer.writeInteger(ocCounter);
                writer.writeStartSequence();
                int adCounter = 1;
                for (Map.Entry<byte[], Map.Entry<String, Collection<String>>> mapEntry : this.getAllAttributes()) {
                    writer.writeStartSequence();
                    writer.writeOctetString(ByteString.wrap(mapEntry.getKey()));
                    writer.writeOctetString(mapEntry.getValue().getKey());
                    for (String option : mapEntry.getValue().getValue()) {
                        writer.writeOctetString(option);
                    }
                    writer.writeEndSequence();
                    ++adCounter;
                }
                writer.writeEndSequence();
                writer.writeInteger(adCounter);
                outputStream.close();
                File liveFile = new File(path);
                File tempFile = new File(tempPath);
                if (liveFile.exists()) {
                    File saveFile = new File(liveFile.getAbsolutePath() + ".save");
                    if (saveFile.exists()) {
                        saveFile.delete();
                    }
                    liveFile.renameTo(saveFile);
                }
                tempFile.renameTo(liveFile);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_CANNOT_WRITE_UPDATED_DATA.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
            finally {
                block21: {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block21;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
    }
}

