/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.GroupImplementationCfgDefn;
import org.opends.server.admin.std.server.GroupImplementationCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DITCacheMap;
import org.opends.server.api.Group;
import org.opends.server.api.plugin.InternalDirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PluginOperation;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostSynchronizationAddOperation;
import org.opends.server.types.operation.PostSynchronizationDeleteOperation;
import org.opends.server.types.operation.PostSynchronizationModifyDNOperation;
import org.opends.server.types.operation.PostSynchronizationModifyOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

public class GroupManager
extends InternalDirectoryServerPlugin
implements ConfigurationChangeListener<GroupImplementationCfg>,
ConfigurationAddListener<GroupImplementationCfg>,
ConfigurationDeleteListener<GroupImplementationCfg>,
BackendInitializationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private volatile long refreshToken = 0L;
    private ConcurrentHashMap<DN, Group> groupImplementations = new ConcurrentHashMap();
    private DITCacheMap<Group> groupInstances = new DITCacheMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final String CONFIG_DN = "cn=Group Manager,cn=config";

    public GroupManager() throws DirectoryException {
        super(DN.decode(CONFIG_DN), EnumSet.of(PluginType.POST_OPERATION_ADD, new PluginType[]{PluginType.POST_OPERATION_DELETE, PluginType.POST_OPERATION_MODIFY, PluginType.POST_OPERATION_MODIFY_DN, PluginType.POST_SYNCHRONIZATION_ADD, PluginType.POST_SYNCHRONIZATION_DELETE, PluginType.POST_SYNCHRONIZATION_MODIFY, PluginType.POST_SYNCHRONIZATION_MODIFY_DN}), true);
        DirectoryServer.registerInternalPlugin(this);
        DirectoryServer.registerBackendInitializationListener(this);
    }

    public void initializeGroupImplementations() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addGroupImplementationAddListener(this);
        rootConfiguration.addGroupImplementationDeleteListener(this);
        for (String name : rootConfiguration.listGroupImplementations()) {
            GroupImplementationCfg groupConfiguration = rootConfiguration.getGroupImplementation(name);
            groupConfiguration.addChangeListener(this);
            if (!groupConfiguration.isEnabled()) continue;
            String className = groupConfiguration.getJavaClass();
            try {
                Group group = this.loadGroup(className, groupConfiguration, true);
                this.groupImplementations.put(groupConfiguration.dn(), group);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(GroupImplementationCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadGroup(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(GroupImplementationCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        Group group = null;
        String className = configuration.getJavaClass();
        try {
            group = this.loadGroup(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.groupImplementations.put(configuration.dn(), group);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(GroupImplementationCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationDelete(GroupImplementationCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        Group group = this.groupImplementations.remove(configuration.dn());
        if (group != null) {
            this.lock.writeLock().lock();
            try {
                Iterator iterator = this.groupInstances.values().iterator();
                while (iterator.hasNext()) {
                    Group g = (Group)iterator.next();
                    if (!g.getClass().getName().equals(group.getClass().getName())) continue;
                    iterator.remove();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            group.finalizeGroupImplementation();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(GroupImplementationCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadGroup(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(GroupImplementationCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        Group existingGroup = this.groupImplementations.get(configuration.dn());
        if (!configuration.isEnabled()) {
            Group group;
            if (existingGroup != null && (group = this.groupImplementations.remove(configuration.dn())) != null) {
                this.lock.writeLock().lock();
                try {
                    Iterator iterator = this.groupInstances.values().iterator();
                    while (iterator.hasNext()) {
                        Group g = (Group)iterator.next();
                        if (!g.getClass().getName().equals(group.getClass().getName())) continue;
                        iterator.remove();
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                group.finalizeGroupImplementation();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingGroup != null) {
            if (!className.equals(existingGroup.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        Group group = null;
        try {
            group = this.loadGroup(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.groupImplementations.put(configuration.dn(), group);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private Group loadGroup(String className, GroupImplementationCfg configuration, boolean initialize) throws InitializationException {
        try {
            GroupImplementationCfgDefn definition = GroupImplementationCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<Group> groupClass = propertyDefinition.loadClass(className, Group.class);
            Group group = groupClass.newInstance();
            if (initialize) {
                Method method = group.getClass().getMethod("initializeGroupImplementation", configuration.configurationClass());
                method.invoke((Object)group, configuration);
            } else {
                Method method = group.getClass().getMethod("isConfigurationAcceptable", GroupImplementationCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)group, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_GROUP_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return group;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_GROUP_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public void finalizeGroupManager() {
        DirectoryServer.deregisterInternalPlugin(this);
        DirectoryServer.deregisterBackendInitializationListener(this);
        this.deregisterAllGroups();
        for (Group groupImplementation : this.groupImplementations.values()) {
            groupImplementation.finalizeGroupImplementation();
        }
        this.groupImplementations.clear();
    }

    public Iterable<Group> getGroupImplementations() {
        return this.groupImplementations.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Group> getGroupInstances() {
        this.lock.readLock().lock();
        try {
            ArrayList<Group> values = new ArrayList<Group>();
            values.addAll(this.groupInstances.values());
            ArrayList<Group> arrayList = values;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroupInstance(DN entryDN) {
        Group group = null;
        this.lock.readLock().lock();
        try {
            group = this.groupInstances.get(entryDN);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (group == null) {
            // empty if block
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBackendInitializationProcessing(Backend backend) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LinkedList<Control> requestControls = new LinkedList<Control>();
        requestControls.add(new LDAPControl("1.3.6.1.4.1.26027.1.5.1", false));
        for (DN configEntryDN : this.groupImplementations.keySet()) {
            SearchFilter filter;
            Group groupImplementation;
            block15: {
                groupImplementation = this.groupImplementations.get(configEntryDN);
                try {
                    filter = groupImplementation.getGroupDefinitionFilter();
                    if (backend.getEntryCount() <= 0L || backend.isIndexed(filter)) break block15;
                    ErrorLogger.logError(CoreMessages.WARN_GROUP_FILTER_NOT_INDEXED.get(String.valueOf(filter), String.valueOf(configEntryDN), backend.getBackendID()));
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    continue;
                }
            }
            for (DN baseDN : backend.getBaseDNs()) {
                block16: {
                    try {
                        if (!backend.entryExists(baseDN)) {
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    continue;
                }
                InternalSearchOperation internalSearch = new InternalSearchOperation((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), requestControls, baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, null, null);
                LocalBackendSearchOperation localSearch = new LocalBackendSearchOperation(internalSearch);
                try {
                    backend.search(localSearch);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    continue;
                }
                this.lock.writeLock().lock();
                try {
                    for (SearchResultEntry entry : internalSearch.getSearchEntries()) {
                        try {
                            Group groupInstance = groupImplementation.newInstance(entry);
                            this.groupInstances.put(entry.getDN(), groupInstance);
                            ++this.refreshToken;
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBackendFinalizationProcessing(Backend backend) {
        this.lock.writeLock().lock();
        try {
            Iterator<Map.Entry<DN, Group>> iterator = this.groupInstances.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DN, Group> mapEntry = iterator.next();
                DN groupEntryDN = mapEntry.getKey();
                if (!backend.handlesEntry(groupEntryDN)) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void doPostAdd(PluginOperation addOperation, Entry entry) {
        List<Control> requestControls = addOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        this.createAndRegisterGroup(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostDelete(PluginOperation deleteOperation, Entry entry) {
        List<Control> requestControls = deleteOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        this.lock.writeLock().lock();
        try {
            if (this.groupInstances.removeSubtree(entry.getDN(), null)) {
                ++this.refreshToken;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostModify(PluginOperation modifyOperation, Entry oldEntry, Entry newEntry) {
        List<Control> requestControls = modifyOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        this.lock.readLock().lock();
        try {
            if (!this.groupInstances.containsKey(oldEntry.getDN())) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.groupInstances.containsKey(oldEntry.getDN())) {
                if (!oldEntry.getDN().equals(newEntry.getDN())) {
                    this.groupInstances.remove(oldEntry.getDN());
                }
                this.createAndRegisterGroup(newEntry);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostModifyDN(PluginOperation modifyDNOperation, Entry oldEntry, Entry newEntry) {
        List<Control> requestControls = modifyDNOperation.getRequestControls();
        if (requestControls != null) {
            for (Control c : requestControls) {
                if (!c.getOID().equals("1.3.6.1.4.1.26027.1.5.1")) continue;
                return;
            }
        }
        this.lock.writeLock().lock();
        try {
            HashSet groupSet = new HashSet();
            this.groupInstances.removeSubtree(oldEntry.getDN(), groupSet);
            String oldDNString = oldEntry.getDN().toNormalizedString();
            String newDNString = newEntry.getDN().toNormalizedString();
            for (Group group : groupSet) {
                StringBuilder builder = new StringBuilder(group.getGroupDN().toNormalizedString());
                int oldDNIndex = builder.lastIndexOf(oldDNString);
                builder.replace(oldDNIndex, builder.length(), newDNString);
                String groupDNString = builder.toString();
                DN groupDN = DN.NULL_DN;
                try {
                    groupDN = DN.decode(groupDNString);
                }
                catch (DirectoryException de) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    continue;
                }
                group.setGroupDN(groupDN);
                this.groupInstances.put(groupDN, group);
            }
            if (!groupSet.isEmpty()) {
                ++this.refreshToken;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationAddOperation addOperation) {
        if (addOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostAdd(addOperation, addOperation.getEntryToAdd());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
        if (deleteOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostDelete(deleteOperation, deleteOperation.getEntryToDelete());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyOperation modifyOperation) {
        if (modifyOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostModify(modifyOperation, modifyOperation.getCurrentEntry(), modifyOperation.getModifiedEntry());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        if (modifyDNOperation.getResultCode() == ResultCode.SUCCESS) {
            this.doPostModifyDN(modifyDNOperation, modifyDNOperation.getOriginalEntry(), modifyDNOperation.getUpdatedEntry());
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public void doPostSynchronization(PostSynchronizationAddOperation addOperation) {
        Entry entry = addOperation.getEntryToAdd();
        if (entry != null) {
            this.doPostAdd(addOperation, entry);
        }
    }

    @Override
    public void doPostSynchronization(PostSynchronizationDeleteOperation deleteOperation) {
        Entry entry = deleteOperation.getEntryToDelete();
        if (entry != null) {
            this.doPostDelete(deleteOperation, entry);
        }
    }

    @Override
    public void doPostSynchronization(PostSynchronizationModifyOperation modifyOperation) {
        Entry entry = modifyOperation.getCurrentEntry();
        Entry modEntry = modifyOperation.getModifiedEntry();
        if (entry != null && modEntry != null) {
            this.doPostModify(modifyOperation, entry, modEntry);
        }
    }

    @Override
    public void doPostSynchronization(PostSynchronizationModifyDNOperation modifyDNOperation) {
        Entry oldEntry = modifyDNOperation.getOriginalEntry();
        Entry newEntry = modifyDNOperation.getUpdatedEntry();
        if (oldEntry != null && newEntry != null) {
            this.doPostModifyDN(modifyDNOperation, oldEntry, newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndRegisterGroup(Entry entry) {
        for (Group groupImplementation : this.groupImplementations.values()) {
            try {
                if (!groupImplementation.isGroupDefinition(entry)) continue;
                Group groupInstance = groupImplementation.newInstance(entry);
                this.lock.writeLock().lock();
                try {
                    this.groupInstances.put(entry.getDN(), groupInstance);
                    ++this.refreshToken;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterAllGroups() {
        this.lock.writeLock().lock();
        try {
            this.groupInstances.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean hasInstancesChanged(long token) {
        return token != this.refreshToken;
    }

    public long refreshToken() {
        return this.refreshToken;
    }
}

