/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.AuthenticationPolicy;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;

public abstract class PasswordPolicy
extends AuthenticationPolicy {
    protected PasswordPolicy() {
    }

    @Override
    public abstract DN getDN();

    public abstract boolean isAuthPasswordSyntax();

    public abstract List<PasswordStorageScheme<?>> getDefaultPasswordStorageSchemes();

    public abstract Set<String> getDeprecatedPasswordStorageSchemes();

    public abstract boolean isDefaultPasswordStorageScheme(String var1);

    public abstract boolean isDeprecatedPasswordStorageScheme(String var1);

    public abstract Collection<PasswordValidator<?>> getPasswordValidators();

    public abstract Collection<AccountStatusNotificationHandler<?>> getAccountStatusNotificationHandlers();

    public abstract PasswordGenerator<?> getPasswordGenerator();

    public abstract long getRequireChangeByTime();

    public abstract boolean isAllowExpiredPasswordChanges();

    public abstract boolean isAllowMultiplePasswordValues();

    public abstract boolean isAllowPreEncodedPasswords();

    public abstract boolean isAllowUserPasswordChanges();

    public abstract boolean isExpirePasswordsWithoutWarning();

    public abstract boolean isForceChangeOnAdd();

    public abstract boolean isForceChangeOnReset();

    public abstract int getGraceLoginCount();

    public abstract long getIdleLockoutInterval();

    public abstract AttributeType getLastLoginTimeAttribute();

    public abstract String getLastLoginTimeFormat();

    public abstract long getLockoutDuration();

    public abstract int getLockoutFailureCount();

    public abstract long getLockoutFailureExpirationInterval();

    public abstract long getMaxPasswordAge();

    public abstract long getMaxPasswordResetAge();

    public abstract long getMinPasswordAge();

    public abstract AttributeType getPasswordAttribute();

    public abstract boolean isPasswordChangeRequiresCurrentPassword();

    public abstract long getPasswordExpirationWarningInterval();

    public abstract int getPasswordHistoryCount();

    public abstract long getPasswordHistoryDuration();

    public abstract SortedSet<String> getPreviousLastLoginTimeFormats();

    public abstract boolean isRequireSecureAuthentication();

    public abstract boolean isRequireSecurePasswordChanges();

    public abstract boolean isSkipValidationForAdministrators();

    public abstract PasswordPolicyCfgDefn.StateUpdateFailurePolicy getStateUpdateFailurePolicy();

    @Override
    public boolean isPasswordPolicy() {
        return true;
    }

    @Override
    public PasswordPolicyState createAuthenticationPolicyState(Entry userEntry, long time) throws DirectoryException {
        return new PasswordPolicyState(this, userEntry, time);
    }
}

