/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.AuthenticationPolicyCfgDefn;
import org.opends.server.admin.std.server.AuthenticationPolicyCfg;
import org.opends.server.admin.std.server.PasswordPolicyCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AuthenticationPolicy;
import org.opends.server.api.AuthenticationPolicyFactory;
import org.opends.server.api.SubentryChangeListener;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SubentryPasswordPolicy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SubEntry;
import org.opends.server.util.StaticUtils;

final class PasswordPolicyConfigManager
implements SubentryChangeListener,
ConfigurationAddListener<AuthenticationPolicyCfg>,
ConfigurationDeleteListener<AuthenticationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeAuthenticationPolicies() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addPasswordPolicyAddListener(this);
        rootConfiguration.addPasswordPolicyDeleteListener(this);
        String[] passwordPolicyNames = rootConfiguration.listPasswordPolicies();
        if (passwordPolicyNames.length == 0) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_NO_POLICIES.get();
            throw new ConfigException(message);
        }
        if (DirectoryServer.getDefaultPasswordPolicyDN() == null) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_NO_DEFAULT_POLICY.get();
            throw new ConfigException(message);
        }
        for (String passwordPolicyName : passwordPolicyNames) {
            AuthenticationPolicyCfg passwordPolicyConfiguration = rootConfiguration.getPasswordPolicy(passwordPolicyName);
            PasswordPolicyConfigManager.createAuthenticationPolicy(passwordPolicyConfiguration);
        }
        if (null == DirectoryServer.getDefaultPasswordPolicy()) {
            DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_MISSING_DEFAULT_POLICY.get(String.valueOf(defaultPolicyDN));
            throw new ConfigException(message);
        }
        List<SubEntry> pwpSubEntries = DirectoryServer.getSubentryManager().getSubentries();
        if (pwpSubEntries != null && !pwpSubEntries.isEmpty()) {
            for (SubEntry subentry : pwpSubEntries) {
                if (!subentry.getEntry().isPasswordPolicySubentry()) continue;
                try {
                    SubentryPasswordPolicy policy = new SubentryPasswordPolicy(subentry);
                    DirectoryServer.registerAuthenticationPolicy(subentry.getDN(), policy);
                }
                catch (Exception e) {
                    Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(subentry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message);
                }
            }
        }
        DirectoryServer.getSubentryManager().registerChangeListener(this);
    }

    public void finalizeAuthenticationPolicies() {
        DirectoryServer.getSubentryManager().deregisterChangeListener(this);
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.removePasswordPolicyAddListener(this);
        rootConfiguration.removePasswordPolicyDeleteListener(this);
    }

    @Override
    public boolean isConfigurationAddAcceptable(AuthenticationPolicyCfg configuration, List<Message> unacceptableReason) {
        return PasswordPolicyConfigManager.isAuthenticationPolicyConfigurationAcceptable(configuration, unacceptableReason);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(AuthenticationPolicyCfg configuration) {
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            PasswordPolicyConfigManager.createAuthenticationPolicy(configuration);
            return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
        }
        catch (ConfigException ce) {
            messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ce.getMessage()));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, messages);
        }
        catch (InitializationException ie) {
            messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ie.getMessage()));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
        }
        catch (Exception e) {
            messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
        }
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(AuthenticationPolicyCfg configuration, List<Message> unacceptableReason) {
        DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (defaultPolicyDN != null && defaultPolicyDN.equals(configuration.dn())) {
            Message message = ConfigMessages.WARN_CONFIG_PWPOLICY_CANNOT_DELETE_DEFAULT_POLICY.get(String.valueOf(defaultPolicyDN));
            unacceptableReason.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(AuthenticationPolicyCfg configuration) {
        ArrayList<Message> messages = new ArrayList<Message>(1);
        DN policyDN = configuration.dn();
        DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (defaultPolicyDN != null && defaultPolicyDN.equals(policyDN)) {
            messages.add(ConfigMessages.WARN_CONFIG_PWPOLICY_CANNOT_DELETE_DEFAULT_POLICY.get(String.valueOf(defaultPolicyDN)));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, messages);
        }
        DirectoryServer.deregisterAuthenticationPolicy(policyDN);
        messages.add(ConfigMessages.INFO_CONFIG_PWPOLICY_REMOVED_POLICY.get(String.valueOf(policyDN)));
        return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
    }

    @Override
    public void checkSubentryAddAcceptable(Entry entry) throws DirectoryException {
        if (entry.isPasswordPolicySubentry()) {
            new SubentryPasswordPolicy(new SubEntry(entry));
        }
    }

    @Override
    public void checkSubentryDeleteAcceptable(Entry entry) throws DirectoryException {
    }

    @Override
    public void checkSubentryModifyAcceptable(Entry oldEntry, Entry newEntry) throws DirectoryException {
        if (newEntry.isPasswordPolicySubentry()) {
            new SubentryPasswordPolicy(new SubEntry(newEntry));
        }
    }

    @Override
    public void checkSubentryModifyDNAcceptable(Entry oldEntry, Entry newEntry) throws DirectoryException {
    }

    @Override
    public void handleSubentryAdd(Entry entry) {
        block3: {
            if (entry.isPasswordPolicySubentry()) {
                try {
                    SubentryPasswordPolicy policy = new SubentryPasswordPolicy(new SubEntry(entry));
                    DirectoryServer.registerAuthenticationPolicy(entry.getDN(), policy);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugError("Could not create password policy subentry DN %s: %s", entry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
    }

    @Override
    public void handleSubentryDelete(Entry entry) {
        if (entry.isPasswordPolicySubentry()) {
            DirectoryServer.deregisterAuthenticationPolicy(entry.getDN());
        }
    }

    @Override
    public void handleSubentryModify(Entry oldEntry, Entry newEntry) {
        block4: {
            if (oldEntry.isPasswordPolicySubentry()) {
                DirectoryServer.deregisterAuthenticationPolicy(oldEntry.getDN());
            }
            if (newEntry.isPasswordPolicySubentry()) {
                try {
                    SubentryPasswordPolicy policy = new SubentryPasswordPolicy(new SubEntry(newEntry));
                    DirectoryServer.registerAuthenticationPolicy(newEntry.getDN(), policy);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugError("Could not create password policy subentry DN %s: %s", newEntry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
    }

    @Override
    public void handleSubentryModifyDN(Entry oldEntry, Entry newEntry) {
        block4: {
            if (oldEntry.isPasswordPolicySubentry()) {
                DirectoryServer.deregisterAuthenticationPolicy(oldEntry.getDN());
            }
            if (newEntry.isPasswordPolicySubentry()) {
                try {
                    SubentryPasswordPolicy policy = new SubentryPasswordPolicy(new SubEntry(newEntry));
                    DirectoryServer.registerAuthenticationPolicy(newEntry.getDN(), policy);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugError("Could not create password policy subentry DN %s: %s", newEntry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
    }

    private static void createAuthenticationPolicy(AuthenticationPolicyCfg policyConfiguration) throws ConfigException, InitializationException {
        AuthenticationPolicy policy;
        AuthenticationPolicyFactory factory;
        Class<AuthenticationPolicyFactory> theClass;
        if (policyConfiguration.dn().equals(DirectoryServer.getDefaultPasswordPolicyDN()) && !(policyConfiguration instanceof PasswordPolicyCfg)) {
            Message msg = ConfigMessages.ERR_CONFIG_PWPOLICY_DEFAULT_POLICY_IS_WRONG_TYPE.get(String.valueOf(policyConfiguration.dn()));
            throw new ConfigException(msg);
        }
        String className = policyConfiguration.getJavaClass();
        AuthenticationPolicyCfgDefn d = AuthenticationPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            theClass = pd.loadClass(className, AuthenticationPolicyFactory.class);
            factory = theClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(policyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        try {
            Method method = theClass.getMethod("createAuthenticationPolicy", policyConfiguration.configurationClass());
            policy = (AuthenticationPolicy)method.invoke((Object)factory, policyConfiguration);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = e.getCause();
                if (t instanceof InitializationException) {
                    throw (InitializationException)t;
                }
                if (t instanceof ConfigException) {
                    throw (ConfigException)t;
                }
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(policyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        DirectoryServer.registerAuthenticationPolicy(policyConfiguration.dn(), policy);
    }

    private static boolean isAuthenticationPolicyConfigurationAcceptable(AuthenticationPolicyCfg policyConfiguration, List<Message> unacceptableReasons) {
        if (policyConfiguration.dn().equals(DirectoryServer.getDefaultPasswordPolicyDN()) && !(policyConfiguration instanceof PasswordPolicyCfg)) {
            Message msg = ConfigMessages.ERR_CONFIG_PWPOLICY_DEFAULT_POLICY_IS_WRONG_TYPE.get(String.valueOf(policyConfiguration.dn()));
            unacceptableReasons.add(msg);
            return false;
        }
        String className = policyConfiguration.getJavaClass();
        AuthenticationPolicyCfgDefn d = AuthenticationPolicyCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            Class<AuthenticationPolicyFactory> theClass = pd.loadClass(className, AuthenticationPolicyFactory.class);
            AuthenticationPolicyFactory factory = theClass.newInstance();
            Method method = theClass.getMethod("isConfigurationAcceptable", AuthenticationPolicyCfg.class, List.class);
            return (Boolean)method.invoke((Object)factory, policyConfiguration, unacceptableReasons);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(policyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
    }
}

