/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.ResultCode;

public class WorkflowResultCode {
    private ResultCode resultCode = ResultCode.UNDEFINED;
    private MessageBuilder errorMessage = new MessageBuilder(Message.EMPTY);

    public WorkflowResultCode() {
    }

    public WorkflowResultCode(ResultCode resultCode, MessageBuilder errorMessage) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
    }

    public boolean elaborateGlobalResultCode(ResultCode newResultCode, MessageBuilder newErrorMessage) {
        boolean sendReferenceEntry = false;
        if (this.resultCode == ResultCode.UNDEFINED) {
            this.resultCode = newResultCode;
            this.errorMessage = new MessageBuilder(newErrorMessage);
        } else {
            block0 : switch (newResultCode) {
                case SUCCESS: {
                    switch (this.resultCode) {
                        case NO_SUCH_OBJECT: {
                            this.resultCode = ResultCode.SUCCESS;
                            this.errorMessage = new MessageBuilder(Message.EMPTY);
                            break block0;
                        }
                        case REFERRAL: {
                            this.resultCode = ResultCode.SUCCESS;
                            this.errorMessage = new MessageBuilder(Message.EMPTY);
                            sendReferenceEntry = true;
                            break block0;
                        }
                    }
                    break;
                }
                case NO_SUCH_OBJECT: {
                    break;
                }
                case REFERRAL: {
                    switch (this.resultCode) {
                        case REFERRAL: {
                            this.resultCode = ResultCode.SUCCESS;
                            this.errorMessage = new MessageBuilder(Message.EMPTY);
                            sendReferenceEntry = true;
                            break block0;
                        }
                        case NO_SUCH_OBJECT: {
                            this.resultCode = ResultCode.REFERRAL;
                            this.errorMessage = new MessageBuilder(Message.EMPTY);
                            break block0;
                        }
                    }
                    sendReferenceEntry = true;
                    break;
                }
                default: {
                    switch (this.resultCode) {
                        case REFERRAL: {
                            this.resultCode = newResultCode;
                            this.errorMessage = new MessageBuilder(newErrorMessage);
                            sendReferenceEntry = true;
                            break block0;
                        }
                        case SUCCESS: {
                            this.resultCode = newResultCode;
                            this.errorMessage = new MessageBuilder(newErrorMessage);
                            break block0;
                        }
                        case NO_SUCH_OBJECT: {
                            this.resultCode = newResultCode;
                            this.errorMessage = new MessageBuilder(newErrorMessage);
                            break block0;
                        }
                    }
                }
            }
        }
        return sendReferenceEntry;
    }

    public ResultCode resultCode() {
        return this.resultCode;
    }

    public MessageBuilder errorMessage() {
        return this.errorMessage;
    }
}

