/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.net.InetAddress;
import java.util.Collection;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.ConnectionCriteria;
import org.opends.server.types.AddressMask;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

final class IPConnectionCriteria
implements ConnectionCriteria {
    private final Collection<AddressMask> allowedClients;
    private final Collection<AddressMask> deniedClients;

    public IPConnectionCriteria(Collection<AddressMask> allowedClients, Collection<AddressMask> deniedClients) {
        this.allowedClients = allowedClients;
        this.deniedClients = deniedClients;
    }

    @Override
    public boolean matches(ClientConnection connection) {
        InetAddress ipAddr = connection.getRemoteAddress();
        if (!this.deniedClients.isEmpty() && AddressMask.maskListContains(ipAddr, this.deniedClients)) {
            return false;
        }
        return this.allowedClients.isEmpty() || AddressMask.maskListContains(ipAddr, this.allowedClients);
    }

    @Override
    public boolean willMatchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        return this.matches(connection);
    }
}

