/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.ADSContext;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CryptoManagerCfg;
import org.opends.server.api.Backend;
import org.opends.server.backends.TrustStoreBackend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.crypto.GetSymmetricKeyExtendedOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.schema.BinarySyntax;
import org.opends.server.schema.DirectoryStringSyntax;
import org.opends.server.schema.IntegerSyntax;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IdentifiedException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.Base64;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class CryptoManagerImpl
implements ConfigurationChangeListener<CryptoManagerCfg>,
CryptoManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static AttributeType attrKeyID;
    private static AttributeType attrPublicKeyCertificate;
    private static AttributeType attrTransformation;
    private static AttributeType attrMacAlgorithm;
    private static AttributeType attrSymmetricKey;
    private static AttributeType attrInitVectorLength;
    private static AttributeType attrKeyLength;
    private static AttributeType attrCompromisedTime;
    private static ObjectClass ocCertRequest;
    private static ObjectClass ocInstanceKey;
    private static ObjectClass ocCipherKey;
    private static ObjectClass ocMacKey;
    private static DN localTruststoreDN;
    private static DN instanceKeysDN;
    private static DN secretKeysDN;
    private static DN serversDN;
    private static boolean schemaInitDone;
    private static final SecureRandom secureRandom;
    private static final Random pseudoRandom;
    private static final int CIPHERTEXT_PROLOGUE_VERSION = 1;
    private final Map<KeyEntryID, CipherKeyEntry> cipherKeyEntryCache = new ConcurrentHashMap<KeyEntryID, CipherKeyEntry>();
    private final Map<KeyEntryID, MacKeyEntry> macKeyEntryCache = new ConcurrentHashMap<KeyEntryID, MacKeyEntry>();
    private String preferredKeyWrappingTransformation;
    private String preferredDigestAlgorithm;
    private String preferredCipherTransformation;
    private int preferredCipherTransformationKeyLengthBits;
    private String preferredMACAlgorithm;
    private int preferredMACAlgorithmKeyLengthBits;
    private final String sslCertNickname;
    private final boolean sslEncryption;
    private final SortedSet<String> sslProtocols;
    private final SortedSet<String> sslCipherSuites;

    public CryptoManagerImpl(CryptoManagerCfg cfg) throws ConfigException, InitializationException {
        LinkedList<Message> why;
        if (!schemaInitDone) {
            attrKeyID = DirectoryServer.getAttributeType("ds-cfg-key-id");
            attrPublicKeyCertificate = DirectoryServer.getAttributeType("ds-cfg-public-key-certificate");
            attrTransformation = DirectoryServer.getAttributeType("ds-cfg-cipher-transformation-name");
            attrMacAlgorithm = DirectoryServer.getAttributeType("ds-cfg-mac-algorithm-name");
            attrSymmetricKey = DirectoryServer.getAttributeType("ds-cfg-symmetric-key");
            attrInitVectorLength = DirectoryServer.getAttributeType("ds-cfg-initialization-vector-length-bits");
            attrKeyLength = DirectoryServer.getAttributeType("ds-cfg-key-length-bits");
            attrCompromisedTime = DirectoryServer.getAttributeType("ds-cfg-key-compromised-time");
            ocCertRequest = DirectoryServer.getObjectClass("ds-cfg-self-signed-cert-request");
            ocInstanceKey = DirectoryServer.getObjectClass("ds-cfg-instance-key");
            ocCipherKey = DirectoryServer.getObjectClass("ds-cfg-cipher-key");
            ocMacKey = DirectoryServer.getObjectClass("ds-cfg-mac-key");
            try {
                localTruststoreDN = DN.decode("cn=ads-truststore");
                DN adminSuffixDN = DN.decode(ADSContext.getAdministrationSuffixDN());
                instanceKeysDN = adminSuffixDN.concat(DN.decode("cn=instance keys"));
                secretKeysDN = adminSuffixDN.concat(DN.decode("cn=secret keys"));
                serversDN = adminSuffixDN.concat(DN.decode("cn=Servers"));
            }
            catch (DirectoryException ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                throw new InitializationException(ex.getMessageObject());
            }
            schemaInitDone = true;
        }
        if (!this.isConfigurationChangeAcceptable(cfg, (List<Message>)(why = new LinkedList<Message>()))) {
            throw new InitializationException((Message)why.get(0));
        }
        this.applyConfigurationChange(cfg);
        this.sslCertNickname = cfg.getSSLCertNickname();
        this.sslEncryption = cfg.isSSLEncryption();
        this.sslProtocols = cfg.getSSLProtocol();
        this.sslCipherSuites = cfg.getSSLCipherSuite();
        cfg.addChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CryptoManagerCfg cfg, List<Message> unacceptableReasons) {
        String requestedKeyWrappingTransformation;
        boolean isAcceptable = true;
        String requestedDigestAlgorithm = cfg.getDigestAlgorithm();
        if (!requestedDigestAlgorithm.equals(this.preferredDigestAlgorithm)) {
            try {
                MessageDigest.getInstance(requestedDigestAlgorithm);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                unacceptableReasons.add(CoreMessages.ERR_CRYPTOMGR_CANNOT_GET_REQUESTED_DIGEST.get(requestedDigestAlgorithm, StaticUtils.getExceptionMessage(ex)));
                isAcceptable = false;
            }
        }
        String requestedCipherTransformation = cfg.getCipherTransformation();
        Integer requestedCipherTransformationKeyLengthBits = cfg.getCipherKeyLength();
        if (!requestedCipherTransformation.equals(this.preferredCipherTransformation) || requestedCipherTransformationKeyLengthBits != this.preferredCipherTransformationKeyLengthBits) {
            if (3 != requestedCipherTransformation.split("/", 0).length) {
                unacceptableReasons.add(CoreMessages.ERR_CRYPTOMGR_FULL_CIPHER_TRANSFORMATION_REQUIRED.get(requestedCipherTransformation));
                isAcceptable = false;
            } else {
                try {
                    CipherKeyEntry.generateKeyEntry(null, requestedCipherTransformation, requestedCipherTransformationKeyLengthBits);
                }
                catch (Exception ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                    unacceptableReasons.add(CoreMessages.ERR_CRYPTOMGR_CANNOT_GET_REQUESTED_ENCRYPTION_CIPHER.get(requestedCipherTransformation, StaticUtils.getExceptionMessage(ex)));
                    isAcceptable = false;
                }
            }
        }
        String requestedMACAlgorithm = cfg.getMacAlgorithm();
        Integer requestedMACAlgorithmKeyLengthBits = cfg.getMacKeyLength();
        if (!requestedMACAlgorithm.equals(this.preferredMACAlgorithm) || requestedMACAlgorithmKeyLengthBits != this.preferredMACAlgorithmKeyLengthBits) {
            try {
                MacKeyEntry.generateKeyEntry(null, requestedMACAlgorithm, requestedMACAlgorithmKeyLengthBits);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                unacceptableReasons.add(CoreMessages.ERR_CRYPTOMGR_CANNOT_GET_REQUESTED_MAC_ENGINE.get(requestedMACAlgorithm, StaticUtils.getExceptionMessage(ex)));
                isAcceptable = false;
            }
        }
        if (!(requestedKeyWrappingTransformation = cfg.getKeyWrappingTransformation()).equals(this.preferredKeyWrappingTransformation)) {
            if (3 != requestedKeyWrappingTransformation.split("/", 0).length) {
                unacceptableReasons.add(CoreMessages.ERR_CRYPTOMGR_FULL_KEY_WRAPPING_TRANSFORMATION_REQUIRED.get(requestedKeyWrappingTransformation));
                isAcceptable = false;
            } else {
                try {
                    String certificateBase64 = "MIIB2jCCAUMCBEb7wpYwDQYJKoZIhvcNAQEEBQAwNDEbMBkGA1UEChMST3BlbkRTIENlcnRpZmljYXRlMRUwEwYDVQQDEwwxMC4wLjI0OC4yNTEwHhcNMDcwOTI3MTQ0NzUwWhcNMjcwOTIyMTQ0NzUwWjA0MRswGQYDVQQKExJPcGVuRFMgQ2VydGlmaWNhdGUxFTATBgNVBAMTDDEwLjAuMjQ4LjI1MTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAnIm6ELyuNVbpaacBQ7fzHlHMmQO/CYJb2gPTdb9n1HLOBqh2lmLLHvt2SgBeN5TSa1PAHW8zJy9LDhpWKZvsUOIdQD8Ula/0d/jvMEByEj/hr00P6yqgLXk+EudPgOkFXHA+IfkkOSghMooWc/L8HnD1REdqeZuxp+ARNU+cc/ECAwEAATANBgkqhkiG9w0BAQQFAAOBgQBemyCUjucN34MZwvzbmFHT/leUu3/cpykbGM9HL2QUX7iKvv2LJVqexhj7CLoXxZPoNL+HHKW0vi5/7W5KwOZsPqKI2SdYV7nDqTZklm5ZP0gmIuNO6mTqBRtC2DlplX1Iq+BrQJAmteiPtwhdZD+EIghe51CaseImjlLlY2ZK8w==";
                    byte[] certificate = Base64.decode("MIIB2jCCAUMCBEb7wpYwDQYJKoZIhvcNAQEEBQAwNDEbMBkGA1UEChMST3BlbkRTIENlcnRpZmljYXRlMRUwEwYDVQQDEwwxMC4wLjI0OC4yNTEwHhcNMDcwOTI3MTQ0NzUwWhcNMjcwOTIyMTQ0NzUwWjA0MRswGQYDVQQKExJPcGVuRFMgQ2VydGlmaWNhdGUxFTATBgNVBAMTDDEwLjAuMjQ4LjI1MTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAnIm6ELyuNVbpaacBQ7fzHlHMmQO/CYJb2gPTdb9n1HLOBqh2lmLLHvt2SgBeN5TSa1PAHW8zJy9LDhpWKZvsUOIdQD8Ula/0d/jvMEByEj/hr00P6yqgLXk+EudPgOkFXHA+IfkkOSghMooWc/L8HnD1REdqeZuxp+ARNU+cc/ECAwEAATANBgkqhkiG9w0BAQQFAAOBgQBemyCUjucN34MZwvzbmFHT/leUu3/cpykbGM9HL2QUX7iKvv2LJVqexhj7CLoXxZPoNL+HHKW0vi5/7W5KwOZsPqKI2SdYV7nDqTZklm5ZP0gmIuNO6mTqBRtC2DlplX1Iq+BrQJAmteiPtwhdZD+EIghe51CaseImjlLlY2ZK8w==");
                    String keyID = CryptoManagerImpl.getInstanceKeyID(certificate);
                    SecretKey macKey = MacKeyEntry.generateKeyEntry(null, requestedMACAlgorithm, requestedMACAlgorithmKeyLengthBits).getSecretKey();
                    this.encodeSymmetricKeyAttribute(requestedKeyWrappingTransformation, keyID, certificate, macKey);
                }
                catch (Exception ex) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                    unacceptableReasons.add(CoreMessages.ERR_CRYPTOMGR_CANNOT_GET_PREFERRED_KEY_WRAPPING_CIPHER.get(StaticUtils.getExceptionMessage(ex)));
                    isAcceptable = false;
                }
            }
        }
        return isAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CryptoManagerCfg cfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.preferredDigestAlgorithm = cfg.getDigestAlgorithm();
        this.preferredMACAlgorithm = cfg.getMacAlgorithm();
        this.preferredMACAlgorithmKeyLengthBits = cfg.getMacKeyLength();
        this.preferredCipherTransformation = cfg.getCipherTransformation();
        this.preferredCipherTransformationKeyLengthBits = cfg.getCipherKeyLength();
        this.preferredKeyWrappingTransformation = cfg.getKeyWrappingTransformation();
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private TrustStoreBackend getTrustStoreBackend() throws ConfigException {
        Backend b = DirectoryServer.getBackend("ads-truststore");
        if (b == null) {
            Message msg = CoreMessages.ERR_CRYPTOMGR_ADS_TRUST_STORE_BACKEND_NOT_ENABLED.get("ads-truststore");
            throw new ConfigException(msg);
        }
        if (!(b instanceof TrustStoreBackend)) {
            Message msg = CoreMessages.ERR_CRYPTOMGR_ADS_TRUST_STORE_BACKEND_WRONG_CLASS.get("ads-truststore");
            throw new ConfigException(msg);
        }
        return (TrustStoreBackend)b;
    }

    static byte[] getInstanceKeyCertificateFromLocalTruststore() throws CryptoManagerException {
        AttributeValue distinguishedValue = AttributeValues.create(attrKeyID, "ads-certificate");
        DN entryDN = localTruststoreDN.concat(RDN.create(attrKeyID, distinguishedValue));
        String FILTER_OC_INSTANCE_KEY = "(objectclass=" + ocInstanceKey.getNameOrOID() + ")";
        LinkedHashSet<String> requestedAttributes = new LinkedHashSet<String>();
        requestedAttributes.add(attrPublicKeyCertificate.getNameOrOID() + ";binary");
        InternalClientConnection icc = InternalClientConnection.getRootConnection();
        byte[] certificate = null;
        try {
            for (int i = 0; i < 2; ++i) {
                try {
                    InternalSearchOperation searchOp = icc.processSearch(entryDN, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString(FILTER_OC_INSTANCE_KEY), requestedAttributes);
                    for (SearchResultEntry e : searchOp.getSearchEntries()) {
                        certificate = e.getAttributeValue(attrPublicKeyCertificate, BinarySyntax.DECODER).toByteArray();
                    }
                    break;
                }
                catch (DirectoryException ex) {
                    if (0 == i && ResultCode.NO_SUCH_OBJECT == ex.getResultCode()) {
                        Entry entry = new Entry(entryDN, null, null, null);
                        entry.addObjectClass(DirectoryServer.getTopObjectClass());
                        entry.addObjectClass(ocCertRequest);
                        AddOperation addOperation = icc.processAdd(entry.getDN(), entry.getObjectClasses(), entry.getUserAttributes(), entry.getOperationalAttributes());
                        if (ResultCode.SUCCESS == addOperation.getResultCode()) continue;
                        throw new DirectoryException(addOperation.getResultCode(), CoreMessages.ERR_CRYPTOMGR_FAILED_TO_INITIATE_INSTANCE_KEY_GENERATION.get(entry.getDN().toString()));
                    }
                    throw ex;
                }
            }
        }
        catch (DirectoryException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_FAILED_TO_RETRIEVE_INSTANCE_CERTIFICATE.get(entryDN.toString(), StaticUtils.getExceptionMessage(ex)), ex);
        }
        if (certificate == null) {
            Message msg = CoreMessages.ERR_CRYPTOMGR_FAILED_INSTANCE_CERTIFICATE_NULL.get(entryDN.toString());
            throw new CryptoManagerException(msg);
        }
        return certificate;
    }

    String getInstanceKeyID() throws CryptoManagerException {
        return CryptoManagerImpl.getInstanceKeyID(CryptoManagerImpl.getInstanceKeyCertificateFromLocalTruststore());
    }

    public static String getInstanceKeyID(byte[] instanceKeyCertificate) throws CryptoManagerException {
        MessageDigest md;
        String mdAlgorithmName = "MD5";
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_FAILED_TO_COMPUTE_INSTANCE_KEY_IDENTIFIER.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        return StaticUtils.bytesToHexNoSpace(md.digest(instanceKeyCertificate));
    }

    static void publishInstanceKeyEntryInADS() throws CryptoManagerException {
        byte[] instanceKeyCertificate = CryptoManagerImpl.getInstanceKeyCertificateFromLocalTruststore();
        String instanceKeyID = CryptoManagerImpl.getInstanceKeyID(instanceKeyCertificate);
        AttributeValue distinguishedValue = AttributeValues.create(attrKeyID, instanceKeyID);
        DN entryDN = instanceKeysDN.concat(RDN.create(attrKeyID, distinguishedValue));
        String FILTER_OC_INSTANCE_KEY = "(objectclass=" + ocInstanceKey.getNameOrOID() + ")";
        LinkedHashSet<String> requestedAttributes = new LinkedHashSet<String>();
        requestedAttributes.add("dn");
        InternalClientConnection icc = InternalClientConnection.getRootConnection();
        try {
            InternalSearchOperation searchOp = icc.processSearch(entryDN, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString(FILTER_OC_INSTANCE_KEY), requestedAttributes);
            if (0 == searchOp.getSearchEntries().size()) {
                Entry entry = new Entry(entryDN, null, null, null);
                entry.addObjectClass(DirectoryServer.getTopObjectClass());
                entry.addObjectClass(ocInstanceKey);
                Attribute keyIDAttr = Attributes.create(attrKeyID, distinguishedValue);
                entry.addAttribute(keyIDAttr, new ArrayList<AttributeValue>(0));
                AttributeBuilder builder = new AttributeBuilder(attrPublicKeyCertificate);
                builder.setOption("binary");
                builder.add(AttributeValues.create(attrPublicKeyCertificate, ByteString.wrap(instanceKeyCertificate)));
                Attribute certificateAttr = builder.toAttribute();
                entry.addAttribute(certificateAttr, new ArrayList<AttributeValue>(0));
                AddOperation addOperation = icc.processAdd(entry.getDN(), entry.getObjectClasses(), entry.getUserAttributes(), entry.getOperationalAttributes());
                if (ResultCode.SUCCESS != addOperation.getResultCode()) {
                    throw new DirectoryException(addOperation.getResultCode(), CoreMessages.ERR_CRYPTOMGR_FAILED_TO_ADD_INSTANCE_KEY_ENTRY_TO_ADS.get(entry.getDN().toString()));
                }
            }
        }
        catch (DirectoryException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_FAILED_TO_PUBLISH_INSTANCE_KEY_ENTRY.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
    }

    private Map<String, byte[]> getTrustedCertificates() throws CryptoManagerException {
        HashMap<String, byte[]> certificateMap = new HashMap<String, byte[]>();
        try {
            String FILTER_OC_INSTANCE_KEY = "(objectclass=" + ocInstanceKey.getNameOrOID() + ")";
            String FILTER_NOT_COMPROMISED = "(!(" + attrCompromisedTime.getNameOrOID() + "=*))";
            String searchFilter = "(&" + FILTER_OC_INSTANCE_KEY + FILTER_NOT_COMPROMISED + ")";
            LinkedHashSet<String> requestedAttributes = new LinkedHashSet<String>();
            requestedAttributes.add(attrKeyID.getNameOrOID());
            requestedAttributes.add(attrPublicKeyCertificate.getNameOrOID() + ";binary");
            InternalClientConnection icc = InternalClientConnection.getRootConnection();
            InternalSearchOperation searchOp = icc.processSearch(instanceKeysDN, SearchScope.SINGLE_LEVEL, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString(searchFilter), requestedAttributes);
            for (SearchResultEntry e : searchOp.getSearchEntries()) {
                String keyID = e.getAttributeValue(attrKeyID, DirectoryStringSyntax.DECODER);
                byte[] certificate = e.getAttributeValue(attrPublicKeyCertificate, BinarySyntax.DECODER).toByteArray();
                certificateMap.put(keyID, certificate);
            }
        }
        catch (DirectoryException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_FAILED_TO_RETRIEVE_ADS_TRUSTSTORE_CERTS.get(instanceKeysDN.toString(), StaticUtils.getExceptionMessage(ex)), ex);
        }
        return certificateMap;
    }

    private String encodeSymmetricKeyAttribute(String wrappingKeyID, byte[] wrappingKeyCertificateData, SecretKey secretKey) throws CryptoManagerException {
        return this.encodeSymmetricKeyAttribute(this.preferredKeyWrappingTransformation, wrappingKeyID, wrappingKeyCertificateData, secretKey);
    }

    private String encodeSymmetricKeyAttribute(String wrappingTransformationName, String wrappingKeyID, byte[] wrappingKeyCertificateData, SecretKey secretKey) throws CryptoManagerException {
        String wrappedKeyElement;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate certificate = cf.generateCertificate(new ByteArrayInputStream(wrappingKeyCertificateData));
            Cipher wrapper = Cipher.getInstance(wrappingTransformationName);
            wrapper.init(3, certificate);
            byte[] wrappedKey = wrapper.wrap(secretKey);
            wrappedKeyElement = StaticUtils.bytesToHexNoSpace(wrappedKey);
        }
        catch (GeneralSecurityException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_FAILED_TO_ENCODE_SYMMETRIC_KEY_ATTRIBUTE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        StringBuilder symmetricKeyAttribute = new StringBuilder();
        symmetricKeyAttribute.append(wrappingKeyID);
        symmetricKeyAttribute.append(":");
        symmetricKeyAttribute.append(wrappingTransformationName);
        symmetricKeyAttribute.append(":");
        symmetricKeyAttribute.append(secretKey.getAlgorithm());
        symmetricKeyAttribute.append(":");
        symmetricKeyAttribute.append(wrappedKeyElement);
        return symmetricKeyAttribute.toString();
    }

    private SecretKey decodeSymmetricKeyAttribute(String symmetricKeyAttribute) throws CryptoManagerException {
        SecretKey secretKey;
        PrivateKey privateKey;
        byte[] wrappedKeyCipherTextElement;
        String wrappedKeyAlgorithmElement;
        String wrappingTransformationElement;
        String wrappingKeyIDElement;
        String[] elements = symmetricKeyAttribute.split(":", 0);
        if (4 != elements.length) {
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECODE_SYMMETRIC_KEY_ATTRIBUTE_FIELD_COUNT.get(symmetricKeyAttribute));
        }
        String fieldName = null;
        try {
            fieldName = "instance key identifier";
            wrappingKeyIDElement = elements[0];
            fieldName = "key wrapping transformation";
            wrappingTransformationElement = elements[1];
            fieldName = "wrapped key algorithm";
            wrappedKeyAlgorithmElement = elements[2];
            fieldName = "wrapped key data";
            wrappedKeyCipherTextElement = StaticUtils.hexStringToByteArray(elements[3]);
        }
        catch (ParseException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECODE_SYMMETRIC_KEY_ATTRIBUTE_SYNTAX.get(symmetricKeyAttribute, fieldName, ex.getErrorOffset()), ex);
        }
        String instanceKeyID = this.getInstanceKeyID();
        if (!wrappingKeyIDElement.equals(instanceKeyID)) {
            return null;
        }
        try {
            privateKey = (PrivateKey)this.getTrustStoreBackend().getKey("ads-certificate");
        }
        catch (IdentifiedException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECODE_SYMMETRIC_KEY_ATTRIBUTE_NO_PRIVATE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        try {
            Cipher unwrapper = Cipher.getInstance(wrappingTransformationElement);
            unwrapper.init(4, privateKey);
            secretKey = (SecretKey)unwrapper.unwrap(wrappedKeyCipherTextElement, wrappedKeyAlgorithmElement, 3);
        }
        catch (GeneralSecurityException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECODE_SYMMETRIC_KEY_ATTRIBUTE_DECIPHER.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        return secretKey;
    }

    String reencodeSymmetricKeyAttribute(String symmetricKeyAttribute, String requestedInstanceKeyID) throws CryptoManagerException {
        SecretKey secretKey = this.decodeSymmetricKeyAttribute(symmetricKeyAttribute);
        Map<String, byte[]> certMap = this.getTrustedCertificates();
        if (!certMap.containsKey(requestedInstanceKeyID) || null == certMap.get(requestedInstanceKeyID)) {
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_REWRAP_SYMMETRIC_KEY_ATTRIBUTE_NO_WRAPPER.get(requestedInstanceKeyID));
        }
        byte[] wrappingKeyCert = certMap.get(requestedInstanceKeyID);
        return this.encodeSymmetricKeyAttribute(this.preferredKeyWrappingTransformation, requestedInstanceKeyID, wrappingKeyCert, secretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSymmetricKey(List<String> symmetricKeys) {
        InternalClientConnection internalConnection = InternalClientConnection.getRootConnection();
        Iterator<String> i$ = symmetricKeys.iterator();
        block5: while (i$.hasNext()) {
            String symmetricKey = i$.next();
            try {
                String[] elements = symmetricKey.split(":", 0);
                String instanceKeyID = elements[0];
                String filter = "(ds-cfg-key-id=" + instanceKeyID + ")";
                InternalSearchOperation internalSearch = internalConnection.processSearch(serversDN, SearchScope.SUBORDINATE_SUBTREE, SearchFilter.createFilterFromString(filter));
                if (internalSearch.getResultCode() != ResultCode.SUCCESS) continue;
                LinkedList<SearchResultEntry> resultEntries = internalSearch.getSearchEntries();
                Iterator i$2 = resultEntries.iterator();
                while (true) {
                    if (!i$2.hasNext()) continue block5;
                    SearchResultEntry resultEntry = (SearchResultEntry)i$2.next();
                    AttributeType hostnameAttr = DirectoryServer.getAttributeType("hostname", true);
                    String hostname = resultEntry.getAttributeValue(hostnameAttr, DirectoryStringSyntax.DECODER);
                    AttributeType ldapPortAttr = DirectoryServer.getAttributeType("ldapport", true);
                    Integer ldapPort = resultEntry.getAttributeValue(ldapPortAttr, IntegerSyntax.DECODER);
                    AtomicInteger nextMessageID = new AtomicInteger(1);
                    LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
                    PrintStream nullPrintStream = new PrintStream(new OutputStream(){

                        @Override
                        public void write(int b) {
                        }
                    });
                    LDAPConnection connection = new LDAPConnection(hostname, ldapPort, connectionOptions, nullPrintStream, nullPrintStream);
                    connection.connectToHost(null, null, nextMessageID);
                    try {
                        LDAPReader reader = connection.getLDAPReader();
                        LDAPWriter writer = connection.getLDAPWriter();
                        ByteString requestValue = GetSymmetricKeyExtendedOperation.encodeRequestValue(symmetricKey, this.getInstanceKeyID());
                        ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.26027.1.6.3", requestValue);
                        ArrayList<Control> controls = new ArrayList<Control>();
                        LDAPMessage requestMessage = new LDAPMessage(nextMessageID.getAndIncrement(), extendedRequest, controls);
                        writer.writeMessage(requestMessage);
                        LDAPMessage responseMessage = reader.readMessage();
                        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                        if (extendedResponse.getResultCode() != 0) continue;
                        String string = extendedResponse.getValue().toString();
                        return string;
                    }
                    finally {
                        connection.close(nextMessageID);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    void importCipherKeyEntry(Entry entry) throws CryptoManagerException {
        if (!entry.hasObjectClass(ocCipherKey)) {
            return;
        }
        try {
            String symmetricKey;
            String keyID = entry.getAttributeValue(attrKeyID, DirectoryStringSyntax.DECODER);
            int ivLengthBits = entry.getAttributeValue(attrInitVectorLength, IntegerSyntax.DECODER);
            int keyLengthBits = entry.getAttributeValue(attrKeyLength, IntegerSyntax.DECODER);
            String transformation = entry.getAttributeValue(attrTransformation, DirectoryStringSyntax.DECODER);
            String compromisedTime = entry.getAttributeValue(attrCompromisedTime, DirectoryStringSyntax.DECODER);
            boolean isCompromised = compromisedTime != null;
            ArrayList<String> symmetricKeys = new ArrayList<String>();
            entry.getAttributeValues(attrSymmetricKey, DirectoryStringSyntax.DECODER, symmetricKeys);
            SecretKey secretKey = null;
            Iterator i$ = symmetricKeys.iterator();
            while (i$.hasNext() && (secretKey = this.decodeSymmetricKeyAttribute(symmetricKey = (String)i$.next())) == null) {
            }
            if (null != secretKey) {
                CipherKeyEntry.importCipherKeyEntry(this, keyID, transformation, secretKey, keyLengthBits, ivLengthBits, isCompromised);
                return;
            }
            String symmetricKey2 = this.getSymmetricKey(symmetricKeys);
            if (symmetricKey2 == null) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FAILED_TO_DECODE.get(entry.getDN().toString()));
            }
            secretKey = this.decodeSymmetricKeyAttribute(symmetricKey2);
            CipherKeyEntry.importCipherKeyEntry(this, keyID, transformation, secretKey, keyLengthBits, ivLengthBits, isCompromised);
            InternalClientConnection internalConnection = InternalClientConnection.getRootConnection();
            ArrayList<Modification> modifications = new ArrayList<Modification>(1);
            Attribute attribute = Attributes.create("ds-cfg-symmetric-key", symmetricKey2);
            modifications.add(new Modification(ModificationType.ADD, attribute, false));
            ModifyOperation internalModify = internalConnection.processModify(entry.getDN(), modifications);
            if (internalModify.getResultCode() != ResultCode.SUCCESS) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FAILED_TO_ADD_KEY.get(entry.getDN().toString()));
            }
        }
        catch (DirectoryException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FAILED_OTHER.get(entry.getDN().toString(), ex.getMessage()), ex);
        }
    }

    void importMacKeyEntry(Entry entry) throws CryptoManagerException {
        if (!entry.hasObjectClass(ocMacKey)) {
            return;
        }
        try {
            String symmetricKey;
            String keyID = entry.getAttributeValue(attrKeyID, DirectoryStringSyntax.DECODER);
            int keyLengthBits = entry.getAttributeValue(attrKeyLength, IntegerSyntax.DECODER);
            String algorithm = entry.getAttributeValue(attrMacAlgorithm, DirectoryStringSyntax.DECODER);
            String compromisedTime = entry.getAttributeValue(attrCompromisedTime, DirectoryStringSyntax.DECODER);
            boolean isCompromised = compromisedTime != null;
            ArrayList<String> symmetricKeys = new ArrayList<String>();
            entry.getAttributeValues(attrSymmetricKey, DirectoryStringSyntax.DECODER, symmetricKeys);
            SecretKey secretKey = null;
            Iterator i$ = symmetricKeys.iterator();
            while (i$.hasNext() && (secretKey = this.decodeSymmetricKeyAttribute(symmetricKey = (String)i$.next())) == null) {
            }
            if (secretKey == null) {
                String symmetricKey2 = this.getSymmetricKey(symmetricKeys);
                if (symmetricKey2 == null) {
                    throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FAILED_TO_DECODE.get(entry.getDN().toString()));
                }
                secretKey = this.decodeSymmetricKeyAttribute(symmetricKey2);
                MacKeyEntry.importMacKeyEntry(this, keyID, algorithm, secretKey, keyLengthBits, isCompromised);
                InternalClientConnection internalConnection = InternalClientConnection.getRootConnection();
                ArrayList<Modification> modifications = new ArrayList<Modification>(1);
                Attribute attribute = Attributes.create("ds-cfg-symmetric-key", symmetricKey2);
                modifications.add(new Modification(ModificationType.ADD, attribute, false));
                ModifyOperation internalModify = internalConnection.processModify(entry.getDN(), modifications);
                if (internalModify.getResultCode() != ResultCode.SUCCESS) {
                    throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FAILED_TO_ADD_KEY.get(entry.getDN().toString()));
                }
            } else {
                MacKeyEntry.importMacKeyEntry(this, keyID, algorithm, secretKey, keyLengthBits, isCompromised);
            }
        }
        catch (DirectoryException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FAILED_OTHER.get(entry.getDN().toString(), ex.getMessage()), ex);
        }
    }

    private static Cipher getCipher(CipherKeyEntry keyEntry, int mode, byte[] initializationVector) throws CryptoManagerException {
        Cipher cipher;
        Validator.ensureTrue(1 == mode || 2 == mode);
        Validator.ensureTrue(1 != mode || null == initializationVector);
        Validator.ensureTrue(-1 != keyEntry.getIVLengthBits() || 1 == mode);
        Validator.ensureTrue(null == initializationVector || initializationVector.length * 8 == keyEntry.getIVLengthBits());
        try {
            String transformation = keyEntry.getType();
            String[] fields = transformation.split("/", 0);
            if (1 < fields.length && "NONE".equals(fields[1])) {
                assert ("RC4".equals(fields[0]) || "ARCFOUR".equals(fields[0]));
                assert ("NoPadding".equals(fields[2]));
                transformation = fields[0];
            }
            cipher = Cipher.getInstance(transformation);
        }
        catch (GeneralSecurityException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_GET_CIPHER_INVALID_CIPHER_TRANSFORMATION.get(keyEntry.getType(), StaticUtils.getExceptionMessage(ex)), ex);
        }
        try {
            if (0 < keyEntry.getIVLengthBits()) {
                byte[] iv;
                if (1 == mode && null == initializationVector) {
                    iv = new byte[keyEntry.getIVLengthBits() / 8];
                    pseudoRandom.nextBytes(iv);
                } else {
                    iv = initializationVector;
                }
                cipher.init(mode, (Key)keyEntry.getSecretKey(), new IvParameterSpec(iv));
            } else {
                cipher.init(mode, keyEntry.getSecretKey());
            }
        }
        catch (GeneralSecurityException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_GET_CIPHER_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        return cipher;
    }

    private static Mac getMacEngine(MacKeyEntry keyEntry) throws CryptoManagerException {
        Mac mac;
        try {
            mac = Mac.getInstance(keyEntry.getType());
        }
        catch (NoSuchAlgorithmException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_GET_MAC_ENGINE_INVALID_MAC_ALGORITHM.get(keyEntry.getType(), StaticUtils.getExceptionMessage(ex)), ex);
        }
        try {
            mac.init(keyEntry.getSecretKey());
        }
        catch (InvalidKeyException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_GET_MAC_ENGINE_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        return mac;
    }

    @Override
    public String getPreferredMessageDigestAlgorithm() {
        return this.preferredDigestAlgorithm;
    }

    @Override
    public MessageDigest getPreferredMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.preferredDigestAlgorithm);
    }

    @Override
    public MessageDigest getMessageDigest(String digestAlgorithm) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(digestAlgorithm);
    }

    @Override
    public byte[] digest(byte[] data) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(this.preferredDigestAlgorithm).digest(data);
    }

    @Override
    public byte[] digest(String digestAlgorithm, byte[] data) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(digestAlgorithm).digest(data);
    }

    @Override
    public byte[] digest(InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        MessageDigest digest = MessageDigest.getInstance(this.preferredDigestAlgorithm);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            digest.update(buffer, 0, bytesRead);
        }
        return digest.digest();
    }

    @Override
    public byte[] digest(String digestAlgorithm, InputStream inputStream) throws IOException, NoSuchAlgorithmException {
        int bytesRead;
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            digest.update(buffer, 0, bytesRead);
        }
        return digest.digest();
    }

    @Override
    public String getMacEngineKeyEntryID() throws CryptoManagerException {
        return this.getMacEngineKeyEntryID(this.preferredMACAlgorithm, this.preferredMACAlgorithmKeyLengthBits);
    }

    @Override
    public String getMacEngineKeyEntryID(String macAlgorithm, int keyLengthBits) throws CryptoManagerException {
        Validator.ensureNotNull(macAlgorithm);
        MacKeyEntry keyEntry = MacKeyEntry.getKeyEntry(this, macAlgorithm, keyLengthBits);
        if (null == keyEntry) {
            keyEntry = MacKeyEntry.generateKeyEntry(this, macAlgorithm, keyLengthBits);
        }
        return keyEntry.getKeyID().getStringValue();
    }

    @Override
    public Mac getMacEngine(String keyEntryID) throws CryptoManagerException {
        MacKeyEntry keyEntry = MacKeyEntry.getKeyEntry(this, new KeyEntryID(keyEntryID));
        return null == keyEntry ? null : CryptoManagerImpl.getMacEngine(keyEntry);
    }

    @Override
    public byte[] encrypt(byte[] data) throws GeneralSecurityException, CryptoManagerException {
        return this.encrypt(this.preferredCipherTransformation, this.preferredCipherTransformationKeyLengthBits, data);
    }

    @Override
    public byte[] encrypt(String cipherTransformation, int keyLengthBits, byte[] data) throws GeneralSecurityException, CryptoManagerException {
        Validator.ensureNotNull(cipherTransformation, data);
        CipherKeyEntry keyEntry = CipherKeyEntry.getKeyEntry(this, cipherTransformation, keyLengthBits);
        if (null == keyEntry) {
            keyEntry = CipherKeyEntry.generateKeyEntry(this, cipherTransformation, keyLengthBits);
        }
        Cipher cipher = CryptoManagerImpl.getCipher(keyEntry, 1, null);
        byte[] keyID = keyEntry.getKeyID().getByteValue();
        byte[] iv = cipher.getIV();
        int prologueLength = 1 + keyID.length + (null == iv ? 0 : iv.length);
        int dataLength = cipher.getOutputSize(data.length);
        byte[] cipherText = new byte[prologueLength + dataLength];
        int writeIndex = 0;
        cipherText[writeIndex++] = 1;
        System.arraycopy(keyID, 0, cipherText, writeIndex, keyID.length);
        writeIndex += keyID.length;
        if (null != iv) {
            System.arraycopy(iv, 0, cipherText, writeIndex, iv.length);
            writeIndex += iv.length;
        }
        System.arraycopy(cipher.doFinal(data), 0, cipherText, prologueLength, dataLength);
        return cipherText;
    }

    @Override
    public CipherOutputStream getCipherOutputStream(OutputStream outputStream) throws CryptoManagerException {
        return this.getCipherOutputStream(this.preferredCipherTransformation, this.preferredCipherTransformationKeyLengthBits, outputStream);
    }

    @Override
    public CipherOutputStream getCipherOutputStream(String cipherTransformation, int keyLengthBits, OutputStream outputStream) throws CryptoManagerException {
        Validator.ensureNotNull(cipherTransformation, outputStream);
        CipherKeyEntry keyEntry = CipherKeyEntry.getKeyEntry(this, cipherTransformation, keyLengthBits);
        if (null == keyEntry) {
            keyEntry = CipherKeyEntry.generateKeyEntry(this, cipherTransformation, keyLengthBits);
        }
        Cipher cipher = CryptoManagerImpl.getCipher(keyEntry, 1, null);
        byte[] keyID = keyEntry.getKeyID().getByteValue();
        try {
            outputStream.write(1);
            outputStream.write(keyID);
            if (null != cipher.getIV()) {
                outputStream.write(cipher.getIV());
            }
        }
        catch (IOException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_GET_CIPHER_STREAM_PROLOGUE_WRITE_ERROR.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        return new CipherOutputStream(outputStream, cipher);
    }

    @Override
    public byte[] decrypt(byte[] data) throws GeneralSecurityException, CryptoManagerException {
        KeyEntryID keyID;
        byte version;
        int readIndex = 0;
        try {
            version = data[readIndex++];
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_FAILED_TO_READ_PROLOGUE_VERSION.get(ex.getMessage()), ex);
        }
        switch (version) {
            case 1: {
                break;
            }
            default: {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_UNKNOWN_PROLOGUE_VERSION.get(version));
            }
        }
        try {
            byte[] keyIDBytes = new byte[KeyEntryID.getByteValueLength()];
            System.arraycopy(data, readIndex, keyIDBytes, 0, keyIDBytes.length);
            readIndex += keyIDBytes.length;
            keyID = new KeyEntryID(keyIDBytes);
        }
        catch (Exception ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_FAILED_TO_READ_KEY_IDENTIFIER.get(ex.getMessage()), ex);
        }
        CipherKeyEntry keyEntry = CipherKeyEntry.getKeyEntry(this, keyID);
        if (null == keyEntry) {
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_UNKNOWN_KEY_IDENTIFIER.get());
        }
        byte[] iv = null;
        if (0 < keyEntry.getIVLengthBits()) {
            iv = new byte[keyEntry.getIVLengthBits() / 8];
            try {
                System.arraycopy(data, readIndex, iv, 0, iv.length);
                readIndex += iv.length;
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_FAILED_TO_READ_IV.get(), ex);
            }
        }
        Cipher cipher = CryptoManagerImpl.getCipher(keyEntry, 2, iv);
        if (data.length - readIndex > 0) {
            return cipher.doFinal(data, readIndex, data.length - readIndex);
        }
        return cipher.doFinal();
    }

    @Override
    public CipherInputStream getCipherInputStream(InputStream inputStream) throws CryptoManagerException {
        CipherKeyEntry keyEntry;
        byte[] iv = null;
        try {
            byte[] rawVersion = new byte[1];
            if (rawVersion.length != inputStream.read(rawVersion)) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_FAILED_TO_READ_PROLOGUE_VERSION.get("stream underflow"));
            }
            byte version = rawVersion[0];
            switch (version) {
                case 1: {
                    break;
                }
                default: {
                    throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_UNKNOWN_PROLOGUE_VERSION.get(version));
                }
            }
            byte[] keyID = new byte[KeyEntryID.getByteValueLength()];
            if (keyID.length != inputStream.read(keyID)) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_FAILED_TO_READ_KEY_IDENTIFIER.get("stream underflow"));
            }
            keyEntry = CipherKeyEntry.getKeyEntry(this, new KeyEntryID(keyID));
            if (null == keyEntry) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_UNKNOWN_KEY_IDENTIFIER.get());
            }
            if (0 < keyEntry.getIVLengthBits() && (iv = new byte[keyEntry.getIVLengthBits() / 8]).length != inputStream.read(iv)) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_FAILED_TO_READ_IV.get());
            }
        }
        catch (IOException ex) {
            throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_DECRYPT_CIPHER_INPUT_STREAM_ERROR.get(StaticUtils.getExceptionMessage(ex)), ex);
        }
        return new CipherInputStream(inputStream, CryptoManagerImpl.getCipher(keyEntry, 2, iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff, int dstLen) {
        Deflater deflater = new Deflater();
        try {
            deflater.setInput(src, srcOff, srcLen);
            deflater.finish();
            int compressedLength = deflater.deflate(dst, dstOff, dstLen);
            if (deflater.finished()) {
                int n = compressedLength;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            deflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int uncompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff, int dstLen) throws DataFormatException {
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(src, srcOff, srcLen);
            int decompressedLength = inflater.inflate(dst, dstOff, dstLen);
            if (inflater.finished()) {
                int n = decompressedLength;
                return n;
            }
            int totalLength = decompressedLength;
            while (!inflater.finished()) {
                totalLength += inflater.inflate(dst, dstOff, dstLen);
            }
            int n = -totalLength;
            return n;
        }
        finally {
            inflater.end();
        }
    }

    @Override
    public SSLContext getSslContext(String sslCertNickname) throws ConfigException {
        SSLContext sslContext;
        try {
            TrustStoreBackend trustStoreBackend = this.getTrustStoreBackend();
            KeyManager[] keyManagers = trustStoreBackend.getKeyManagers();
            TrustManager[] trustManagers = trustStoreBackend.getTrustManagers();
            sslContext = SSLContext.getInstance("TLS");
            if (sslCertNickname == null) {
                sslContext.init(keyManagers, trustManagers, null);
            } else {
                KeyManager[] extendedKeyManagers = SelectableCertificateKeyManager.wrap(keyManagers, sslCertNickname);
                sslContext.init(extendedKeyManagers, trustManagers, null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_CRYPTOMGR_SSL_CONTEXT_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return sslContext;
    }

    @Override
    public String getSslCertNickname() {
        return this.sslCertNickname;
    }

    @Override
    public boolean isSslEncryption() {
        return this.sslEncryption;
    }

    @Override
    public SortedSet<String> getSslProtocols() {
        return this.sslProtocols;
    }

    @Override
    public SortedSet<String> getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    static {
        schemaInitDone = false;
        secureRandom = new SecureRandom();
        pseudoRandom = new Random(secureRandom.nextLong());
    }

    private static class MacKeyEntry
    extends SecretKeyEntry {
        private final String fType;

        public static MacKeyEntry generateKeyEntry(CryptoManagerImpl cryptoManager, String algorithm, int keyLengthBits) throws CryptoManagerException {
            Validator.ensureNotNull(algorithm);
            Map cache = null == cryptoManager ? null : cryptoManager.macKeyEntryCache;
            MacKeyEntry keyEntry = new MacKeyEntry(algorithm, keyLengthBits);
            CryptoManagerImpl.getMacEngine(keyEntry);
            if (null != cache) {
                MacKeyEntry.publishKeyEntry(cryptoManager, keyEntry);
                cache.put(keyEntry.getKeyID(), keyEntry);
            }
            return keyEntry;
        }

        private static void publishKeyEntry(CryptoManagerImpl cryptoManager, MacKeyEntry keyEntry) throws CryptoManagerException {
            AttributeValue distinguishedValue = AttributeValues.create(attrKeyID, keyEntry.getKeyID().getStringValue());
            DN entryDN = secretKeysDN.concat(RDN.create(attrKeyID, distinguishedValue));
            LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(2);
            ocMap.put(DirectoryServer.getTopObjectClass(), "top");
            ocMap.put(ocMacKey, "ds-cfg-mac-key");
            LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
            LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(Attributes.create(attrKeyID, distinguishedValue));
            userAttrs.put(attrKeyID, attrList);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(attrMacAlgorithm, AttributeValues.create(attrMacAlgorithm, keyEntry.getType())));
            userAttrs.put(attrMacAlgorithm, attrList);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(attrKeyLength, AttributeValues.create(attrKeyLength, String.valueOf(keyEntry.getKeyLengthBits()))));
            userAttrs.put(attrKeyLength, attrList);
            Map trustedCerts = cryptoManager.getTrustedCertificates();
            byte[] instanceKeyCertificate = CryptoManagerImpl.getInstanceKeyCertificateFromLocalTruststore();
            trustedCerts.put(CryptoManagerImpl.getInstanceKeyID(instanceKeyCertificate), instanceKeyCertificate);
            AttributeBuilder builder = new AttributeBuilder(attrSymmetricKey);
            for (Map.Entry mapEntry : trustedCerts.entrySet()) {
                String symmetricKey = cryptoManager.encodeSymmetricKeyAttribute((String)mapEntry.getKey(), (byte[])mapEntry.getValue(), keyEntry.getSecretKey());
                builder.add(AttributeValues.create(attrSymmetricKey, symmetricKey));
            }
            attrList = new ArrayList(1);
            attrList.add(builder.toAttribute());
            userAttrs.put(attrSymmetricKey, attrList);
            Entry entry = new Entry(entryDN, ocMap, userAttrs, opAttrs);
            InternalClientConnection connection = InternalClientConnection.getRootConnection();
            AddOperation addOperation = connection.processAdd(entry);
            if (addOperation.getResultCode() != ResultCode.SUCCESS) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_SYMMETRIC_KEY_ENTRY_ADD_FAILED.get(entry.getDN().toString(), addOperation.getErrorMessage()));
            }
        }

        public static MacKeyEntry importMacKeyEntry(CryptoManagerImpl cryptoManager, String keyIDString, String algorithm, SecretKey secretKey, int secretKeyLengthBits, boolean isCompromised) throws CryptoManagerException {
            Validator.ensureNotNull(keyIDString, secretKey);
            KeyEntryID keyID = new KeyEntryID(keyIDString);
            MacKeyEntry keyEntry = MacKeyEntry.getKeyEntry(cryptoManager, keyID);
            if (null != keyEntry) {
                if (!keyEntry.getType().equals(algorithm) || keyEntry.getKeyLengthBits() != secretKeyLengthBits) {
                    throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FIELD_MISMATCH.get(keyIDString));
                }
                if (isCompromised && !keyEntry.isCompromised()) {
                    keyEntry.setIsCompromised();
                }
                return keyEntry;
            }
            keyEntry = new MacKeyEntry(keyID, algorithm, secretKey, secretKeyLengthBits, isCompromised);
            CryptoManagerImpl.getMacEngine(keyEntry);
            cryptoManager.macKeyEntryCache.put(keyEntry.getKeyID(), keyEntry);
            return keyEntry;
        }

        public static MacKeyEntry getKeyEntry(CryptoManagerImpl cryptoManager, String algorithm, int keyLengthBits) {
            Validator.ensureNotNull(cryptoManager, algorithm);
            Validator.ensureTrue(0 < keyLengthBits);
            MacKeyEntry keyEntry = null;
            for (Map.Entry i : cryptoManager.macKeyEntryCache.entrySet()) {
                MacKeyEntry entry = (MacKeyEntry)i.getValue();
                if (entry.isCompromised() || !entry.getType().equals(algorithm) || entry.getKeyLengthBits() != keyLengthBits) continue;
                keyEntry = entry;
                break;
            }
            return keyEntry;
        }

        public static MacKeyEntry getKeyEntry(CryptoManagerImpl cryptoManager, KeyEntryID keyID) {
            return (MacKeyEntry)cryptoManager.macKeyEntryCache.get(keyID);
        }

        private MacKeyEntry(String algorithm, int keyLengthBits) throws CryptoManagerException {
            super(algorithm, keyLengthBits);
            this.fType = algorithm;
        }

        private MacKeyEntry(KeyEntryID keyID, String algorithm, SecretKey secretKey, int secretKeyLengthBits, boolean isCompromised) {
            super(keyID, secretKey, secretKeyLengthBits, isCompromised);
            this.fType = algorithm;
        }

        public String getType() {
            return this.fType;
        }
    }

    private static class CipherKeyEntry
    extends SecretKeyEntry {
        private final String fType;
        private int fIVLengthBits = -1;

        public static CipherKeyEntry generateKeyEntry(CryptoManagerImpl cryptoManager, String transformation, int keyLengthBits) throws CryptoManagerException {
            Map cache = null == cryptoManager ? null : cryptoManager.cipherKeyEntryCache;
            CipherKeyEntry keyEntry = new CipherKeyEntry(transformation, keyLengthBits);
            Cipher cipher = CryptoManagerImpl.getCipher(keyEntry, 1, null);
            byte[] iv = cipher.getIV();
            keyEntry.setIVLengthBits(null == iv ? 0 : iv.length * 8);
            if (null != cache) {
                CipherKeyEntry.publishKeyEntry(cryptoManager, keyEntry);
                cache.put(keyEntry.getKeyID(), keyEntry);
            }
            return keyEntry;
        }

        private static void publishKeyEntry(CryptoManagerImpl cryptoManager, CipherKeyEntry keyEntry) throws CryptoManagerException {
            AttributeValue distinguishedValue = AttributeValues.create(attrKeyID, keyEntry.getKeyID().getStringValue());
            DN entryDN = secretKeysDN.concat(RDN.create(attrKeyID, distinguishedValue));
            LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(2);
            ocMap.put(DirectoryServer.getTopObjectClass(), "top");
            ocMap.put(ocCipherKey, "ds-cfg-cipher-key");
            LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
            LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(Attributes.create(attrKeyID, distinguishedValue));
            userAttrs.put(attrKeyID, attrList);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(attrTransformation, AttributeValues.create(attrTransformation, keyEntry.getType())));
            userAttrs.put(attrTransformation, attrList);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(attrInitVectorLength, AttributeValues.create(attrInitVectorLength, String.valueOf(keyEntry.getIVLengthBits()))));
            userAttrs.put(attrInitVectorLength, attrList);
            attrList = new ArrayList(1);
            attrList.add(Attributes.create(attrKeyLength, AttributeValues.create(attrKeyLength, String.valueOf(keyEntry.getKeyLengthBits()))));
            userAttrs.put(attrKeyLength, attrList);
            Map trustedCerts = cryptoManager.getTrustedCertificates();
            byte[] instanceKeyCertificate = CryptoManagerImpl.getInstanceKeyCertificateFromLocalTruststore();
            trustedCerts.put(CryptoManagerImpl.getInstanceKeyID(instanceKeyCertificate), instanceKeyCertificate);
            AttributeBuilder builder = new AttributeBuilder(attrSymmetricKey);
            for (Map.Entry mapEntry : trustedCerts.entrySet()) {
                String symmetricKey = cryptoManager.encodeSymmetricKeyAttribute((String)mapEntry.getKey(), (byte[])mapEntry.getValue(), keyEntry.getSecretKey());
                builder.add(AttributeValues.create(attrSymmetricKey, symmetricKey));
            }
            attrList = new ArrayList(1);
            attrList.add(builder.toAttribute());
            userAttrs.put(attrSymmetricKey, attrList);
            Entry entry = new Entry(entryDN, ocMap, userAttrs, opAttrs);
            InternalClientConnection connection = InternalClientConnection.getRootConnection();
            AddOperation addOperation = connection.processAdd(entry);
            if (addOperation.getResultCode() != ResultCode.SUCCESS) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_SYMMETRIC_KEY_ENTRY_ADD_FAILED.get(entry.getDN().toString(), addOperation.getErrorMessage()));
            }
        }

        public static CipherKeyEntry importCipherKeyEntry(CryptoManagerImpl cryptoManager, String keyIDString, String transformation, SecretKey secretKey, int secretKeyLengthBits, int ivLengthBits, boolean isCompromised) throws CryptoManagerException {
            Validator.ensureNotNull(keyIDString, transformation, secretKey);
            Validator.ensureTrue(0 <= ivLengthBits);
            KeyEntryID keyID = new KeyEntryID(keyIDString);
            CipherKeyEntry keyEntry = CipherKeyEntry.getKeyEntry(cryptoManager, keyID);
            if (null != keyEntry) {
                if (!keyEntry.getType().equals(transformation) || keyEntry.getKeyLengthBits() != secretKeyLengthBits || keyEntry.getIVLengthBits() != ivLengthBits) {
                    throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_IMPORT_KEY_ENTRY_FIELD_MISMATCH.get(keyIDString));
                }
                if (isCompromised && !keyEntry.isCompromised()) {
                    keyEntry.setIsCompromised();
                }
                return keyEntry;
            }
            keyEntry = new CipherKeyEntry(keyID, transformation, secretKey, secretKeyLengthBits, ivLengthBits, isCompromised);
            byte[] iv = null;
            if (0 < ivLengthBits) {
                iv = new byte[ivLengthBits / 8];
                pseudoRandom.nextBytes(iv);
            }
            CryptoManagerImpl.getCipher(keyEntry, 2, iv);
            cryptoManager.cipherKeyEntryCache.put(keyEntry.getKeyID(), keyEntry);
            return keyEntry;
        }

        public static CipherKeyEntry getKeyEntry(CryptoManagerImpl cryptoManager, String transformation, int keyLengthBits) {
            Validator.ensureNotNull(cryptoManager, transformation);
            Validator.ensureTrue(0 < keyLengthBits);
            CipherKeyEntry keyEntry = null;
            for (Map.Entry i : cryptoManager.cipherKeyEntryCache.entrySet()) {
                CipherKeyEntry entry = (CipherKeyEntry)i.getValue();
                if (entry.isCompromised() || !entry.getType().equals(transformation) || entry.getKeyLengthBits() != keyLengthBits) continue;
                keyEntry = entry;
                break;
            }
            return keyEntry;
        }

        public static CipherKeyEntry getKeyEntry(CryptoManagerImpl cryptoManager, KeyEntryID keyID) {
            return (CipherKeyEntry)cryptoManager.cipherKeyEntryCache.get(keyID);
        }

        private static String keyAlgorithmFromTransformation(String transformation) {
            int separatorIndex = transformation.indexOf(47);
            return 0 < separatorIndex ? transformation.substring(0, separatorIndex) : transformation;
        }

        private CipherKeyEntry(String transformation, int keyLengthBits) throws CryptoManagerException {
            super(CipherKeyEntry.keyAlgorithmFromTransformation(transformation), keyLengthBits);
            this.fType = transformation;
            this.fIVLengthBits = -1;
        }

        private CipherKeyEntry(KeyEntryID keyID, String transformation, SecretKey secretKey, int secretKeyLengthBits, int ivLengthBits, boolean isCompromised) throws CryptoManagerException {
            super(keyID, secretKey, secretKeyLengthBits, isCompromised);
            this.fType = transformation;
            this.fIVLengthBits = ivLengthBits;
        }

        public String getType() {
            return this.fType;
        }

        private void setIVLengthBits(int ivLengthBits) {
            Validator.ensureTrue(-1 == this.fIVLengthBits && 0 <= ivLengthBits);
            this.fIVLengthBits = ivLengthBits;
        }

        public int getIVLengthBits() {
            return this.fIVLengthBits;
        }
    }

    private static class SecretKeyEntry {
        private final KeyEntryID fKeyID;
        private final SecretKey fSecretKey;
        private final int fKeyLengthBits;
        private boolean fIsCompromised = false;

        public SecretKeyEntry(String algorithm, int keyLengthBits) throws CryptoManagerException {
            int maxAllowedKeyLengthBits;
            KeyGenerator keyGen;
            try {
                keyGen = KeyGenerator.getInstance(algorithm);
                maxAllowedKeyLengthBits = Cipher.getMaxAllowedKeyLength(algorithm);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_INVALID_SYMMETRIC_KEY_ALGORITHM.get(algorithm, StaticUtils.getExceptionMessage(ex)), ex);
            }
            if (maxAllowedKeyLengthBits < keyLengthBits) {
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_INVALID_SYMMETRIC_KEY_LENGTH.get(keyLengthBits, maxAllowedKeyLengthBits));
            }
            keyGen.init(keyLengthBits, secureRandom);
            byte[] key = keyGen.generateKey().getEncoded();
            this.fKeyID = new KeyEntryID();
            this.fSecretKey = new SecretKeySpec(key, algorithm);
            this.fKeyLengthBits = keyLengthBits;
            this.fIsCompromised = false;
        }

        public SecretKeyEntry(KeyEntryID keyID, SecretKey secretKey, int secretKeyLengthBits, boolean isCompromised) {
            this.fKeyID = new KeyEntryID(keyID);
            this.fSecretKey = secretKey;
            this.fKeyLengthBits = secretKeyLengthBits;
            this.fIsCompromised = isCompromised;
        }

        public KeyEntryID getKeyID() {
            return this.fKeyID;
        }

        public SecretKey getSecretKey() {
            return this.fSecretKey;
        }

        public void setIsCompromised() {
            this.fIsCompromised = true;
        }

        public int getKeyLengthBits() {
            return this.fKeyLengthBits;
        }

        public boolean isCompromised() {
            return this.fIsCompromised;
        }
    }

    private static class KeyEntryID {
        private final UUID fValue;

        public KeyEntryID() {
            this.fValue = UUID.randomUUID();
        }

        public KeyEntryID(byte[] keyEntryID) {
            Validator.ensureTrue(KeyEntryID.getByteValueLength() == keyEntryID.length);
            long hiBytes = 0L;
            long loBytes = 0L;
            for (int i = 0; i < 8; ++i) {
                hiBytes = hiBytes << 8 | (long)(keyEntryID[i] & 0xFF);
                loBytes = loBytes << 8 | (long)(keyEntryID[8 + i] & 0xFF);
            }
            this.fValue = new UUID(hiBytes, loBytes);
        }

        public KeyEntryID(String keyEntryID) throws CryptoManagerException {
            try {
                this.fValue = UUID.fromString(keyEntryID);
            }
            catch (IllegalArgumentException ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                throw new CryptoManagerException(CoreMessages.ERR_CRYPTOMGR_INVALID_KEY_IDENTIFIER_SYNTAX.get(keyEntryID, StaticUtils.getExceptionMessage(ex)), ex);
            }
        }

        public KeyEntryID(KeyEntryID keyEntryID) {
            this.fValue = new UUID(keyEntryID.fValue.getMostSignificantBits(), keyEntryID.fValue.getLeastSignificantBits());
        }

        public byte[] getByteValue() {
            byte[] uuidBytes = new byte[16];
            long hiBytes = this.fValue.getMostSignificantBits();
            long loBytes = this.fValue.getLeastSignificantBits();
            for (int i = 7; i >= 0; --i) {
                uuidBytes[i] = (byte)hiBytes;
                hiBytes >>>= 8;
                uuidBytes[8 + i] = (byte)loBytes;
                loBytes >>>= 8;
            }
            return uuidBytes;
        }

        public String getStringValue() {
            return this.fValue.toString();
        }

        public static int getByteValueLength() {
            return 16;
        }

        public boolean equals(Object obj) {
            return obj instanceof KeyEntryID && this.fValue.equals(((KeyEntryID)obj).fValue);
        }

        public int hashCode() {
            return this.fValue.hashCode();
        }
    }
}

