/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.CryptPasswordStorageSchemeCfg;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.Sha2Crypt;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.BSDMD5Crypt;
import org.opends.server.util.Crypt;
import org.opends.server.util.StaticUtils;

public class CryptPasswordStorageScheme
extends PasswordStorageScheme<CryptPasswordStorageSchemeCfg>
implements ConfigurationChangeListener<CryptPasswordStorageSchemeCfg> {
    private static final String CLASS_NAME = "org.opends.server.extensions.CryptPasswordStorageScheme";
    private CryptPasswordStorageSchemeCfg currentConfig;
    private static final byte[] SALT_CHARS = "./0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes();
    private final Random randomSaltIndex = new Random();
    private final Object saltLock = new Object();
    private final Crypt crypt = new Crypt();
    private final BSDMD5Crypt bsdmd5crypt = new BSDMD5Crypt();

    @Override
    public void initializePasswordStorageScheme(CryptPasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
        configuration.addCryptChangeListener(this);
        this.currentConfig = configuration;
    }

    @Override
    public String getStorageSchemeName() {
        return "CRYPT";
    }

    private ByteString unixCryptEncodePassword(ByteSequence plaintext) throws DirectoryException {
        byte[] digestBytes;
        try {
            byte[] plaintextBytes = plaintext.toByteArray();
            digestBytes = this.crypt.crypt(plaintextBytes, this.randomSalt());
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        return ByteString.wrap(digestBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] randomSalt() {
        Object object = this.saltLock;
        synchronized (object) {
            byte[] salt = new byte[2];
            int sb1 = this.randomSaltIndex.nextInt(SALT_CHARS.length);
            int sb2 = this.randomSaltIndex.nextInt(SALT_CHARS.length);
            salt[0] = SALT_CHARS[sb1];
            salt[1] = SALT_CHARS[sb2];
            return salt;
        }
    }

    private ByteString md5CryptEncodePassword(ByteSequence plaintext) throws DirectoryException {
        String output;
        try {
            output = BSDMD5Crypt.crypt(((Object)plaintext).toString());
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        return ByteString.valueOf(output);
    }

    private ByteString sha256CryptEncodePassword(ByteSequence plaintext) throws DirectoryException {
        String output;
        try {
            output = Sha2Crypt.sha256Crypt(plaintext.toByteArray());
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        return ByteString.valueOf(output);
    }

    private ByteString sha512CryptEncodePassword(ByteSequence plaintext) throws DirectoryException {
        String output;
        try {
            output = Sha2Crypt.sha512Crypt(plaintext.toByteArray());
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWSCHEME_CANNOT_ENCODE_PASSWORD.get(CLASS_NAME, StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        return ByteString.valueOf(output);
    }

    @Override
    public ByteString encodePassword(ByteSequence plaintext) throws DirectoryException {
        ByteString bytes = null;
        switch (this.currentConfig.getCryptPasswordStorageEncryptionAlgorithm()) {
            case UNIX: {
                bytes = this.unixCryptEncodePassword(plaintext);
                break;
            }
            case MD5: {
                bytes = this.md5CryptEncodePassword(plaintext);
                break;
            }
            case SHA256: {
                bytes = this.sha256CryptEncodePassword(plaintext);
                break;
            }
            case SHA512: {
                bytes = this.sha512CryptEncodePassword(plaintext);
            }
        }
        return bytes;
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteSequence plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder("CRYPT".length() + 12);
        buffer.append('{');
        buffer.append("CRYPT");
        buffer.append('}');
        buffer.append(this.encodePassword(plaintext));
        return ByteString.valueOf(buffer.toString());
    }

    private boolean unixCryptPasswordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        ByteString userPWDigestBytes;
        byte[] plaintextPasswordBytes = plaintextPassword.toByteArray();
        try {
            byte[] salt = storedPassword.copyTo(new byte[2]);
            userPWDigestBytes = ByteString.wrap(this.crypt.crypt(plaintextPasswordBytes, salt));
        }
        catch (Exception e) {
            return false;
        }
        return userPWDigestBytes.equals(storedPassword);
    }

    private boolean md5CryptPasswordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        String storedString = ((Object)storedPassword).toString();
        try {
            String userString = BSDMD5Crypt.crypt(((Object)plaintextPassword).toString(), storedString);
            return userString.equals(storedString);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean sha256CryptPasswordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        String storedString = ((Object)storedPassword).toString();
        try {
            String userString = Sha2Crypt.sha256Crypt(plaintextPassword.toByteArray(), storedString);
            return userString.equals(storedString);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean sha512CryptPasswordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        String storedString = ((Object)storedPassword).toString();
        try {
            String userString = Sha2Crypt.sha512Crypt(plaintextPassword.toByteArray(), storedString);
            return userString.equals(storedString);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean passwordMatches(ByteSequence plaintextPassword, ByteSequence storedPassword) {
        String storedString = ((Object)storedPassword).toString();
        if (storedString.startsWith(BSDMD5Crypt.getMagicString())) {
            return this.md5CryptPasswordMatches(plaintextPassword, storedPassword);
        }
        if (storedString.startsWith(Sha2Crypt.getMagicSHA256Prefix())) {
            return this.sha256CryptPasswordMatches(plaintextPassword, storedPassword);
        }
        if (storedString.startsWith(Sha2Crypt.getMagicSHA512Prefix())) {
            return this.sha512CryptPasswordMatches(plaintextPassword, storedPassword);
        }
        return this.unixCryptPasswordMatches(plaintextPassword, storedPassword);
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteSequence plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteSequence plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public ByteString getPlaintextValue(ByteSequence storedPassword) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_NOT_REVERSIBLE.get("CRYPT");
        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return false;
    }

    @Override
    public boolean isConfigurationAcceptable(PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        CryptPasswordStorageSchemeCfg config = (CryptPasswordStorageSchemeCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(CryptPasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(CryptPasswordStorageSchemeCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.currentConfig = configuration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

