/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.FIFOEntryCacheCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.EntryCacheCommon;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.CacheEntry;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;

public class FIFOEntryCache
extends EntryCache<FIFOEntryCacheCfg>
implements ConfigurationChangeListener<FIFOEntryCacheCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final Runtime runtime = Runtime.getRuntime();
    private HashMap<Backend, HashMap<Long, CacheEntry>> idMap;
    private LinkedHashMap<DN, CacheEntry> dnMap;
    private ReentrantReadWriteLock cacheLock;
    private Lock cacheWriteLock;
    private Lock cacheReadLock;
    private long maxAllowedMemory;
    private long maxEntries;
    private FIFOEntryCacheCfg registeredConfiguration;
    private long lockTimeout = 9000L;

    @Override
    public void initializeEntryCache(FIFOEntryCacheCfg configuration) throws ConfigException, InitializationException {
        this.registeredConfiguration = configuration;
        configuration.addFIFOChangeListener(this);
        this.idMap = new HashMap();
        this.dnMap = new LinkedHashMap();
        this.cacheLock = new ReentrantReadWriteLock(true);
        this.cacheWriteLock = this.cacheLock.writeLock();
        this.cacheReadLock = this.cacheLock.readLock();
        boolean applyChanges = true;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_INIT, null, errorMessages);
        if (!this.processEntryCacheConfig(configuration, applyChanges, errorHandler)) {
            MessageBuilder buffer = new MessageBuilder();
            if (!errorMessages.isEmpty()) {
                Iterator<Message> iterator = errorMessages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append(".  ");
                    buffer.append(iterator.next());
                }
            }
            Message message = ExtensionMessages.ERR_FIFOCACHE_CANNOT_INITIALIZE.get(buffer.toString());
            throw new ConfigException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeEntryCache() {
        this.cacheWriteLock.lock();
        try {
            this.registeredConfiguration.removeFIFOChangeListener(this);
            try {
                this.idMap.clear();
                this.dnMap.clear();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsEntry(DN entryDN) {
        if (entryDN == null) {
            return false;
        }
        this.cacheReadLock.lock();
        try {
            boolean bl = this.dnMap.containsKey(entryDN);
            return bl;
        }
        finally {
            this.cacheReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(DN entryDN) {
        this.cacheReadLock.lock();
        try {
            CacheEntry e = this.dnMap.get(entryDN);
            if (e == null) {
                this.cacheMisses.getAndIncrement();
                Entry entry = null;
                return entry;
            }
            this.cacheHits.getAndIncrement();
            Entry entry = e.getEntry();
            return entry;
        }
        finally {
            this.cacheReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntryID(DN entryDN) {
        this.cacheReadLock.lock();
        try {
            CacheEntry e = this.dnMap.get(entryDN);
            if (e == null) {
                long l = -1L;
                return l;
            }
            long l = e.getEntryID();
            return l;
        }
        finally {
            this.cacheReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DN getEntryDN(Backend backend, long entryID) {
        this.cacheReadLock.lock();
        try {
            CacheEntry e;
            HashMap<Long, CacheEntry> backendMap = this.idMap.get(backend);
            if (backendMap != null && (e = backendMap.get(entryID)) != null) {
                DN dN = e.getDN();
                return dN;
            }
            DN dN = null;
            return dN;
        }
        finally {
            this.cacheReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEntry(Entry entry, Backend backend, long entryID) {
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        try {
            if (!this.cacheWriteLock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return;
        }
        try {
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            if (usedMemory > this.maxAllowedMemory) {
                CacheEntry cachedEntry = (CacheEntry)this.dnMap.remove(entry.getDN());
                if (cachedEntry == null) {
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    if (iterator.hasNext()) {
                        CacheEntry ce = iterator.next();
                        iterator.remove();
                        HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                        if (m != null) {
                            m.remove(ce.getEntryID());
                        }
                    }
                } else {
                    Map map = this.idMap.get(backend);
                    if (map != null) {
                        map.remove(cacheEntry.getEntryID());
                        if (map.isEmpty()) {
                            this.idMap.remove(backend);
                        }
                    }
                }
            } else {
                this.dnMap.put(entry.getDN(), cacheEntry);
                HashMap<Long, CacheEntry> map = this.idMap.get(backend);
                if (map == null) {
                    map = new HashMap();
                    map.put(entryID, cacheEntry);
                    this.idMap.put(backend, map);
                } else {
                    map.put(entryID, cacheEntry);
                }
                int entryCount = this.dnMap.size();
                if (this.maxEntries > 0L && (long)entryCount > this.maxEntries) {
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    while (iterator.hasNext() && (long)entryCount > this.maxEntries) {
                        CacheEntry ce = iterator.next();
                        iterator.remove();
                        HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                        if (m != null) {
                            m.remove(ce.getEntryID());
                        }
                        --entryCount;
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long entryID) {
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        try {
            if (!this.cacheWriteLock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
        try {
            block18: {
                block17: {
                    if (this.dnMap.containsKey(entry.getDN())) {
                        boolean e = false;
                        return e;
                    }
                    long usedMemory = runtime.totalMemory() - runtime.freeMemory();
                    if (usedMemory <= this.maxAllowedMemory) break block17;
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    if (!iterator.hasNext()) break block18;
                    CacheEntry ce = iterator.next();
                    iterator.remove();
                    HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                    if (m == null) break block18;
                    m.remove(ce.getEntryID());
                    break block18;
                }
                this.dnMap.put(entry.getDN(), cacheEntry);
                HashMap<Long, CacheEntry> map = this.idMap.get(backend);
                if (map == null) {
                    map = new HashMap();
                    map.put(entryID, cacheEntry);
                    this.idMap.put(backend, map);
                } else {
                    map.put(entryID, cacheEntry);
                }
                int entryCount = this.dnMap.size();
                if (this.maxEntries > 0L && (long)entryCount > this.maxEntries) {
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    while (iterator.hasNext() && (long)entryCount > this.maxEntries) {
                        CacheEntry ce = iterator.next();
                        iterator.remove();
                        HashMap<Long, CacheEntry> m = this.idMap.get(ce.getBackend());
                        if (m != null) {
                            m.remove(ce.getEntryID());
                        }
                        --entryCount;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(DN entryDN) {
        this.cacheWriteLock.lock();
        try {
            CacheEntry entry = (CacheEntry)this.dnMap.remove(entryDN);
            if (entry == null) {
                return;
            }
            Backend backend = entry.getBackend();
            Map map = this.idMap.get(backend);
            if (map == null) {
                return;
            }
            map.remove(entry.getEntryID());
            if (map.isEmpty()) {
                this.idMap.remove(backend);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.cacheWriteLock.lock();
        try {
            this.dnMap.clear();
            this.idMap.clear();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackend(Backend backend) {
        this.cacheWriteLock.lock();
        try {
            HashMap<Long, CacheEntry> map = this.idMap.remove(backend);
            if (map == null) {
                return;
            }
            int entriesDeleted = 0;
            for (CacheEntry e : map.values()) {
                this.dnMap.remove(e.getEntry().getDN());
                if (++entriesDeleted % 1000 != 0) continue;
                this.cacheWriteLock.unlock();
                Thread.yield();
                this.cacheWriteLock.lock();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSubtree(DN baseDN) {
        Backend backend = DirectoryServer.getBackend(baseDN);
        if (backend == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            this.clearSubtree(baseDN, backend);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    private void clearSubtree(DN baseDN, Backend backend) {
        HashMap<Long, CacheEntry> map = this.idMap.get(backend);
        if (map == null) {
            return;
        }
        int entriesExamined = 0;
        Iterator<CacheEntry> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry e = iterator.next();
            DN entryDN = e.getEntry().getDN();
            if (entryDN.isDescendantOf(baseDN)) {
                iterator.remove();
                this.dnMap.remove(entryDN);
            }
            if (++entriesExamined % 1000 != 0) continue;
            this.cacheWriteLock.unlock();
            Thread.yield();
            this.cacheWriteLock.lock();
        }
        for (Backend subBackend : backend.getSubordinateBackends()) {
            boolean isAppropriate = false;
            for (DN subBase : subBackend.getBaseDNs()) {
                if (!subBase.isDescendantOf(baseDN)) continue;
                isAppropriate = true;
                break;
            }
            if (!isAppropriate) continue;
            this.clearSubtree(baseDN, subBackend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLowMemory() {
        this.cacheWriteLock.lock();
        try {
            int numEntries = this.dnMap.size();
            if (numEntries < 1000) {
                this.dnMap.clear();
                this.idMap.clear();
            } else {
                Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                for (int numToDrop = numEntries / 10; iterator.hasNext() && numToDrop > 0; --numToDrop) {
                    CacheEntry entry = iterator.next();
                    iterator.remove();
                    HashMap<Long, CacheEntry> m = this.idMap.get(entry.getBackend());
                    if (m == null) continue;
                    m.remove(entry.getEntryID());
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    @Override
    public boolean isConfigurationAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        FIFOEntryCacheCfg config = (FIFOEntryCacheCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FIFOEntryCacheCfg configuration, List<Message> unacceptableReasons) {
        boolean applyChanges = false;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_ACCEPTABLE, unacceptableReasons, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FIFOEntryCacheCfg configuration) {
        boolean applyChanges = true;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_APPLY, null, errorMessages);
        if (configuration.isEnabled()) {
            this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        }
        boolean adminActionRequired = errorHandler.getIsAdminActionRequired();
        ConfigChangeResult changeResult = new ConfigChangeResult(errorHandler.getResultCode(), adminActionRequired, errorHandler.getErrorMessages());
        return changeResult;
    }

    public boolean processEntryCacheConfig(FIFOEntryCacheCfg configuration, boolean applyChanges, EntryCacheCommon.ConfigErrorHandler errorHandler) {
        HashSet<SearchFilter> newIncludeFilters = null;
        HashSet<SearchFilter> newExcludeFilters = null;
        DN newConfigEntryDN = configuration.dn();
        long newLockTimeout = configuration.getLockTimeout();
        long newMaxEntries = configuration.getMaxEntries();
        int newMaxMemoryPercent = configuration.getMaxMemoryPercent();
        long maxJvmHeapSize = Runtime.getRuntime().maxMemory();
        long newMaxAllowedMemory = maxJvmHeapSize / 100L * (long)newMaxMemoryPercent;
        switch (errorHandler.getConfigPhase()) {
            case PHASE_INIT: 
            case PHASE_ACCEPTABLE: 
            case PHASE_APPLY: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_INCLUDE_FILTER, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_EXCLUDE_FILTER, errorHandler, newConfigEntryDN);
            }
        }
        if (applyChanges && errorHandler.getIsAcceptable()) {
            this.maxEntries = newMaxEntries;
            this.maxAllowedMemory = newMaxAllowedMemory;
            this.lockTimeout = newLockTimeout;
            this.setIncludeFilters(newIncludeFilters);
            this.setExcludeFilters(newExcludeFilters);
            this.registeredConfiguration = configuration;
        }
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs;
        block2: {
            attrs = new ArrayList<Attribute>();
            try {
                attrs = EntryCacheCommon.getGenericMonitorData(new Long(this.cacheHits.longValue()), DirectoryServer.getEntryCache().getCacheMisses(), null, new Long(this.maxAllowedMemory), new Long(this.dnMap.size()), this.maxEntries != Integer.MAX_VALUE && this.maxEntries != Long.MAX_VALUE ? new Long(this.maxEntries) : new Long(0L));
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return attrs;
    }

    @Override
    public Long getCacheCount() {
        return new Long(this.dnMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toVerboseString() {
        HashMap<Backend, HashMap<Long, CacheEntry>> idMapCopy;
        LinkedHashMap<DN, CacheEntry> dnMapCopy;
        StringBuilder sb = new StringBuilder();
        this.cacheWriteLock.lock();
        try {
            dnMapCopy = new LinkedHashMap<DN, CacheEntry>(this.dnMap);
            idMapCopy = new HashMap<Backend, HashMap<Long, CacheEntry>>(this.idMap);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
        for (DN dn : dnMapCopy.keySet()) {
            sb.append(dn.toString());
            sb.append(":");
            sb.append(dnMapCopy.get(dn) != null ? Long.toString(((CacheEntry)dnMapCopy.get(dn)).getEntryID()) : null);
            sb.append(":");
            sb.append(dnMapCopy.get(dn) != null ? ((CacheEntry)dnMapCopy.get(dn)).getBackend().getBackendID() : null);
            sb.append(ServerConstants.EOL);
        }
        for (Backend backend : idMapCopy.keySet()) {
            for (Long id : ((HashMap)idMapCopy.get(backend)).keySet()) {
                if (((HashMap)idMapCopy.get(backend)).get(id) != null && dnMapCopy.containsKey(((CacheEntry)((HashMap)idMapCopy.get(backend)).get(id)).getDN())) continue;
                sb.append(((HashMap)idMapCopy.get(backend)).get(id) != null ? ((CacheEntry)((HashMap)idMapCopy.get(backend)).get(id)).getDN().toString() : null);
                sb.append(":");
                sb.append(id.toString());
                sb.append(":");
                sb.append(backend.getBackendID());
                sb.append(ServerConstants.EOL);
            }
        }
        String verboseString = sb.toString();
        return verboseString.length() > 0 ? verboseString : null;
    }
}

