/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.LDAPPassThroughAuthenticationPolicyCfgDefn;
import org.opends.server.admin.std.server.LDAPPassThroughAuthenticationPolicyCfg;
import org.opends.server.api.AuthenticationPolicy;
import org.opends.server.api.AuthenticationPolicyFactory;
import org.opends.server.api.AuthenticationPolicyState;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawFilter;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public final class LDAPPassThroughAuthenticationPolicyFactory
implements AuthenticationPolicyFactory<LDAPPassThroughAuthenticationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    static final LinkedHashSet<String> NO_ATTRIBUTES = new LinkedHashSet(1);
    private final Provider provider;
    private static final Provider DEFAULT_PROVIDER;

    static boolean isServiceError(ResultCode resultCode) {
        switch (resultCode) {
            case OPERATIONS_ERROR: 
            case PROTOCOL_ERROR: 
            case TIME_LIMIT_EXCEEDED: 
            case ADMIN_LIMIT_EXCEEDED: 
            case UNAVAILABLE_CRITICAL_EXTENSION: 
            case BUSY: 
            case UNAVAILABLE: 
            case UNWILLING_TO_PERFORM: 
            case LOOP_DETECT: 
            case OTHER: 
            case CLIENT_SIDE_CONNECT_ERROR: 
            case CLIENT_SIDE_DECODING_ERROR: 
            case CLIENT_SIDE_ENCODING_ERROR: 
            case CLIENT_SIDE_LOCAL_ERROR: 
            case CLIENT_SIDE_SERVER_DOWN: 
            case CLIENT_SIDE_TIMEOUT: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getMappedSearchBindPassword(LDAPPassThroughAuthenticationPolicyCfg cfg, List<Message> unacceptableReasons) {
        String password = null;
        if (cfg.getMappedSearchBindPasswordProperty() != null) {
            String propertyName = cfg.getMappedSearchBindPasswordProperty();
            password = System.getProperty(propertyName);
            if (password != null) return password;
            unacceptableReasons.add(ExtensionMessages.ERR_LDAP_PTA_PWD_PROPERTY_NOT_SET.get(String.valueOf(cfg.dn()), String.valueOf(propertyName)));
            return password;
        }
        if (cfg.getMappedSearchBindPasswordEnvironmentVariable() != null) {
            String envVarName = cfg.getMappedSearchBindPasswordEnvironmentVariable();
            password = System.getenv(envVarName);
            if (password != null) return password;
            unacceptableReasons.add(ExtensionMessages.ERR_LDAP_PTA_PWD_ENVAR_NOT_SET.get(String.valueOf(cfg.dn()), String.valueOf(envVarName)));
            return password;
        }
        if (cfg.getMappedSearchBindPasswordFile() != null) {
            String fileName = cfg.getMappedSearchBindPasswordFile();
            File passwordFile = StaticUtils.getFileForPath(fileName);
            if (!passwordFile.exists()) {
                unacceptableReasons.add(ExtensionMessages.ERR_LDAP_PTA_PWD_NO_SUCH_FILE.get(String.valueOf(cfg.dn()), String.valueOf(fileName)));
                return password;
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(passwordFile));
                password = br.readLine();
                if (password != null) return password;
                unacceptableReasons.add(ExtensionMessages.ERR_LDAP_PTA_PWD_FILE_EMPTY.get(String.valueOf(cfg.dn()), String.valueOf(fileName)));
                return password;
            }
            catch (IOException e) {
                unacceptableReasons.add(ExtensionMessages.ERR_LDAP_PTA_PWD_FILE_CANNOT_READ.get(String.valueOf(cfg.dn()), String.valueOf(fileName), StaticUtils.getExceptionMessage(e)));
                return password;
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        if (cfg.getMappedSearchBindPassword() != null) {
            return cfg.getMappedSearchBindPassword();
        }
        unacceptableReasons.add(ExtensionMessages.ERR_LDAP_PTA_NO_PWD.get(String.valueOf(cfg.dn())));
        return password;
    }

    private static boolean isServerAddressValid(LDAPPassThroughAuthenticationPolicyCfg configuration, List<Message> unacceptableReasons, String hostPort) {
        int colonIndex = hostPort.lastIndexOf(":");
        int port = Integer.parseInt(hostPort.substring(colonIndex + 1));
        if (port < 1 || port > 65535) {
            if (unacceptableReasons != null) {
                Message msg = ExtensionMessages.ERR_LDAP_PTA_INVALID_PORT_NUMBER.get(String.valueOf(configuration.dn()), hostPort);
                unacceptableReasons.add(msg);
            }
            return false;
        }
        return true;
    }

    private static String mappedAttributesAsString(Collection<AttributeType> attributes) {
        switch (attributes.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return attributes.iterator().next().getNameOrOID();
            }
        }
        StringBuilder builder = new StringBuilder();
        Iterator<AttributeType> i = attributes.iterator();
        builder.append(i.next().getNameOrOID());
        while (i.hasNext()) {
            builder.append(", ");
            builder.append(i.next().getNameOrOID());
        }
        return builder.toString();
    }

    public LDAPPassThroughAuthenticationPolicyFactory() {
        this(DEFAULT_PROVIDER);
    }

    LDAPPassThroughAuthenticationPolicyFactory(Provider provider) {
        this.provider = provider;
    }

    @Override
    public AuthenticationPolicy createAuthenticationPolicy(LDAPPassThroughAuthenticationPolicyCfg configuration) throws ConfigException, InitializationException {
        PolicyImpl policy = new PolicyImpl(configuration);
        configuration.addLDAPPassThroughChangeListener(policy);
        return policy;
    }

    @Override
    public boolean isConfigurationAcceptable(LDAPPassThroughAuthenticationPolicyCfg cfg, List<Message> unacceptableReasons) {
        boolean configurationIsAcceptable = true;
        for (String hostPort : cfg.getPrimaryRemoteLDAPServer()) {
            configurationIsAcceptable &= LDAPPassThroughAuthenticationPolicyFactory.isServerAddressValid(cfg, unacceptableReasons, hostPort);
        }
        for (String hostPort : cfg.getSecondaryRemoteLDAPServer()) {
            configurationIsAcceptable &= LDAPPassThroughAuthenticationPolicyFactory.isServerAddressValid(cfg, unacceptableReasons, hostPort);
        }
        if (cfg.getMappingPolicy() == LDAPPassThroughAuthenticationPolicyCfgDefn.MappingPolicy.MAPPED_SEARCH && cfg.getMappedSearchBindDN() != null && !cfg.getMappedSearchBindDN().isNullDN() && LDAPPassThroughAuthenticationPolicyFactory.getMappedSearchBindPassword(cfg, unacceptableReasons) == null) {
            configurationIsAcceptable = false;
        }
        return configurationIsAcceptable;
    }

    static /* synthetic */ String access$2100(Collection x0) {
        return LDAPPassThroughAuthenticationPolicyFactory.mappedAttributesAsString(x0);
    }

    static {
        NO_ATTRIBUTES.add("1.1");
        DEFAULT_PROVIDER = new Provider(){
            private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    DirectoryThread t = new DirectoryThread(r, "LDAP PTA connection monitor thread");
                    t.setDaemon(true);
                    return t;
                }
            });

            @Override
            public ConnectionFactory getLDAPConnectionFactory(String host, int port, LDAPPassThroughAuthenticationPolicyCfg cfg) {
                return new LDAPConnectionFactory(host, port, cfg);
            }

            @Override
            public ScheduledExecutorService getScheduledExecutorService() {
                return this.scheduler;
            }

            @Override
            public String getCurrentTime() {
                return TimeThread.getGMTTime();
            }

            @Override
            public long getCurrentTimeMS() {
                return TimeThread.getTime();
            }
        };
    }

    private final class PolicyImpl
    extends AuthenticationPolicy
    implements ConfigurationChangeListener<LDAPPassThroughAuthenticationPolicyCfg> {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final ReentrantReadWriteLock.ReadLock sharedLock = this.lock.readLock();
        private final ReentrantReadWriteLock.WriteLock exclusiveLock = this.lock.writeLock();
        private LDAPPassThroughAuthenticationPolicyCfg cfg;
        private ConnectionFactory searchFactory = null;
        private ConnectionFactory bindFactory = null;
        private PasswordStorageScheme<?> pwdStorageScheme = null;

        private PolicyImpl(LDAPPassThroughAuthenticationPolicyCfg configuration) {
            this.initializeConfiguration(configuration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConfigChangeResult applyConfigurationChange(LDAPPassThroughAuthenticationPolicyCfg cfg) {
            this.exclusiveLock.lock();
            try {
                this.closeConnections();
                this.initializeConfiguration(cfg);
            }
            finally {
                this.exclusiveLock.unlock();
            }
            return new ConfigChangeResult(ResultCode.SUCCESS, false);
        }

        @Override
        public AuthenticationPolicyState createAuthenticationPolicyState(Entry userEntry, long time) throws DirectoryException {
            return new StateImpl(userEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finalizeAuthenticationPolicy() {
            this.exclusiveLock.lock();
            try {
                this.cfg.removeLDAPPassThroughChangeListener(this);
                this.closeConnections();
            }
            finally {
                this.exclusiveLock.unlock();
            }
        }

        @Override
        public DN getDN() {
            return this.cfg.dn();
        }

        @Override
        public boolean isConfigurationChangeAcceptable(LDAPPassThroughAuthenticationPolicyCfg cfg, List<Message> unacceptableReasons) {
            return LDAPPassThroughAuthenticationPolicyFactory.this.isConfigurationAcceptable(cfg, unacceptableReasons);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeConnections() {
            this.exclusiveLock.lock();
            try {
                if (this.searchFactory != null) {
                    this.searchFactory.close();
                    this.searchFactory = null;
                }
                if (this.bindFactory != null) {
                    this.bindFactory.close();
                    this.bindFactory = null;
                }
            }
            finally {
                this.exclusiveLock.unlock();
            }
        }

        private void initializeConfiguration(LDAPPassThroughAuthenticationPolicyCfg cfg) {
            ConnectionFactory factory;
            this.cfg = cfg;
            String mappedSearchPassword = cfg.getMappingPolicy() == LDAPPassThroughAuthenticationPolicyCfgDefn.MappingPolicy.MAPPED_SEARCH && cfg.getMappedSearchBindDN() != null && !cfg.getMappedSearchBindDN().isNullDN() ? LDAPPassThroughAuthenticationPolicyFactory.getMappedSearchBindPassword(cfg, new LinkedList()) : null;
            ScheduledExecutorService scheduler = LDAPPassThroughAuthenticationPolicyFactory.this.provider.getScheduledExecutorService();
            SortedSet<String> servers = cfg.getPrimaryRemoteLDAPServer();
            ConnectionFactory[] searchPool = new ConnectionPool[servers.size()];
            ConnectionFactory[] bindPool = new ConnectionPool[servers.size()];
            int index = 0;
            for (String hostPort : servers) {
                factory = this.newLDAPConnectionFactory(hostPort);
                searchPool[index] = new ConnectionPool(new AuthenticatedConnectionFactory(factory, cfg.getMappedSearchBindDN(), mappedSearchPassword));
                bindPool[index++] = new ConnectionPool(factory);
            }
            RoundRobinLoadBalancer primarySearchLoadBalancer = new RoundRobinLoadBalancer(searchPool, scheduler);
            RoundRobinLoadBalancer primaryBindLoadBalancer = new RoundRobinLoadBalancer(bindPool, scheduler);
            servers = cfg.getSecondaryRemoteLDAPServer();
            if (servers.isEmpty()) {
                this.searchFactory = primarySearchLoadBalancer;
                this.bindFactory = primaryBindLoadBalancer;
            } else {
                searchPool = new ConnectionPool[servers.size()];
                bindPool = new ConnectionPool[servers.size()];
                index = 0;
                for (String hostPort : servers) {
                    factory = this.newLDAPConnectionFactory(hostPort);
                    searchPool[index] = new ConnectionPool(new AuthenticatedConnectionFactory(factory, cfg.getMappedSearchBindDN(), mappedSearchPassword));
                    bindPool[index++] = new ConnectionPool(factory);
                }
                RoundRobinLoadBalancer secondarySearchLoadBalancer = new RoundRobinLoadBalancer(searchPool, scheduler);
                RoundRobinLoadBalancer secondaryBindLoadBalancer = new RoundRobinLoadBalancer(bindPool, scheduler);
                this.searchFactory = new FailoverLoadBalancer(primarySearchLoadBalancer, secondarySearchLoadBalancer, scheduler);
                this.bindFactory = new FailoverLoadBalancer(primaryBindLoadBalancer, secondaryBindLoadBalancer, scheduler);
            }
            if (cfg.isUsePasswordCaching()) {
                this.pwdStorageScheme = DirectoryServer.getPasswordStorageScheme(cfg.getCachedPasswordStorageSchemeDN());
            }
        }

        private ConnectionFactory newLDAPConnectionFactory(String hostPort) {
            int colonIndex = hostPort.lastIndexOf(":");
            String hostname = hostPort.substring(0, colonIndex);
            int port = Integer.parseInt(hostPort.substring(colonIndex + 1));
            return LDAPPassThroughAuthenticationPolicyFactory.this.provider.getLDAPConnectionFactory(hostname, port, this.cfg);
        }

        static /* synthetic */ ConnectionFactory access$2200(PolicyImpl x0) {
            return x0.searchFactory;
        }

        static /* synthetic */ ConnectionFactory access$2300(PolicyImpl x0) {
            return x0.bindFactory;
        }

        private final class StateImpl
        extends AuthenticationPolicyState {
            private final AttributeType cachedPasswordAttribute;
            private final AttributeType cachedPasswordTimeAttribute;
            private ByteString newCachedPassword;

            private StateImpl(Entry userEntry) {
                super(userEntry);
                this.newCachedPassword = null;
                this.cachedPasswordAttribute = DirectoryServer.getAttributeType("ds-pta-cached-password", true);
                this.cachedPasswordTimeAttribute = DirectoryServer.getAttributeType("ds-pta-cached-password-time", true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finalizeStateAfterBind() throws DirectoryException {
                PolicyImpl.this.sharedLock.lock();
                try {
                    if (PolicyImpl.this.cfg.isUsePasswordCaching() && this.newCachedPassword != null) {
                        ByteString encodedPassword = PolicyImpl.this.pwdStorageScheme.encodePasswordWithScheme(this.newCachedPassword);
                        ArrayList<RawModification> modifications = new ArrayList<RawModification>(2);
                        modifications.add(RawModification.create(ModificationType.REPLACE, "ds-pta-cached-password", encodedPassword));
                        modifications.add(RawModification.create(ModificationType.REPLACE, "ds-pta-cached-password-time", LDAPPassThroughAuthenticationPolicyFactory.this.provider.getCurrentTime()));
                        InternalClientConnection conn = InternalClientConnection.getRootConnection();
                        ModifyOperation internalModify = conn.processModify(this.userEntry.getDN().toString(), modifications);
                        ResultCode resultCode = internalModify.getResultCode();
                        if (resultCode != ResultCode.SUCCESS && DebugLogger.debugEnabled()) {
                            TRACER.debugWarning("An error occurred while trying to update the LDAP PTA cached password for user %s: %s", this.userEntry.getDN().toString(), String.valueOf(internalModify.getErrorMessage()));
                        }
                        this.newCachedPassword = null;
                    }
                }
                finally {
                    PolicyImpl.this.sharedLock.unlock();
                }
            }

            @Override
            public AuthenticationPolicy getAuthenticationPolicy() {
                return PolicyImpl.this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public boolean passwordMatches(ByteString password) throws DirectoryException {
                PolicyImpl.access$1700(PolicyImpl.this).lock();
                try {
                    if (this.passwordMatchesCachedPassword(password)) {
                        var2_2 = true;
                        return var2_2;
                    }
                    username = null;
                    switch (2.$SwitchMap$org$opends$server$admin$std$meta$LDAPPassThroughAuthenticationPolicyCfgDefn$MappingPolicy[PolicyImpl.access$1800(PolicyImpl.this).getMappingPolicy().ordinal()]) {
                        case 1: {
                            username = ByteString.valueOf(this.userEntry.getDN().toString());
                            break;
                        }
                        case 2: {
                            block28: for (AttributeType at : PolicyImpl.access$1800(PolicyImpl.this).getMappedAttribute()) {
                                attributes = this.userEntry.getAttribute(at);
                                if (attributes == null || attributes.isEmpty()) continue;
                                for (Attribute attribute : attributes) {
                                    if (attribute.isEmpty()) continue;
                                    username = attribute.iterator().next().getValue();
                                    break block28;
                                }
                            }
                            if (username != null) break;
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, ExtensionMessages.ERR_LDAP_PTA_MAPPING_ATTRIBUTE_NOT_FOUND.get(String.valueOf(this.userEntry.getDN()), String.valueOf(PolicyImpl.access$1800(PolicyImpl.this).dn()), LDAPPassThroughAuthenticationPolicyFactory.access$2100(PolicyImpl.access$1800(PolicyImpl.this).getMappedAttribute())));
                        }
                        case 3: {
                            filterComponents = new LinkedList<SearchFilter>();
                            for (AttributeType at : PolicyImpl.access$1800(PolicyImpl.this).getMappedAttribute()) {
                                attributes = this.userEntry.getAttribute(at);
                                if (attributes == null || attributes.isEmpty()) continue;
                                for (Attribute attribute : attributes) {
                                    for (AttributeValue value : attribute) {
                                        filterComponents.add(SearchFilter.createEqualityFilter(at, value));
                                    }
                                }
                            }
                            if (filterComponents.isEmpty()) {
                                throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, ExtensionMessages.ERR_LDAP_PTA_MAPPING_ATTRIBUTE_NOT_FOUND.get(String.valueOf(this.userEntry.getDN()), String.valueOf(PolicyImpl.access$1800(PolicyImpl.this).dn()), LDAPPassThroughAuthenticationPolicyFactory.access$2100(PolicyImpl.access$1800(PolicyImpl.this).getMappedAttribute())));
                            }
                            filter = filterComponents.size() == 1 ? (SearchFilter)filterComponents.getFirst() : SearchFilter.createORFilter(filterComponents);
lbl37:
                            // 5 sources

                            for (DN baseDN : PolicyImpl.access$1800(PolicyImpl.this).getMappedSearchBaseDN()) {
                                connection = null;
                                try {
                                    connection = PolicyImpl.access$2200(PolicyImpl.this).getConnection();
                                    username = connection.search(baseDN, SearchScope.WHOLE_SUBTREE, filter);
                                }
                                catch (DirectoryException e) {
                                    switch (2.$SwitchMap$org$opends$server$types$ResultCode[e.getResultCode().ordinal()]) {
                                        case 3: 
                                        case 4: {
                                            ** break;
                                        }
                                        case 5: {
                                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, ExtensionMessages.ERR_LDAP_PTA_MAPPED_SEARCH_TOO_MANY_CANDIDATES.get(String.valueOf(this.userEntry.getDN()), String.valueOf(PolicyImpl.access$1800(PolicyImpl.this).dn()), String.valueOf(baseDN), String.valueOf(filter)));
                                        }
                                        default: {
                                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, ExtensionMessages.ERR_LDAP_PTA_MAPPED_SEARCH_FAILED.get(String.valueOf(this.userEntry.getDN()), String.valueOf(PolicyImpl.access$1800(PolicyImpl.this).dn()), e.getMessageObject()), e);
                                        }
                                    }
                                }
                                finally {
                                    if (connection == null) continue;
                                    connection.close();
                                }
                            }
                            if (username != null) break;
                            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, ExtensionMessages.ERR_LDAP_PTA_MAPPED_SEARCH_NO_CANDIDATES.get(String.valueOf(this.userEntry.getDN()), String.valueOf(PolicyImpl.access$1800(PolicyImpl.this).dn()), String.valueOf(filter)));
                        }
                    }
                    connection = null;
                    try {
                        connection = PolicyImpl.access$2300(PolicyImpl.this).getConnection();
                        connection.simpleBind(username, password);
                        this.newCachedPassword = password;
                        filter = true;
                        if (connection != null) {
                            connection.close();
                        }
                        return filter;
                    }
                    catch (DirectoryException e) {
                        switch (2.$SwitchMap$org$opends$server$types$ResultCode[e.getResultCode().ordinal()]) {
                            case 3: 
                            case 6: {
                                var5_9 = false;
                                if (connection != null) {
                                    connection.close();
                                }
                                PolicyImpl.access$1700(PolicyImpl.this).unlock();
                                return var5_9;
                            }
                        }
                        throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, ExtensionMessages.ERR_LDAP_PTA_MAPPED_BIND_FAILED.get(String.valueOf(this.userEntry.getDN()), String.valueOf(PolicyImpl.access$1800(PolicyImpl.this).dn()), e.getMessageObject()), e);
                        {
                            catch (Throwable var12_19) {
                                if (connection != null) {
                                    connection.close();
                                }
                                throw var12_19;
                            }
                        }
                    }
                }
                finally {
                    PolicyImpl.access$1700(PolicyImpl.this).unlock();
                }
            }

            private boolean passwordMatchesCachedPassword(ByteString password) {
                block12: {
                    if (!PolicyImpl.this.cfg.isUsePasswordCaching()) {
                        return false;
                    }
                    boolean foundValidCachedPasswordTime = false;
                    List<Attribute> cptlist = this.userEntry.getAttribute(this.cachedPasswordTimeAttribute);
                    if (cptlist != null && !cptlist.isEmpty()) {
                        for (Attribute attribute : cptlist) {
                            Iterator<Object> i$;
                            if (attribute.hasOptions() || !(i$ = attribute.iterator()).hasNext()) continue;
                            AttributeValue value = (AttributeValue)i$.next();
                            try {
                                long cachedPasswordTime = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(value.getNormalizedValue());
                                long currentTime = LDAPPassThroughAuthenticationPolicyFactory.this.provider.getCurrentTimeMS();
                                long expiryTime = cachedPasswordTime + PolicyImpl.this.cfg.getCachedPasswordTTL() * 1000L;
                                foundValidCachedPasswordTime = expiryTime > currentTime;
                            }
                            catch (DirectoryException e) {
                                if (!DebugLogger.debugEnabled()) break;
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            break;
                        }
                    }
                    if (!foundValidCachedPasswordTime) {
                        return false;
                    }
                    ByteString cachedPassword = null;
                    List<Attribute> cplist = this.userEntry.getAttribute(this.cachedPasswordAttribute);
                    if (cplist != null && !cplist.isEmpty()) {
                        for (Attribute attribute : cplist) {
                            Iterator<AttributeValue> i$;
                            if (attribute.hasOptions() || !(i$ = attribute.iterator()).hasNext()) continue;
                            AttributeValue value = i$.next();
                            cachedPassword = value.getValue();
                            break;
                        }
                    }
                    if (cachedPassword == null) {
                        return false;
                    }
                    try {
                        String[] userPwComponents = UserPasswordSyntax.decodeUserPassword(cachedPassword.toString());
                        PasswordStorageScheme scheme = DirectoryServer.getPasswordStorageScheme(userPwComponents[0]);
                        if (scheme != null) {
                            return scheme.passwordMatches(password, ByteString.valueOf(userPwComponents[1]));
                        }
                    }
                    catch (DirectoryException e) {
                        if (!DebugLogger.debugEnabled()) break block12;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                return false;
            }
        }
    }

    static final class RoundRobinLoadBalancer
    extends AbstractLoadBalancer {
        private final AtomicInteger nextIndex = new AtomicInteger();
        private final int maxIndex;

        RoundRobinLoadBalancer(ConnectionFactory[] factories, ScheduledExecutorService scheduler) {
            super(factories, scheduler);
            this.maxIndex = factories.length;
        }

        @Override
        int getStartIndex() {
            int newNextIndex;
            int oldNextIndex;
            if (this.maxIndex == 1) {
                return 0;
            }
            do {
                if ((newNextIndex = (oldNextIndex = this.nextIndex.get()) + 1) != this.maxIndex) continue;
                newNextIndex = 0;
            } while (!this.nextIndex.compareAndSet(oldNextIndex, newNextIndex));
            return oldNextIndex;
        }
    }

    static interface Provider {
        public ConnectionFactory getLDAPConnectionFactory(String var1, int var2, LDAPPassThroughAuthenticationPolicyCfg var3);

        public ScheduledExecutorService getScheduledExecutorService();

        public String getCurrentTime();

        public long getCurrentTimeMS();
    }

    static final class LDAPConnectionFactory
    implements ConnectionFactory {
        private final String host;
        private final int port;
        private final LDAPPassThroughAuthenticationPolicyCfg cfg;
        private final int timeoutMS;

        LDAPConnectionFactory(String host, int port, LDAPPassThroughAuthenticationPolicyCfg cfg) {
            this.host = host;
            this.port = port;
            this.cfg = cfg;
            this.timeoutMS = (int)Math.min(cfg.getConnectionTimeout(), Integer.MAX_VALUE);
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection getConnection() throws DirectoryException {
            LDAPConnection lDAPConnection;
            block36: {
                Socket ldapSocket;
                Socket plainSocket;
                block37: {
                    InetAddress address = InetAddress.getByName(this.host);
                    InetSocketAddress socketAddress = new InetSocketAddress(address, this.port);
                    plainSocket = new Socket();
                    ldapSocket = null;
                    LDAPReader reader = null;
                    LDAPWriter writer = null;
                    LDAPConnection ldapConnection = null;
                    try {
                        plainSocket.setTcpNoDelay(this.cfg.isUseTCPNoDelay());
                        plainSocket.setKeepAlive(this.cfg.isUseTCPKeepAlive());
                        plainSocket.setSoTimeout(this.timeoutMS);
                        if (this.cfg.getSourceAddress() != null) {
                            InetSocketAddress local = new InetSocketAddress(this.cfg.getSourceAddress(), 0);
                            plainSocket.bind(local);
                        }
                        plainSocket.connect(socketAddress, this.timeoutMS);
                        if (this.cfg.isUseSSL()) {
                            TrustManagerProvider trustManagerProvider;
                            TrustManager[] tm = null;
                            DN trustManagerDN = this.cfg.getTrustManagerProviderDN();
                            if (trustManagerDN != null && (trustManagerProvider = DirectoryServer.getTrustManagerProvider(trustManagerDN)) != null) {
                                tm = trustManagerProvider.getTrustManagers();
                            }
                            SSLContext sslContext = SSLContext.getInstance("TLS");
                            sslContext.init(null, tm, null);
                            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                            SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(plainSocket, this.host, this.port, true);
                            ldapSocket = sslSocket;
                            sslSocket.setUseClientMode(true);
                            if (!this.cfg.getSSLProtocol().isEmpty()) {
                                sslSocket.setEnabledProtocols(this.cfg.getSSLProtocol().toArray(new String[0]));
                            }
                            if (!this.cfg.getSSLCipherSuite().isEmpty()) {
                                sslSocket.setEnabledCipherSuites(this.cfg.getSSLCipherSuite().toArray(new String[0]));
                            }
                            sslSocket.startHandshake();
                        } else {
                            ldapSocket = plainSocket;
                        }
                        reader = new LDAPReader(ldapSocket);
                        writer = new LDAPWriter(ldapSocket);
                        lDAPConnection = ldapConnection = new LDAPConnection(plainSocket, ldapSocket, reader, writer);
                        if (ldapConnection != null) break block36;
                        if (reader != null) {
                            reader.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                        if (ldapSocket == null) break block37;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ldapConnection == null) {
                                if (reader != null) {
                                    reader.close();
                                }
                                if (writer != null) {
                                    writer.close();
                                }
                                if (ldapSocket != null) {
                                    try {
                                        ldapSocket.close();
                                    }
                                    catch (IOException ignored) {
                                        // empty catch block
                                    }
                                }
                                if (ldapSocket != plainSocket) {
                                    try {
                                        plainSocket.close();
                                    }
                                    catch (IOException ignored) {
                                        // empty catch block
                                    }
                                }
                            }
                            throw throwable;
                        }
                        catch (UnknownHostException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            throw new DirectoryException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, ExtensionMessages.ERR_LDAP_PTA_CONNECT_UNKNOWN_HOST.get(this.host, this.port, String.valueOf(this.cfg.dn()), this.host), e);
                        }
                        catch (ConnectException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            throw new DirectoryException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, ExtensionMessages.ERR_LDAP_PTA_CONNECT_ERROR.get(this.host, this.port, String.valueOf(this.cfg.dn()), this.port), e);
                        }
                        catch (SocketTimeoutException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            throw new DirectoryException(ResultCode.CLIENT_SIDE_TIMEOUT, ExtensionMessages.ERR_LDAP_PTA_CONNECT_TIMEOUT.get(this.host, this.port, String.valueOf(this.cfg.dn())), e);
                        }
                        catch (SSLException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            throw new DirectoryException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, ExtensionMessages.ERR_LDAP_PTA_CONNECT_SSL_ERROR.get(this.host, this.port, String.valueOf(this.cfg.dn()), e.getMessage()), e);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            throw new DirectoryException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, ExtensionMessages.ERR_LDAP_PTA_CONNECT_OTHER_ERROR.get(this.host, this.port, String.valueOf(this.cfg.dn()), e.getMessage()), e);
                        }
                    }
                    try {
                        ldapSocket.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                if (ldapSocket != plainSocket) {
                    try {
                        plainSocket.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
            return lDAPConnection;
        }

        private final class LDAPConnection
        implements Connection {
            private final Socket plainSocket;
            private final Socket ldapSocket;
            private final LDAPWriter writer;
            private final LDAPReader reader;
            private int nextMessageID = 1;
            private boolean isClosed = false;

            private LDAPConnection(Socket plainSocket, Socket ldapSocket, LDAPReader reader, LDAPWriter writer) {
                this.plainSocket = plainSocket;
                this.ldapSocket = ldapSocket;
                this.reader = reader;
                this.writer = writer;
            }

            @Override
            public void close() {
                block9: {
                    block8: {
                        block7: {
                            if (this.isClosed) {
                                return;
                            }
                            this.isClosed = true;
                            LDAPMessage message = new LDAPMessage(this.nextMessageID++, new UnbindRequestProtocolOp());
                            try {
                                this.writer.writeMessage(message);
                            }
                            catch (IOException e) {
                                if (!DebugLogger.debugEnabled()) break block7;
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                        }
                        this.writer.close();
                        this.reader.close();
                        try {
                            this.ldapSocket.close();
                        }
                        catch (IOException e) {
                            if (!DebugLogger.debugEnabled()) break block8;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    try {
                        this.plainSocket.close();
                    }
                    catch (IOException e) {
                        if (!DebugLogger.debugEnabled()) break block9;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }

            @Override
            public ByteString search(DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
                byte opType;
                SearchRequestProtocolOp searchRequest = new SearchRequestProtocolOp(ByteString.valueOf(baseDN.toString()), scope, DereferencePolicy.DEREF_ALWAYS, 1, LDAPConnectionFactory.this.timeoutMS / 1000, true, RawFilter.create(filter), NO_ATTRIBUTES);
                this.sendRequest(searchRequest);
                ByteString username = null;
                int resultCount = 0;
                do {
                    LDAPMessage responseMessage = this.readResponse();
                    opType = responseMessage.getProtocolOpType();
                    block0 : switch (opType) {
                        case 100: {
                            SearchResultEntryProtocolOp searchEntry = responseMessage.getSearchResultEntryProtocolOp();
                            if (username == null) {
                                username = ByteString.valueOf(searchEntry.getDN().toString());
                            }
                            ++resultCount;
                            break;
                        }
                        case 115: {
                            break;
                        }
                        case 101: {
                            SearchResultDoneProtocolOp searchResult = responseMessage.getSearchResultDoneProtocolOp();
                            ResultCode resultCode = ResultCode.valueOf(searchResult.getResultCode());
                            switch (resultCode) {
                                case SUCCESS: {
                                    break block0;
                                }
                                case SIZE_LIMIT_EXCEEDED: {
                                    throw new DirectoryException(ResultCode.CLIENT_SIDE_MORE_RESULTS_TO_RETURN, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_SEARCH_SIZE_LIMIT.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), String.valueOf(baseDN), String.valueOf(filter)));
                                }
                            }
                            throw new DirectoryException(resultCode, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_SEARCH_FAILED.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), String.valueOf(baseDN), String.valueOf(filter), resultCode.getIntValue(), resultCode.getResultCodeName(), searchResult.getErrorMessage()));
                        }
                        default: {
                            this.handleUnexpectedResponse(responseMessage);
                        }
                    }
                } while (opType != 101);
                if (resultCount > 1) {
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_MORE_RESULTS_TO_RETURN, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_SEARCH_SIZE_LIMIT.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), String.valueOf(baseDN), String.valueOf(filter)));
                }
                if (username == null) {
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_SEARCH_NO_MATCHES.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), String.valueOf(baseDN), String.valueOf(filter)));
                }
                return username;
            }

            @Override
            public void simpleBind(ByteString username, ByteString password) throws DirectoryException {
                BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(username, 3, password);
                this.sendRequest(bindRequest);
                LDAPMessage responseMessage = this.readResponse();
                switch (responseMessage.getProtocolOpType()) {
                    case 97: {
                        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
                        ResultCode resultCode = ResultCode.valueOf(bindResponse.getResultCode());
                        if (resultCode == ResultCode.SUCCESS) {
                            return;
                        }
                        throw new DirectoryException(resultCode, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_BIND_FAILED.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), String.valueOf(username), resultCode.getIntValue(), resultCode.getResultCodeName(), bindResponse.getErrorMessage()));
                    }
                }
                this.handleUnexpectedResponse(responseMessage);
            }

            protected void finalize() {
                this.close();
            }

            private void handleUnexpectedResponse(LDAPMessage responseMessage) throws DirectoryException {
                ExtendedResponseProtocolOp extendedResponse;
                String responseOID;
                if (responseMessage.getProtocolOpType() == 120 && (responseOID = (extendedResponse = responseMessage.getExtendedResponseProtocolOp()).getOID()) != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    ResultCode resultCode = ResultCode.valueOf(extendedResponse.getResultCode());
                    ResultCode mappedResultCode = LDAPPassThroughAuthenticationPolicyFactory.isServiceError(resultCode) ? resultCode : ResultCode.UNAVAILABLE;
                    throw new DirectoryException(mappedResultCode, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_DISCONNECTING.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), resultCode.getIntValue(), resultCode.getResultCodeName(), extendedResponse.getErrorMessage()));
                }
                throw new DirectoryException(ResultCode.CLIENT_SIDE_DECODING_ERROR, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_WRONG_RESPONSE.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), String.valueOf(responseMessage.getProtocolOp())));
            }

            private LDAPMessage readResponse() throws DirectoryException {
                LDAPMessage responseMessage;
                try {
                    responseMessage = this.reader.readMessage();
                }
                catch (ASN1Exception e) {
                    if (e.getCause() instanceof SocketTimeoutException) {
                        throw new DirectoryException(ResultCode.CLIENT_SIDE_TIMEOUT, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_TIMEOUT.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn())), e);
                    }
                    if (e.getCause() instanceof IOException) {
                        throw new DirectoryException(ResultCode.CLIENT_SIDE_SERVER_DOWN, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_OTHER_ERROR.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), e.getMessage()), e);
                    }
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_DECODING_ERROR, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_DECODE_ERROR.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), e.getMessage()), e);
                }
                catch (LDAPException e) {
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_DECODING_ERROR, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_DECODE_ERROR.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), e.getMessage()), e);
                }
                catch (SocketTimeoutException e) {
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_TIMEOUT, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_TIMEOUT.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn())), e);
                }
                catch (IOException e) {
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_SERVER_DOWN, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_OTHER_ERROR.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), e.getMessage()), e);
                }
                if (responseMessage == null) {
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_SERVER_DOWN, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_CLOSED.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn())));
                }
                return responseMessage;
            }

            private void sendRequest(ProtocolOp request) throws DirectoryException {
                LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID++, request);
                try {
                    this.writer.writeMessage(requestMessage);
                }
                catch (IOException e) {
                    throw new DirectoryException(ResultCode.CLIENT_SIDE_SERVER_DOWN, ExtensionMessages.ERR_LDAP_PTA_CONNECTION_OTHER_ERROR.get(LDAPConnectionFactory.this.host, LDAPConnectionFactory.this.port, String.valueOf(LDAPConnectionFactory.this.cfg.dn()), e.getMessage()), e);
                }
            }
        }
    }

    static final class FailoverLoadBalancer
    extends AbstractLoadBalancer {
        FailoverLoadBalancer(ConnectionFactory primary, ConnectionFactory secondary, ScheduledExecutorService scheduler) {
            super(new ConnectionFactory[]{primary, secondary}, scheduler);
        }

        @Override
        int getStartIndex() {
            return 0;
        }
    }

    static final class ConnectionPool
    implements ConnectionFactory {
        private boolean poolIsClosed = false;
        private final ConnectionFactory factory;
        private final int poolSize = Runtime.getRuntime().availableProcessors() * 2;
        private final Semaphore availableConnections = new Semaphore(this.poolSize);
        private final Queue<Connection> connectionPool = new ConcurrentLinkedQueue<Connection>();

        ConnectionPool(ConnectionFactory factory) {
            this.factory = factory;
        }

        @Override
        public void close() {
            Connection connection;
            this.poolIsClosed = true;
            while ((connection = this.connectionPool.poll()) != null) {
                connection.close();
            }
            this.factory.close();
            if (this.availableConnections.availablePermits() != this.poolSize) {
                throw new IllegalStateException("Pool has remaining connections open after close");
            }
        }

        @Override
        public Connection getConnection() throws DirectoryException {
            if (this.poolIsClosed) {
                throw new IllegalStateException("pool is closed");
            }
            this.availableConnections.acquireUninterruptibly();
            Connection connection = this.connectionPool.poll();
            if (connection == null) {
                try {
                    connection = this.factory.getConnection();
                }
                catch (DirectoryException e) {
                    this.availableConnections.release();
                    throw e;
                }
            }
            return new PooledConnection(connection);
        }

        private final class PooledConnection
        implements Connection {
            private Connection connection;
            private boolean connectionIsClosed = false;

            private PooledConnection(Connection connection) {
                this.connection = connection;
            }

            @Override
            public void close() {
                if (!this.connectionIsClosed) {
                    this.connectionIsClosed = true;
                    if (ConnectionPool.this.poolIsClosed) {
                        this.connection.close();
                    } else {
                        ConnectionPool.this.connectionPool.offer(this.connection);
                    }
                    this.connection = null;
                    ConnectionPool.this.availableConnections.release();
                }
            }

            @Override
            public ByteString search(DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
                try {
                    return this.connection.search(baseDN, scope, filter);
                }
                catch (DirectoryException e1) {
                    this.reconnectIfConnectionFailure(e1);
                    try {
                        return this.connection.search(baseDN, scope, filter);
                    }
                    catch (DirectoryException e2) {
                        this.closeIfConnectionFailure(e2);
                        throw e2;
                    }
                }
            }

            @Override
            public void simpleBind(ByteString username, ByteString password) throws DirectoryException {
                try {
                    this.connection.simpleBind(username, password);
                }
                catch (DirectoryException e1) {
                    this.reconnectIfConnectionFailure(e1);
                    try {
                        this.connection.simpleBind(username, password);
                    }
                    catch (DirectoryException e2) {
                        this.closeIfConnectionFailure(e2);
                        throw e2;
                    }
                }
            }

            private void closeIfConnectionFailure(DirectoryException e) throws DirectoryException {
                if (LDAPPassThroughAuthenticationPolicyFactory.isServiceError(e.getResultCode())) {
                    this.connectionIsClosed = true;
                    this.connection.close();
                    this.connection = null;
                    ConnectionPool.this.availableConnections.release();
                }
            }

            private void reconnectIfConnectionFailure(DirectoryException e) throws DirectoryException {
                if (!LDAPPassThroughAuthenticationPolicyFactory.isServiceError(e.getResultCode())) {
                    throw e;
                }
                this.connection.close();
                try {
                    this.connection = ConnectionPool.this.factory.getConnection();
                }
                catch (DirectoryException e2) {
                    this.connectionIsClosed = true;
                    this.connection = null;
                    ConnectionPool.this.availableConnections.release();
                    throw e2;
                }
            }
        }
    }

    static interface ConnectionFactory
    extends Closeable {
        @Override
        public void close();

        public Connection getConnection() throws DirectoryException;
    }

    static interface Connection
    extends Closeable {
        @Override
        public void close();

        public ByteString search(DN var1, SearchScope var2, SearchFilter var3) throws DirectoryException;

        public void simpleBind(ByteString var1, ByteString var2) throws DirectoryException;
    }

    static final class AuthenticatedConnectionFactory
    implements ConnectionFactory {
        private final ConnectionFactory factory;
        private final DN username;
        private final String password;

        AuthenticatedConnectionFactory(ConnectionFactory factory, DN username, String password) {
            this.factory = factory;
            this.username = username;
            this.password = password;
        }

        @Override
        public void close() {
            this.factory.close();
        }

        @Override
        public Connection getConnection() throws DirectoryException {
            Connection connection = this.factory.getConnection();
            if (this.username != null && !this.username.isNullDN() && this.password != null && this.password.length() > 0) {
                try {
                    connection.simpleBind(ByteString.valueOf(this.username.toString()), ByteString.valueOf(this.password));
                }
                catch (DirectoryException e) {
                    connection.close();
                    throw e;
                }
            }
            return connection;
        }
    }

    static abstract class AbstractLoadBalancer
    implements ConnectionFactory,
    Runnable {
        private final MonitoredConnectionFactory[] factories;
        private final int maxIndex;
        private final ScheduledFuture<?> monitorFuture;

        AbstractLoadBalancer(ConnectionFactory[] factories, ScheduledExecutorService scheduler) {
            this.factories = new MonitoredConnectionFactory[factories.length];
            this.maxIndex = factories.length;
            for (int i = 0; i < this.maxIndex; ++i) {
                this.factories[i] = new MonitoredConnectionFactory(factories[i]);
            }
            this.monitorFuture = scheduler.scheduleWithFixedDelay(this, 5L, 5L, TimeUnit.SECONDS);
        }

        @Override
        public final void close() {
            this.monitorFuture.cancel(true);
            for (MonitoredConnectionFactory factory : this.factories) {
                factory.close();
            }
        }

        @Override
        public final Connection getConnection() throws DirectoryException {
            int startIndex = this.getStartIndex();
            return new FailoverConnection(startIndex);
        }

        @Override
        public void run() {
            for (MonitoredConnectionFactory factory : this.factories) {
                if (factory.isAvailable) continue;
                try {
                    factory.getConnection().close();
                }
                catch (DirectoryException e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }

        abstract int getStartIndex();

        private final class MonitoredConnectionFactory
        implements ConnectionFactory {
            private final ConnectionFactory factory;
            private volatile boolean isAvailable = true;
            private DirectoryException lastException = null;

            private MonitoredConnectionFactory(ConnectionFactory factory) {
                this.factory = factory;
            }

            @Override
            public void close() {
                this.factory.close();
            }

            @Override
            public Connection getConnection() throws DirectoryException {
                try {
                    Connection connection = this.factory.getConnection();
                    this.isAvailable = true;
                    return connection;
                }
                catch (DirectoryException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.lastException = e;
                    this.isAvailable = false;
                    throw e;
                }
            }
        }

        private final class FailoverConnection
        implements Connection {
            private Connection connection;
            private MonitoredConnectionFactory factory;
            private final int startIndex;
            private int nextIndex;

            private FailoverConnection(int startIndex) throws DirectoryException {
                DirectoryException lastException;
                this.startIndex = this.nextIndex = startIndex;
                do {
                    this.factory = AbstractLoadBalancer.this.factories[this.nextIndex];
                    if (this.factory.isAvailable) {
                        try {
                            this.connection = this.factory.getConnection();
                            this.incrementNextIndex();
                            return;
                        }
                        catch (DirectoryException e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            lastException = e;
                        }
                    } else {
                        lastException = this.factory.lastException;
                    }
                    this.incrementNextIndex();
                } while (this.nextIndex != startIndex);
                throw lastException;
            }

            @Override
            public void close() {
                this.connection.close();
            }

            @Override
            public ByteString search(DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
                while (true) {
                    try {
                        return this.connection.search(baseDN, scope, filter);
                    }
                    catch (DirectoryException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        this.handleDirectoryException(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public void simpleBind(ByteString username, ByteString password) throws DirectoryException {
                while (true) {
                    try {
                        this.connection.simpleBind(username, password);
                        return;
                    }
                    catch (DirectoryException e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        this.handleDirectoryException(e);
                        continue;
                    }
                    break;
                }
            }

            private void handleDirectoryException(DirectoryException e) throws DirectoryException {
                if (!LDAPPassThroughAuthenticationPolicyFactory.isServiceError(e.getResultCode())) {
                    throw e;
                }
                this.connection.close();
                this.factory.lastException = e;
                this.factory.isAvailable = false;
                while (this.nextIndex != this.startIndex) {
                    block5: {
                        this.factory = AbstractLoadBalancer.this.factories[this.nextIndex];
                        if (this.factory.isAvailable) {
                            try {
                                this.connection = this.factory.getConnection();
                                this.incrementNextIndex();
                                return;
                            }
                            catch (DirectoryException de) {
                                if (!DebugLogger.debugEnabled()) break block5;
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                        }
                    }
                    this.incrementNextIndex();
                }
                throw e;
            }

            private void incrementNextIndex() {
                if (++this.nextIndex == AbstractLoadBalancer.this.maxIndex) {
                    this.nextIndex = 0;
                }
            }
        }
    }
}

