/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.CoreMessages;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.admin.std.server.PasswordModifyExtendedOperationHandlerCfg;
import org.opends.server.api.AuthenticationPolicy;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.IdentityMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.AdditionalLogItem;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class PasswordModifyExtendedOperation
extends ExtendedOperationHandler<PasswordModifyExtendedOperationHandlerCfg>
implements ConfigurationChangeListener<PasswordModifyExtendedOperationHandlerCfg> {
    public static final String AUTHZ_DN_ATTACHMENT;
    public static final String PWD_ATTRIBUTE_ATTACHMENT;
    public static final String CLEAR_PWD_ATTACHMENT;
    public static final String ENCODED_PWD_ATTACHMENT;
    private static final DebugTracer TRACER;
    private PasswordModifyExtendedOperationHandlerCfg currentConfig;
    private DN identityMapperDN;
    private IdentityMapper<?> identityMapper;
    private Set<String> supportedControlOIDs = new HashSet<String>(0);

    @Override
    public void initializeExtendedOperationHandler(PasswordModifyExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        try {
            this.identityMapperDN = config.getIdentityMapperDN();
            this.identityMapper = DirectoryServer.getIdentityMapper(this.identityMapperDN);
            if (this.identityMapper == null) {
                Message message = ExtensionMessages.ERR_EXTOP_PASSMOD_NO_SUCH_ID_MAPPER.get(String.valueOf(this.identityMapperDN), String.valueOf(config.dn()));
                throw new ConfigException(message);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_DETERMINE_ID_MAPPER.get(String.valueOf(config.dn()), StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.supportedControlOIDs = new HashSet<String>();
        this.supportedControlOIDs.add("1.3.6.1.4.1.4203.1.10.2");
        this.supportedControlOIDs.add("1.3.6.1.4.1.42.2.27.8.5.1");
        this.currentConfig = config;
        config.addPasswordModifyChangeListener(this);
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.4203.1.11.1", this);
        this.registerControlsAndFeatures();
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        this.currentConfig.removePasswordModifyChangeListener(this);
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.4203.1.11.1");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public Set<String> getSupportedControls() {
        return this.supportedControlOIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        block157: {
            block158: {
                block159: {
                    block156: {
                        block154: {
                            block155: {
                                block152: {
                                    block153: {
                                        block150: {
                                            block151: {
                                                block147: {
                                                    block148: {
                                                        block149: {
                                                            block145: {
                                                                block146: {
                                                                    block143: {
                                                                        block144: {
                                                                            block141: {
                                                                                block142: {
                                                                                    block139: {
                                                                                        block140: {
                                                                                            block134: {
                                                                                                block138: {
                                                                                                    block136: {
                                                                                                        block137: {
                                                                                                            block133: {
                                                                                                                block135: {
                                                                                                                    block131: {
                                                                                                                        block132: {
                                                                                                                            block129: {
                                                                                                                                block130: {
                                                                                                                                    block127: {
                                                                                                                                        block128: {
                                                                                                                                            block125: {
                                                                                                                                                block126: {
                                                                                                                                                    block123: {
                                                                                                                                                        block124: {
                                                                                                                                                            block122: {
                                                                                                                                                                block121: {
                                                                                                                                                                    block118: {
                                                                                                                                                                        block119: {
                                                                                                                                                                            block120: {
                                                                                                                                                                                block116: {
                                                                                                                                                                                    block117: {
                                                                                                                                                                                        block114: {
                                                                                                                                                                                            block115: {
                                                                                                                                                                                                block112: {
                                                                                                                                                                                                    block113: {
                                                                                                                                                                                                        userIdentity = null;
                                                                                                                                                                                                        oldPassword = null;
                                                                                                                                                                                                        newPassword = null;
                                                                                                                                                                                                        noOpRequested = false;
                                                                                                                                                                                                        pwPolicyRequested = false;
                                                                                                                                                                                                        pwPolicyWarningValue = 0;
                                                                                                                                                                                                        pwPolicyErrorType = null;
                                                                                                                                                                                                        pwPolicyWarningType = null;
                                                                                                                                                                                                        controls = operation.getRequestControls();
                                                                                                                                                                                                        if (controls != null) {
                                                                                                                                                                                                            for (Control c : controls) {
                                                                                                                                                                                                                oid = c.getOID();
                                                                                                                                                                                                                if (oid.equals("1.3.6.1.4.1.4203.1.10.2")) {
                                                                                                                                                                                                                    noOpRequested = true;
                                                                                                                                                                                                                    continue;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                                                                                                                                                                                                                pwPolicyRequested = true;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if ((requestValue = operation.getRequestValue()) != null) {
                                                                                                                                                                                                            try {
                                                                                                                                                                                                                reader = ASN1.getReader(requestValue);
                                                                                                                                                                                                                reader.readStartSequence();
                                                                                                                                                                                                                if (reader.hasNextElement() && reader.peekType() == -128) {
                                                                                                                                                                                                                    userIdentity = reader.readOctetString();
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (reader.hasNextElement() && reader.peekType() == -127) {
                                                                                                                                                                                                                    oldPassword = reader.readOctetString();
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (reader.hasNextElement() && reader.peekType() == -126) {
                                                                                                                                                                                                                    newPassword = reader.readOctetString();
                                                                                                                                                                                                                }
                                                                                                                                                                                                                reader.readEndSequence();
                                                                                                                                                                                                            }
                                                                                                                                                                                                            catch (Exception ae) {
                                                                                                                                                                                                                if (DebugLogger.debugEnabled()) {
                                                                                                                                                                                                                    PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                                                                                                                                                                                                                }
                                                                                                                                                                                                                operation.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                                                                                                                message = ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_DECODE_REQUEST.get(StaticUtils.getExceptionMessage(ae));
                                                                                                                                                                                                                operation.appendErrorMessage(message);
                                                                                                                                                                                                                return;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                        requestorEntry = operation.getAuthorizationEntry();
                                                                                                                                                                                                        userDN = null;
                                                                                                                                                                                                        userEntry = null;
                                                                                                                                                                                                        userLock = null;
                                                                                                                                                                                                        if (userIdentity != null) ** GOTO lbl68
                                                                                                                                                                                                        clientConnection = operation.getClientConnection();
                                                                                                                                                                                                        authInfo = clientConnection.getAuthenticationInfo();
                                                                                                                                                                                                        if (authInfo.isAuthenticated() && requestorEntry != null) break block112;
                                                                                                                                                                                                        operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                                                                                                        operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_NO_AUTH_OR_USERID.get());
                                                                                                                                                                                                        if (userLock == null) break block113;
                                                                                                                                                                                                        LockManager.unlock(userDN, userLock);
                                                                                                                                                                                                    }
                                                                                                                                                                                                    return;
                                                                                                                                                                                                }
                                                                                                                                                                                                userDN = requestorEntry.getDN();
                                                                                                                                                                                                userLock = LockManager.lockWrite(userDN);
                                                                                                                                                                                                if (userLock != null) break block114;
                                                                                                                                                                                                operation.setResultCode(ResultCode.BUSY);
                                                                                                                                                                                                operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_LOCK_USER_ENTRY.get(String.valueOf(userDN)));
                                                                                                                                                                                                if (userLock == null) break block115;
                                                                                                                                                                                                LockManager.unlock(userDN, userLock);
                                                                                                                                                                                            }
                                                                                                                                                                                            return;
                                                                                                                                                                                        }
                                                                                                                                                                                        userEntry = requestorEntry;
                                                                                                                                                                                        ** GOTO lbl150
lbl68:
                                                                                                                                                                                        // 1 sources

                                                                                                                                                                                        authzIDStr = userIdentity.toString();
                                                                                                                                                                                        lowerAuthzIDStr = StaticUtils.toLowerCase(authzIDStr);
                                                                                                                                                                                        if (!lowerAuthzIDStr.startsWith("dn:")) ** GOTO lbl94
                                                                                                                                                                                        try {
                                                                                                                                                                                            userDN = DN.decode(authzIDStr.substring(3));
                                                                                                                                                                                        }
                                                                                                                                                                                        catch (DirectoryException de) {
                                                                                                                                                                                            if (DebugLogger.debugEnabled()) {
                                                                                                                                                                                                PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                                                                            }
                                                                                                                                                                                            operation.setResultCode(ResultCode.INVALID_DN_SYNTAX);
                                                                                                                                                                                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_DECODE_AUTHZ_DN.get(authzIDStr));
                                                                                                                                                                                            if (userLock != null) {
                                                                                                                                                                                                LockManager.unlock(userDN, userLock);
                                                                                                                                                                                            }
                                                                                                                                                                                            return;
                                                                                                                                                                                        }
                                                                                                                                                                                        actualRootDN = DirectoryServer.getActualRootBindDN(userDN);
                                                                                                                                                                                        if (actualRootDN != null) {
                                                                                                                                                                                            userDN = actualRootDN;
                                                                                                                                                                                        }
                                                                                                                                                                                        if ((userEntry = this.getEntryByDN(operation, userDN)) != null) break block116;
                                                                                                                                                                                        if (userLock == null) break block117;
                                                                                                                                                                                        LockManager.unlock(userDN, userLock);
                                                                                                                                                                                    }
                                                                                                                                                                                    return;
                                                                                                                                                                                }
                                                                                                                                                                                ** GOTO lbl150
lbl94:
                                                                                                                                                                                // 1 sources

                                                                                                                                                                                if (!lowerAuthzIDStr.startsWith("u:")) break block118;
                                                                                                                                                                                userEntry = this.identityMapper.getEntryForID(authzIDStr.substring(2));
                                                                                                                                                                                if (userEntry != null) break block119;
                                                                                                                                                                                operation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                                                                                                                                                                                operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_MAP_USER.get(authzIDStr));
                                                                                                                                                                                if (userLock == null) break block120;
                                                                                                                                                                                LockManager.unlock(userDN, userLock);
                                                                                                                                                                            }
                                                                                                                                                                            return;
                                                                                                                                                                        }
                                                                                                                                                                        userDN = userEntry.getDN();
                                                                                                                                                                        ** GOTO lbl150
                                                                                                                                                                        {
                                                                                                                                                                            catch (DirectoryException de) {
                                                                                                                                                                                if (DebugLogger.debugEnabled()) {
                                                                                                                                                                                    PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                                                                }
                                                                                                                                                                                operation.setResultCode(de.getResultCode());
                                                                                                                                                                                operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_ERROR_MAPPING_USER.get(authzIDStr, de.getMessageObject()));
                                                                                                                                                                                if (userLock != null) {
                                                                                                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                                                                                                }
                                                                                                                                                                                return;
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                    try {
                                                                                                                                                                        userDN = DN.decode(authzIDStr);
                                                                                                                                                                    }
                                                                                                                                                                    catch (DirectoryException de) {
                                                                                                                                                                        if (!DebugLogger.debugEnabled()) break block121;
                                                                                                                                                                        PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                if (userDN != null && !userDN.isNullDN()) {
                                                                                                                                                                    actualRootDN = DirectoryServer.getActualRootBindDN(userDN);
                                                                                                                                                                    if (actualRootDN != null) {
                                                                                                                                                                        userDN = actualRootDN;
                                                                                                                                                                    }
                                                                                                                                                                    userEntry = this.getEntryByDN(operation, userDN);
                                                                                                                                                                } else {
                                                                                                                                                                    try {
                                                                                                                                                                        userEntry = this.identityMapper.getEntryForID(authzIDStr);
                                                                                                                                                                    }
                                                                                                                                                                    catch (DirectoryException de) {
                                                                                                                                                                        if (!DebugLogger.debugEnabled()) break block122;
                                                                                                                                                                        PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            if (userEntry != null) break block123;
                                                                                                                                                            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
                                                                                                                                                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_INVALID_AUTHZID_STRING.get(authzIDStr));
                                                                                                                                                            if (userLock == null) break block124;
                                                                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                                                                        }
                                                                                                                                                        return;
                                                                                                                                                    }
                                                                                                                                                    userDN = userEntry.getDN();
lbl150:
                                                                                                                                                    // 5 sources

                                                                                                                                                    policy = AuthenticationPolicy.forUser(userEntry, false);
                                                                                                                                                    if (policy.isPasswordPolicy()) break block125;
                                                                                                                                                    operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                                                    operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_ACCOUNT_NOT_LOCAL.get(String.valueOf(userDN)));
                                                                                                                                                    if (userLock == null) break block126;
                                                                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                                                                }
                                                                                                                                                return;
                                                                                                                                            }
                                                                                                                                            pwPolicyState = (PasswordPolicyState)policy.createAuthenticationPolicyState(userEntry);
                                                                                                                                            {
                                                                                                                                                catch (DirectoryException de) {
                                                                                                                                                    if (DebugLogger.debugEnabled()) {
                                                                                                                                                        PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                                                                                                                    }
                                                                                                                                                    operation.setResultCode(DirectoryServer.getServerErrorResultCode());
                                                                                                                                                    operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_GET_PW_POLICY.get(String.valueOf(userDN), de.getMessageObject()));
                                                                                                                                                    if (userLock != null) {
                                                                                                                                                        LockManager.unlock(userDN, userLock);
                                                                                                                                                    }
                                                                                                                                                    return;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            selfChange = userIdentity == null ? true : (requestorEntry == null ? oldPassword != null : userDN.equals(requestorEntry.getDN()));
                                                                                                                                            if (selfChange || (clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.PASSWORD_RESET, operation)) break block127;
                                                                                                                                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_INSUFFICIENT_PRIVILEGES.get());
                                                                                                                                            operation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
                                                                                                                                            if (userLock == null) break block128;
                                                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                                                        }
                                                                                                                                        return;
                                                                                                                                    }
                                                                                                                                    if (!pwPolicyState.isDisabled()) break block129;
                                                                                                                                    if (pwPolicyRequested) {
                                                                                                                                        pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                                                                                                                                        operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                                                                    }
                                                                                                                                    message = ExtensionMessages.ERR_EXTOP_PASSMOD_ACCOUNT_DISABLED.get();
                                                                                                                                    operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                                    operation.appendErrorMessage(message);
                                                                                                                                    if (userLock == null) break block130;
                                                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                                                }
                                                                                                                                return;
                                                                                                                            }
                                                                                                                            if (!selfChange || !pwPolicyState.lockedDueToFailures() && !pwPolicyState.lockedDueToIdleInterval() && !pwPolicyState.lockedDueToMaximumResetAge()) break block131;
                                                                                                                            if (pwPolicyRequested) {
                                                                                                                                pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                                                                                                                                operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                                                            }
                                                                                                                            message = ExtensionMessages.ERR_EXTOP_PASSMOD_ACCOUNT_LOCKED.get();
                                                                                                                            operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                            operation.appendErrorMessage(message);
                                                                                                                            if (userLock == null) break block132;
                                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                                        }
                                                                                                                        return;
                                                                                                                    }
                                                                                                                    if (oldPassword != null) break block133;
                                                                                                                    if (!selfChange || !pwPolicyState.getAuthenticationPolicy().isPasswordChangeRequiresCurrentPassword()) break block134;
                                                                                                                    operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                                                    operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_REQUIRE_CURRENT_PW.get());
                                                                                                                    if (pwPolicyRequested) {
                                                                                                                        pwPolicyErrorType = PasswordPolicyErrorType.MUST_SUPPLY_OLD_PASSWORD;
                                                                                                                        operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                                                    }
                                                                                                                    if (userLock == null) break block135;
                                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                                }
                                                                                                                return;
                                                                                                            }
                                                                                                            if (!pwPolicyState.getAuthenticationPolicy().isRequireSecureAuthentication() || operation.getClientConnection().isSecure()) break block136;
                                                                                                            operation.setResultCode(ResultCode.CONFIDENTIALITY_REQUIRED);
                                                                                                            operation.addAdditionalLogItem(AdditionalLogItem.quotedKeyValue(this.getClass(), "additionalInfo", ExtensionMessages.ERR_EXTOP_PASSMOD_SECURE_AUTH_REQUIRED.get()));
                                                                                                            if (userLock == null) break block137;
                                                                                                            LockManager.unlock(userDN, userLock);
                                                                                                        }
                                                                                                        return;
                                                                                                    }
                                                                                                    if (pwPolicyState.passwordMatches(oldPassword)) {
                                                                                                        pwPolicyState.setLastLoginTime();
                                                                                                        break block134;
                                                                                                    }
                                                                                                    operation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                                                                                                    operation.addAdditionalLogItem(AdditionalLogItem.quotedKeyValue(this.getClass(), "additionalInfo", ExtensionMessages.ERR_EXTOP_PASSMOD_INVALID_OLD_PASSWORD.get()));
                                                                                                    pwPolicyState.updateAuthFailureTimes();
                                                                                                    mods = pwPolicyState.getModifications();
                                                                                                    if (!mods.isEmpty()) {
                                                                                                        conn = InternalClientConnection.getRootConnection();
                                                                                                        conn.processModify(userDN, mods);
                                                                                                    }
                                                                                                    if (userLock == null) break block138;
                                                                                                    LockManager.unlock(userDN, userLock);
                                                                                                }
                                                                                                return;
                                                                                            }
                                                                                            if (!selfChange || pwPolicyState.getAuthenticationPolicy().isAllowUserPasswordChanges()) break block139;
                                                                                            if (pwPolicyRequested) {
                                                                                                pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                                                                                                operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                                            }
                                                                                            operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_USER_PW_CHANGES_NOT_ALLOWED.get());
                                                                                            if (userLock == null) break block140;
                                                                                            LockManager.unlock(userDN, userLock);
                                                                                        }
                                                                                        return;
                                                                                    }
                                                                                    if (!pwPolicyState.getAuthenticationPolicy().isRequireSecurePasswordChanges() || operation.getClientConnection().isSecure()) break block141;
                                                                                    operation.setResultCode(ResultCode.CONFIDENTIALITY_REQUIRED);
                                                                                    operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_SECURE_CHANGES_REQUIRED.get());
                                                                                    if (userLock == null) break block142;
                                                                                    LockManager.unlock(userDN, userLock);
                                                                                }
                                                                                return;
                                                                            }
                                                                            if (!selfChange || !pwPolicyState.isWithinMinimumAge()) break block143;
                                                                            if (pwPolicyRequested) {
                                                                                pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_TOO_YOUNG;
                                                                                operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                            }
                                                                            operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_IN_MIN_AGE.get());
                                                                            if (userLock == null) break block144;
                                                                            LockManager.unlock(userDN, userLock);
                                                                        }
                                                                        return;
                                                                    }
                                                                    if (!selfChange || !pwPolicyState.isPasswordExpired() || pwPolicyState.getAuthenticationPolicy().isAllowExpiredPasswordChanges()) break block145;
                                                                    if (pwPolicyRequested) {
                                                                        pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                                                                        operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                                                    }
                                                                    operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                                    operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_PASSWORD_IS_EXPIRED.get());
                                                                    if (userLock == null) break block146;
                                                                    LockManager.unlock(userDN, userLock);
                                                                }
                                                                return;
                                                            }
                                                            generatedPassword = false;
                                                            isPreEncoded = false;
                                                            if (newPassword != null) break block147;
                                                            newPassword = pwPolicyState.generatePassword();
                                                            if (newPassword != null) break block148;
                                                            operation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                                                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_NO_PW_GENERATOR.get());
                                                            if (userLock == null) break block149;
                                                            LockManager.unlock(userDN, userLock);
                                                        }
                                                        return;
                                                    }
                                                    generatedPassword = true;
                                                    ** GOTO lbl367
                                                    {
                                                        catch (DirectoryException de) {
                                                            if (DebugLogger.debugEnabled()) {
                                                                PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                                            }
                                                            operation.setResultCode(de.getResultCode());
                                                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_GENERATE_PW.get(de.getMessageObject()));
                                                            if (userLock != null) {
                                                                LockManager.unlock(userDN, userLock);
                                                            }
                                                            return;
                                                        }
                                                    }
                                                }
                                                if (!pwPolicyState.passwordIsPreEncoded(newPassword)) break block150;
                                                isPreEncoded = true;
                                                if (pwPolicyState.getAuthenticationPolicy().isAllowPreEncodedPasswords()) ** GOTO lbl367
                                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                                operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_PRE_ENCODED_NOT_ALLOWED.get());
                                                if (userLock == null) break block151;
                                                LockManager.unlock(userDN, userLock);
                                            }
                                            return;
                                        }
                                        if (!selfChange && pwPolicyState.getAuthenticationPolicy().isSkipValidationForAdministrators()) break block152;
                                        if (oldPassword == null) {
                                            clearPasswords = new HashSet<ByteString>(pwPolicyState.getClearPasswords());
                                        } else {
                                            clearPasswords = new HashSet<ByteString>();
                                            clearPasswords.add(oldPassword);
                                            for (ByteString pw : pwPolicyState.getClearPasswords()) {
                                                if (pw.equals(oldPassword)) continue;
                                                clearPasswords.add(pw);
                                            }
                                        }
                                        invalidReason = new MessageBuilder();
                                        if (pwPolicyState.passwordIsAcceptable(operation, userEntry, newPassword, clearPasswords, invalidReason)) break block152;
                                        if (pwPolicyRequested) {
                                            pwPolicyErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                                            operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
                                        }
                                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                        operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_UNACCEPTABLE_PW.get(String.valueOf(invalidReason)));
                                        if (userLock == null) break block153;
                                        LockManager.unlock(userDN, userLock);
                                    }
                                    return;
                                }
                                if (!pwPolicyState.maintainHistory()) ** GOTO lbl367
                                if (!pwPolicyState.isPasswordInHistory(newPassword)) break block154;
                                if (!selfChange && pwPolicyState.getAuthenticationPolicy().isSkipValidationForAdministrators()) ** GOTO lbl367
                                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                                operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_PW_IN_HISTORY.get());
                                if (userLock == null) break block155;
                                LockManager.unlock(userDN, userLock);
                            }
                            return;
                        }
                        pwPolicyState.updatePasswordHistory();
lbl367:
                        // 5 sources

                        if (isPreEncoded) {
                            encodedPasswords = new ArrayList<E>(1);
                            encodedPasswords.add(newPassword);
                            break block156;
                        }
                        try {
                            encodedPasswords = pwPolicyState.encodePassword(newPassword);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            operation.setResultCode(de.getResultCode());
                            operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_ENCODE_PASSWORD.get(de.getMessageObject()));
                            if (userLock != null) {
                                LockManager.unlock(userDN, userLock);
                            }
                            return;
                        }
                    }
                    try {
                        attrType = pwPolicyState.getAuthenticationPolicy().getPasswordAttribute();
                        modList = new ArrayList<Modification>();
                        if (oldPassword != null) {
                            existingValues = pwPolicyState.getPasswordValues();
                            deleteValues = new LinkedHashSet<AttributeValue>(existingValues.size());
                            if (pwPolicyState.getAuthenticationPolicy().isAuthPasswordSyntax()) {
                                for (AttributeValue v : existingValues) {
                                    try {
                                        components = AuthPasswordSyntax.decodeAuthPassword(v.getValue().toString());
                                        scheme = DirectoryServer.getAuthPasswordStorageScheme(components[0].toString());
                                        if (scheme == null) {
                                            deleteValues.add(v);
                                            continue;
                                        }
                                        if (!scheme.authPasswordMatches(oldPassword, components[1].toString(), components[2].toString())) continue;
                                        deleteValues.add(v);
                                    }
                                    catch (DirectoryException de) {
                                        if (DebugLogger.debugEnabled()) {
                                            PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                        }
                                        deleteValues.add(v);
                                    }
                                }
                            } else {
                                for (AttributeValue v : existingValues) {
                                    try {
                                        components = UserPasswordSyntax.decodeUserPassword(v.getValue().toString());
                                        scheme = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase((String)components[0]));
                                        if (scheme == null) {
                                            deleteValues.add(v);
                                            continue;
                                        }
                                        if (!scheme.passwordMatches(oldPassword, ByteString.valueOf((String)components[1]))) continue;
                                        deleteValues.add(v);
                                    }
                                    catch (DirectoryException de) {
                                        if (DebugLogger.debugEnabled()) {
                                            PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                        }
                                        deleteValues.add(v);
                                    }
                                }
                            }
                            builder = new AttributeBuilder(attrType);
                            builder.addAll(deleteValues);
                            deleteAttr = builder.toAttribute();
                            modList.add(new Modification(ModificationType.DELETE, deleteAttr));
                            builder = new AttributeBuilder(attrType);
                            builder.addAll(this.toAttributeValues(attrType, encodedPasswords));
                            addAttr = builder.toAttribute();
                            modList.add(new Modification(ModificationType.ADD, addAttr));
                        } else {
                            builder = new AttributeBuilder(attrType);
                            builder.addAll(this.toAttributeValues(attrType, encodedPasswords));
                            addAttr = builder.toAttribute();
                            modList.add(new Modification(ModificationType.REPLACE, addAttr));
                        }
                        pwPolicyState.setPasswordChangedTime();
                        if (selfChange) {
                            pwPolicyState.setMustChangePassword(false);
                        } else {
                            pwPolicyState.setMustChangePassword(pwPolicyState.getAuthenticationPolicy().isForceChangeOnReset());
                        }
                        pwPolicyState.clearFailureLockout();
                        pwPolicyState.clearGraceLoginTimes();
                        pwPolicyState.clearWarnedTime();
                        if (noOpRequested) {
                            operation.appendErrorMessage(ExtensionMessages.WARN_EXTOP_PASSMOD_NOOP.get());
                            operation.setResultCode(ResultCode.NO_OPERATION);
                            break block157;
                        }
                        if (selfChange && requestorEntry == null) {
                            requestorEntry = userEntry;
                        }
                        if ((resultCode = (modifyOperation = (internalConnection = new InternalClientConnection(authInfo = new AuthenticationInfo(requestorEntry, isRoot = DirectoryServer.isRootDN(requestorEntry.getDN())))).processModify(userDN, modList)).getResultCode()) == ResultCode.SUCCESS) break block158;
                        operation.setResultCode(resultCode);
                        operation.setErrorMessage(modifyOperation.getErrorMessage());
                        operation.setReferralURLs(modifyOperation.getReferralURLs());
                        if (userLock == null) break block159;
                    }
                    catch (Throwable var32_47) {
                        if (userLock != null) {
                            LockManager.unlock(userDN, userLock);
                        }
                        throw var32_47;
                    }
                    LockManager.unlock(userDN, userLock);
                }
                return;
            }
            pwPolicyMods = pwPolicyState.getModifications();
            if (!pwPolicyMods.isEmpty() && (modOp = (rootConnection = InternalClientConnection.getRootConnection()).processModify(userDN, pwPolicyMods)).getResultCode() != ResultCode.SUCCESS) {
                message = ExtensionMessages.WARN_EXTOP_PASSMOD_CANNOT_UPDATE_PWP_STATE.get(String.valueOf(userDN), String.valueOf((Object)modOp.getResultCode()), modOp.getErrorMessage());
                ErrorLogger.logError(message);
            }
            operation.setResultCode(ResultCode.SUCCESS);
            operation.setAttachment(PasswordModifyExtendedOperation.AUTHZ_DN_ATTACHMENT, userDN);
            operation.setAttachment(PasswordModifyExtendedOperation.PWD_ATTRIBUTE_ATTACHMENT, pwPolicyState.getAuthenticationPolicy().getPasswordAttribute());
            if (!isPreEncoded) {
                operation.setAttachment(PasswordModifyExtendedOperation.CLEAR_PWD_ATTACHMENT, newPassword);
            }
            operation.setAttachment(PasswordModifyExtendedOperation.ENCODED_PWD_ATTACHMENT, encodedPasswords);
            if (generatedPassword) {
                builder = new ByteStringBuilder();
                writer = ASN1.getWriter(builder);
                try {
                    writer.writeStartSequence();
                    writer.writeOctetString((byte)-128, newPassword);
                    writer.writeEndSequence();
                }
                catch (Exception e) {
                    PasswordModifyExtendedOperation.TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                operation.setResponseValue(builder.toByteString());
            }
            if (selfChange && authInfo.getAuthenticationDN() != null && authInfo.getAuthenticationDN().equals(userDN)) {
                operation.getClientConnection().setMustChangePassword(false);
            }
            if (pwPolicyRequested) {
                operation.addResponseControl(new PasswordPolicyResponseControl(pwPolicyWarningType, pwPolicyWarningValue, pwPolicyErrorType));
            }
            currentPasswords = null;
            if (oldPassword != null) {
                currentPasswords = new ArrayList<AttributeValue>(1);
                currentPasswords.add(AttributeValues.create(oldPassword, oldPassword));
            }
            newPasswords = null;
            if (newPassword != null) {
                newPasswords = new ArrayList<AttributeValue>(1);
                newPasswords.add(AttributeValues.create(newPassword, newPassword));
            }
            if (selfChange) {
                message = CoreMessages.INFO_MODIFY_PASSWORD_CHANGED.get();
                pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_CHANGED, userEntry, message, AccountStatusNotification.createProperties(pwPolicyState, false, -1, currentPasswords, newPasswords));
                break block157;
            }
            message = CoreMessages.INFO_MODIFY_PASSWORD_RESET.get();
            pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_RESET, userEntry, message, AccountStatusNotification.createProperties(pwPolicyState, false, -1, currentPasswords, newPasswords));
        }
        if (userLock != null) {
            LockManager.unlock(userDN, userLock);
        }
    }

    private Collection<AttributeValue> toAttributeValues(AttributeType attrType, Collection<ByteString> values) {
        LinkedHashSet<AttributeValue> results = new LinkedHashSet<AttributeValue>(values.size());
        for (ByteString s : values) {
            results.add(AttributeValues.create(attrType, s));
        }
        return results;
    }

    private Entry getEntryByDN(ExtendedOperation operation, DN entryDN) {
        try {
            Entry userEntry = DirectoryServer.getEntry(entryDN);
            if (userEntry == null) {
                operation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                operation.appendErrorMessage(ExtensionMessages.ERR_EXTOP_PASSMOD_NO_USER_ENTRY_BY_AUTHZID.get(String.valueOf(entryDN)));
                for (DN parentDN = entryDN.getParentDNInSuffix(); parentDN != null; parentDN = parentDN.getParentDNInSuffix()) {
                    try {
                        if (!DirectoryServer.entryExists(parentDN)) continue;
                        operation.setMatchedDN(parentDN);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    break;
                }
                return null;
            }
            return userEntry;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            operation.setResultCode(de.getResultCode());
            operation.appendErrorMessage(de.getMessageObject());
            operation.setMatchedDN(de.getMatchedDN());
            operation.setReferralURLs(de.getReferralURLs());
            return null;
        }
    }

    @Override
    public boolean isConfigurationAcceptable(ExtendedOperationHandlerCfg configuration, List<Message> unacceptableReasons) {
        PasswordModifyExtendedOperationHandlerCfg config = (PasswordModifyExtendedOperationHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordModifyExtendedOperationHandlerCfg config, List<Message> unacceptableReasons) {
        try {
            DN mapperDN = config.getIdentityMapperDN();
            IdentityMapper mapper = DirectoryServer.getIdentityMapper(mapperDN);
            if (mapper == null) {
                Message message = ExtensionMessages.ERR_EXTOP_PASSMOD_NO_SUCH_ID_MAPPER.get(String.valueOf(mapperDN), String.valueOf(config.dn()));
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_DETERMINE_ID_MAPPER.get(String.valueOf(config.dn()), StaticUtils.getExceptionMessage(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordModifyExtendedOperationHandlerCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN mapperDN = null;
        IdentityMapper mapper = null;
        try {
            mapperDN = config.getIdentityMapperDN();
            mapper = DirectoryServer.getIdentityMapper(mapperDN);
            if (mapper == null) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                messages.add(ExtensionMessages.ERR_EXTOP_PASSMOD_NO_SUCH_ID_MAPPER.get(String.valueOf(mapperDN), String.valueOf(config.dn())));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(ExtensionMessages.ERR_EXTOP_PASSMOD_CANNOT_DETERMINE_ID_MAPPER.get(String.valueOf(config.dn()), StaticUtils.getExceptionMessage(e)));
        }
        if (resultCode == ResultCode.SUCCESS && !this.identityMapperDN.equals(mapperDN)) {
            this.identityMapper = mapper;
            this.identityMapperDN = mapperDN;
        }
        this.currentConfig = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public String getExtendedOperationName() {
        return "Password Modify";
    }

    static {
        String PREFIX = PasswordModifyExtendedOperation.class.getName();
        AUTHZ_DN_ATTACHMENT = PREFIX + ".AUTHZ_DN";
        PWD_ATTRIBUTE_ATTACHMENT = PREFIX + ".PWD_ATTRIBUTE";
        CLEAR_PWD_ATTACHMENT = PREFIX + ".CLEAR_PWD";
        ENCODED_PWD_ATTACHMENT = PREFIX + ".ENCODED_PWD";
        TRACER = DebugLogger.getTracer();
    }
}

