/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileBasedAuditLogPublisherCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.AbstractTextAccessLogPublisher;
import org.opends.server.loggers.AsynchronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public final class TextAuditLogPublisher
extends AbstractTextAccessLogPublisher<FileBasedAuditLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedAuditLogPublisherCfg> {
    private TextWriter writer;
    private FileBasedAuditLogPublisherCfg cfg;

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedAuditLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsynchronousTextWriter ? ((AsynchronousTextWriter)this.writer).getWrappedWriter() : this.writer;
            if (currentWriter instanceof MultifileTextWriter) {
                MultifileTextWriter mfWriter = (MultifileTextWriter)currentWriter;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDNs()) {
                    mfWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
                }
                for (DN dn : config.getRetentionPolicyDNs()) {
                    mfWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
                }
                if (this.writer instanceof AsynchronousTextWriter && !config.isAsynchronous()) {
                    AsynchronousTextWriter asyncWriter = (AsynchronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    asyncWriter.shutdown(false);
                }
                if (!(this.writer instanceof AsynchronousTextWriter) && config.isAsynchronous()) {
                    this.writer = new AsynchronousTextWriter("Asynchronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                }
                if (this.cfg.isAsynchronous() && config.isAsynchronous() && this.cfg.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.cfg = config;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    protected void close0() {
        this.writer.shutdown();
        this.cfg.removeFileBasedAuditChangeListener(this);
    }

    @Override
    public void initializeLogPublisher(FileBasedAuditLogPublisherCfg cfg) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(cfg.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(cfg.getLogFilePermissions());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(cfg.dn());
            boolean writerAutoFlush = cfg.isAutoFlush() && !cfg.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + cfg.dn().toNormalizedString(), cfg.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, cfg.isAppend(), (int)cfg.getBufferSize());
            for (DN dn : cfg.getRotationPolicyDNs()) {
                writer.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
            }
            for (DN dn : cfg.getRetentionPolicyDNs()) {
                writer.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
            }
            this.writer = cfg.isAsynchronous() ? new AsynchronousTextWriter("Asynchronous Text Writer for " + cfg.dn().toNormalizedString(), cfg.getQueueSize(), cfg.isAutoFlush(), writer) : writer;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(cfg.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_OPEN_FILE.get(logFile.toString(), cfg.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.initializeFilters(cfg);
        this.cfg = cfg;
        cfg.addFileBasedAuditChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(FileBasedAuditLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        return this.isFilterConfigurationAcceptable(configuration, unacceptableReasons) && this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedAuditLogPublisherCfg config, List<Message> unacceptableReasons) {
        try {
            FilePermission filePerm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            if (!filePerm.isOwnerWritable()) {
                Message message = ConfigMessages.ERR_CONFIG_LOGGING_INSANE_MODE.get(config.getLogFilePermissions());
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_MODE_INVALID.get(config.getLogFilePermissions(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public void logAddResponse(AddOperation addOperation) {
        if (!this.isLoggable(addOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        this.appendHeader(addOperation, buffer);
        buffer.append("dn:");
        this.encodeValue(addOperation.getEntryDN().toString(), buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("changetype: add");
        buffer.append(ServerConstants.EOL);
        for (String string : addOperation.getObjectClasses().values()) {
            buffer.append("objectClass: ");
            buffer.append(string);
            buffer.append(ServerConstants.EOL);
        }
        for (List list : addOperation.getUserAttributes().values()) {
            for (Attribute a : list) {
                for (AttributeValue v : a) {
                    buffer.append(a.getName());
                    buffer.append(":");
                    this.encodeValue(v.getValue(), buffer);
                    buffer.append(ServerConstants.EOL);
                }
            }
        }
        for (List list : addOperation.getOperationalAttributes().values()) {
            for (Attribute a : list) {
                for (AttributeValue v : a) {
                    buffer.append(a.getName());
                    buffer.append(":");
                    this.encodeValue(v.getValue(), buffer);
                    buffer.append(ServerConstants.EOL);
                }
            }
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDeleteResponse(DeleteOperation deleteOperation) {
        if (!this.isLoggable(deleteOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        this.appendHeader(deleteOperation, buffer);
        buffer.append("dn:");
        this.encodeValue(deleteOperation.getEntryDN().toString(), buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("changetype: delete");
        buffer.append(ServerConstants.EOL);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        if (!this.isLoggable(modifyDNOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        this.appendHeader(modifyDNOperation, buffer);
        buffer.append("dn:");
        this.encodeValue(modifyDNOperation.getEntryDN().toString(), buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("changetype: moddn");
        buffer.append(ServerConstants.EOL);
        buffer.append("newrdn:");
        this.encodeValue(modifyDNOperation.getNewRDN().toString(), buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("deleteoldrdn: ");
        if (modifyDNOperation.deleteOldRDN()) {
            buffer.append("1");
        } else {
            buffer.append("0");
        }
        buffer.append(ServerConstants.EOL);
        DN newSuperior = modifyDNOperation.getNewSuperior();
        if (newSuperior != null) {
            buffer.append("newsuperior:");
            this.encodeValue(newSuperior.toString(), buffer);
            buffer.append(ServerConstants.EOL);
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyResponse(ModifyOperation modifyOperation) {
        if (!this.isLoggable(modifyOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(50);
        this.appendHeader(modifyOperation, buffer);
        buffer.append("dn:");
        this.encodeValue(modifyOperation.getEntryDN().toString(), buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("changetype: modify");
        buffer.append(ServerConstants.EOL);
        boolean first = true;
        block6: for (Modification mod : modifyOperation.getModifications()) {
            if (first) {
                first = false;
            } else {
                buffer.append("-");
                buffer.append(ServerConstants.EOL);
            }
            switch (mod.getModificationType()) {
                case ADD: {
                    buffer.append("add: ");
                    break;
                }
                case DELETE: {
                    buffer.append("delete: ");
                    break;
                }
                case REPLACE: {
                    buffer.append("replace: ");
                    break;
                }
                case INCREMENT: {
                    buffer.append("increment: ");
                    break;
                }
                default: {
                    continue block6;
                }
            }
            Attribute a = mod.getAttribute();
            buffer.append(a.getName());
            buffer.append(ServerConstants.EOL);
            for (AttributeValue v : a) {
                buffer.append(a.getName());
                buffer.append(":");
                this.encodeValue(v.getValue(), buffer);
                buffer.append(ServerConstants.EOL);
            }
        }
        this.writer.writeRecord(buffer.toString());
    }

    private void appendHeader(Operation operation, StringBuilder buffer) {
        buffer.append("# ");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("; conn=");
        buffer.append(operation.getConnectionID());
        buffer.append("; op=");
        buffer.append(operation.getOperationID());
        buffer.append(ServerConstants.EOL);
    }

    private void encodeValue(ByteSequence str, StringBuilder buffer) {
        if (StaticUtils.needsBase64Encoding(str)) {
            buffer.append(": ");
            buffer.append(Base64.encode(str));
        } else {
            buffer.append(" ");
            buffer.append(((Object)str).toString());
        }
    }

    private void encodeValue(String str, StringBuilder buffer) {
        if (StaticUtils.needsBase64Encoding(str)) {
            buffer.append(": ");
            buffer.append(Base64.encode(StaticUtils.getBytes(str)));
        } else {
            buffer.append(" ");
            buffer.append(str);
        }
    }

    private boolean isLoggable(Operation operation) {
        if (operation.getResultCode() != ResultCode.SUCCESS) {
            return false;
        }
        return this.isResponseLoggable(operation);
    }
}

