/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.opends.server.loggers.MeteredStream;

public interface TextWriter {
    public void writeRecord(String var1);

    public void flush();

    public void shutdown();

    public long getBytesWritten();

    public static class STREAM
    implements TextWriter {
        private MeteredStream stream;
        private PrintWriter writer;

        public STREAM(OutputStream outputStream) {
            this.stream = new MeteredStream(outputStream, 0L);
            this.writer = new PrintWriter(this.stream, true);
        }

        @Override
        public void writeRecord(String record) {
            this.writer.println(record);
        }

        @Override
        public void flush() {
            this.writer.flush();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public long getBytesWritten() {
            return this.stream.written;
        }
    }

    public static class STDERR
    implements TextWriter {
        private MeteredStream stream = new MeteredStream(System.err, 0L);
        private PrintWriter writer = new PrintWriter(this.stream, true);

        @Override
        public void writeRecord(String record) {
            this.writer.println(record);
        }

        @Override
        public void flush() {
            this.writer.flush();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public long getBytesWritten() {
            return this.stream.written;
        }
    }

    public static class STDOUT
    implements TextWriter {
        private MeteredStream stream = new MeteredStream(System.out, 0L);
        private PrintWriter writer = new PrintWriter(this.stream, true);

        @Override
        public void writeRecord(String record) {
            this.writer.println(record);
        }

        @Override
        public void flush() {
            this.writer.flush();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public long getBytesWritten() {
            return this.stream.written;
        }
    }
}

