/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.HostPort;
import org.opends.server.types.ObjectClass;

public class ConnectionHandlerMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private AttributeType connectionsType;
    private AttributeType listenerType;
    private AttributeType numConnectionsType;
    private AttributeType protocolType;
    private AttributeType configDnType;
    private ConnectionHandler<?> connectionHandler;
    private String monitorName;

    public ConnectionHandlerMonitor(ConnectionHandler<? extends ConnectionHandlerCfg> connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) {
        this.monitorName = this.connectionHandler.getConnectionHandlerName();
        this.connectionsType = DirectoryConfig.getAttributeType("ds-connectionhandler-connection", true);
        this.listenerType = DirectoryConfig.getAttributeType("ds-connectionhandler-listener", true);
        this.numConnectionsType = DirectoryConfig.getAttributeType("ds-connectionhandler-num-connections", true);
        this.protocolType = DirectoryConfig.getAttributeType("ds-connectionhandler-protocol", true);
        this.configDnType = DirectoryConfig.getAttributeType("ds-mon-config-dn", true);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.monitorName;
    }

    @Override
    public ObjectClass getMonitorObjectClass() {
        return DirectoryConfig.getObjectClass("ds-connectionhandler-monitor-entry", true);
    }

    @Override
    public List<Attribute> getMonitorData() {
        AttributeBuilder builder;
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        attrs.add(Attributes.create(this.configDnType, String.valueOf(this.connectionHandler.getComponentEntryDN().toNormalizedString())));
        int numConnections = 0;
        LinkedList<ClientConnection> conns = new LinkedList<ClientConnection>(this.connectionHandler.getClientConnections());
        LinkedList<HostPort> listeners = new LinkedList<HostPort>(this.connectionHandler.getListeners());
        attrs.add(Attributes.create(this.protocolType, this.connectionHandler.getProtocol()));
        if (!listeners.isEmpty()) {
            builder = new AttributeBuilder(this.listenerType);
            for (HostPort hp : listeners) {
                builder.add(AttributeValues.create(this.listenerType, hp.toString()));
            }
            attrs.add(builder.toAttribute());
        }
        if (!conns.isEmpty()) {
            builder = new AttributeBuilder(this.connectionsType);
            for (ClientConnection c : conns) {
                ++numConnections;
                builder.add(AttributeValues.create(this.connectionsType, c.getMonitorSummary()));
            }
            attrs.add(builder.toAttribute());
        }
        attrs.add(Attributes.create(this.numConnectionsType, String.valueOf(numConnections)));
        return attrs;
    }
}

