/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.LDAPAttributeDescriptionListPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.util.StaticUtils;

public final class LDAPADListPlugin
extends DirectoryServerPlugin<LDAPAttributeDescriptionListPluginCfg>
implements ConfigurationChangeListener<LDAPAttributeDescriptionListPluginCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private LDAPAttributeDescriptionListPluginCfg currentConfig;

    public static Set<String> normalizedObjectClasses(Set<String> attributes) {
        boolean foundOC = false;
        for (String attrName : attributes) {
            if (!attrName.startsWith("@")) continue;
            foundOC = true;
            break;
        }
        if (foundOC) {
            LinkedHashSet<String> newAttrs = new LinkedHashSet<String>();
            for (String attrName : attributes) {
                if (attrName.startsWith("@")) {
                    String lowerName = StaticUtils.toLowerCase(attrName.substring(1));
                    ObjectClass oc = DirectoryConfig.getObjectClass(lowerName, false);
                    if (oc == null) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugWarning("Cannot replace unknown objectclass %s", lowerName);
                        continue;
                    }
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Replacing objectclass %s", lowerName);
                    }
                    for (AttributeType at : oc.getRequiredAttributeChain()) {
                        newAttrs.add(at.getNameOrOID());
                    }
                    for (AttributeType at : oc.getOptionalAttributeChain()) {
                        newAttrs.add(at.getNameOrOID());
                    }
                    continue;
                }
                newAttrs.add(attrName);
            }
            attributes = newAttrs;
        }
        return attributes;
    }

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, LDAPAttributeDescriptionListPluginCfg configuration) throws ConfigException {
        this.currentConfig = configuration;
        configuration.addLDAPAttributeDescriptionListChangeListener(this);
        if (pluginTypes.isEmpty()) {
            Message message = PluginMessages.ERR_PLUGIN_ADLIST_NO_PLUGIN_TYPES.get(String.valueOf(configuration.dn()));
            throw new ConfigException(message);
        }
        for (PluginType t : pluginTypes) {
            if (t == PluginType.PRE_PARSE_SEARCH) continue;
            Message message = PluginMessages.ERR_PLUGIN_ADLIST_INVALID_PLUGIN_TYPE.get(String.valueOf(configuration.dn()), String.valueOf((Object)t));
            throw new ConfigException(message);
        }
        DirectoryConfig.registerSupportedFeature("1.3.6.1.4.1.4203.1.5.2");
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfig.removeLDAPAttributeDescriptionListChangeListener(this);
    }

    @Override
    public final PluginResult.PreParse doPreParse(PreParseSearchOperation searchOperation) {
        searchOperation.setAttributes(LDAPADListPlugin.normalizedObjectClasses(searchOperation.getAttributes()));
        return PluginResult.PreParse.continueOperationProcessing();
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        LDAPAttributeDescriptionListPluginCfg cfg = (LDAPAttributeDescriptionListPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LDAPAttributeDescriptionListPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case PREPARSESEARCH: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_ADLIST_INVALID_PLUGIN_TYPE.get(String.valueOf(configuration.dn()), String.valueOf((Object)pluginType));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LDAPAttributeDescriptionListPluginCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

