/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.SortedSet;
import javax.servlet.AsyncContext;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.adapter.server2x.Adapters;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.std.server.HTTPConnectionHandlerCfg;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.http.HTTPAuthenticationConfig;
import org.opends.server.protocols.http.HTTPClientConnection;
import org.opends.server.protocols.http.HTTPConnectionHandler;
import org.opends.server.protocols.http.SdkConnectionAdapter;
import org.opends.server.types.AddressMask;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

final class CollectClientConnectionsFilter
implements javax.servlet.Filter {
    static final String HTTP_BASIC_AUTH_HEADER = "Authorization";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final HTTPConnectionHandler connectionHandler;
    private final HTTPAuthenticationConfig authConfig;

    public CollectClientConnectionsFilter(HTTPConnectionHandler connectionHandler, HTTPAuthenticationConfig authenticationConfig) {
        this.connectionHandler = connectionHandler;
        this.authConfig = authenticationConfig;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        final HTTPRequestContext ctx = new HTTPRequestContext();
        ctx.request = request;
        ctx.response = (HttpServletResponse)new HttpServletResponseWrapper(response){

            public void setStatus(int sc) {
                ctx.clientConnection.log(sc);
                super.setStatus(sc);
            }

            public void setStatus(int sc, String sm) {
                ctx.clientConnection.log(sc);
                super.setStatus(sc, sm);
            }
        };
        ctx.chain = chain;
        ctx.prettyPrint = Boolean.parseBoolean(request.getParameter("_prettyPrint"));
        HTTPClientConnection clientConnection = new HTTPClientConnection(this.connectionHandler, request);
        this.connectionHandler.addClientConnection(clientConnection);
        ctx.clientConnection = clientConnection;
        if (this.connectionHandler.keepStats()) {
            this.connectionHandler.getStatTracker().addRequest(ctx.clientConnection.getMethod());
        }
        try {
            if (!this.canProcessRequest(request, clientConnection)) {
                return;
            }
            AccessLogger.logConnect(clientConnection);
            ctx.connection = (Connection)new SdkConnectionAdapter(clientConnection);
            String[] userPassword = this.extractUsernamePassword(request);
            if (userPassword != null && userPassword.length == 2) {
                ctx.userName = userPassword[0];
                ctx.password = userPassword[1];
                ctx.asyncContext = this.getAsyncContext((ServletRequest)request);
                Adapters.newRootConnection().searchSingleEntryAsync(this.buildSearchRequest(ctx.userName), (ResultHandler)new DoBindResultHandler(ctx));
            } else if (this.connectionHandler.acceptUnauthenticatedRequests()) {
                this.doFilter(ctx);
            } else {
                this.sendAuthenticationFailure(ctx);
            }
        }
        catch (Exception e) {
            this.onFailure(e, ctx);
        }
    }

    private void doFilter(HTTPRequestContext ctx) throws Exception {
        ctx.request.setAttribute("org.forgerock.opendj.rest2ldap.authn-connection", (Object)ctx.connection);
        ctx.chain.doFilter((ServletRequest)ctx.request, (ServletResponse)ctx.response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAuthenticationFailure(HTTPRequestContext ctx) {
        int statusCode = 401;
        try {
            ResourceException unauthorizedException = ResourceException.getException((int)401, (String)"Invalid Credentials");
            this.sendErrorReponse(ctx.response, ctx.prettyPrint, unauthorizedException);
            ctx.clientConnection.disconnect(DisconnectReason.INVALID_CREDENTIALS, false, null);
        }
        finally {
            ctx.clientConnection.log(401);
            if (ctx.asyncContext != null) {
                ctx.asyncContext.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFailure(Exception e, HTTPRequestContext ctx) {
        ResourceException ex = Rest2LDAP.asResourceException((Throwable)e);
        try {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.sendErrorReponse(ctx.response, ctx.prettyPrint, ex);
            Message message = ProtocolMessages.INFO_CONNHANDLER_UNABLE_TO_REGISTER_CLIENT.get(ctx.clientConnection.getClientHostPort(), ctx.clientConnection.getServerHostPort(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            ctx.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, false, message);
        }
        finally {
            ctx.clientConnection.log(ex.getCode());
            if (ctx.asyncContext != null) {
                ctx.asyncContext.complete();
            }
        }
    }

    private boolean canProcessRequest(HttpServletRequest request, HTTPClientConnection clientConnection) throws UnknownHostException {
        InetAddress clientAddr = InetAddress.getByName(request.getRemoteAddr());
        if (clientConnection.getConnectionID() < 0L) {
            clientConnection.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, ProtocolMessages.ERR_CONNHANDLER_REJECTED_BY_SERVER.get());
            return false;
        }
        HTTPConnectionHandlerCfg config = this.connectionHandler.getCurrentConfig();
        SortedSet<AddressMask> allowedClients = config.getAllowedClient();
        SortedSet<AddressMask> deniedClients = config.getDeniedClient();
        if (!deniedClients.isEmpty() && AddressMask.maskListContains(clientAddr, deniedClients)) {
            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, false, ProtocolMessages.ERR_CONNHANDLER_DENIED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
            return false;
        }
        if (!allowedClients.isEmpty() && !AddressMask.maskListContains(clientAddr, allowedClients)) {
            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, false, ProtocolMessages.ERR_CONNHANDLER_DISALLOWED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
            return false;
        }
        return true;
    }

    String[] extractUsernamePassword(HttpServletRequest request) throws ResourceException {
        String[] userPassword;
        String httpBasicAuthHeader;
        if (this.authConfig.isCustomHeadersAuthenticationSupported()) {
            String userName = request.getHeader(this.authConfig.getCustomHeaderUsername());
            String password = request.getHeader(this.authConfig.getCustomHeaderPassword());
            if (userName != null && password != null) {
                return new String[]{userName, password};
            }
        }
        if (this.authConfig.isBasicAuthenticationSupported() && (httpBasicAuthHeader = request.getHeader(HTTP_BASIC_AUTH_HEADER)) != null && (userPassword = this.parseUsernamePassword(httpBasicAuthHeader)) != null) {
            return userPassword;
        }
        return null;
    }

    void sendErrorReponse(HttpServletResponse response, boolean prettyPrint, ResourceException re) {
        block3: {
            response.setStatus(re.getCode());
            if (re.getCode() == 401 && this.authConfig.isBasicAuthenticationSupported()) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"org.forgerock.opendj\"");
            }
            try {
                response.setHeader("Content-Type", "application/json");
                response.getOutputStream().println(this.toJSON(prettyPrint, re));
            }
            catch (IOException ignore) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, ignore);
            }
        }
    }

    private String toJSON(boolean prettyPrint, ResourceException re) {
        String indent = "\n    ";
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (prettyPrint) {
            sb.append("\n    ");
        }
        sb.append("\"code\": ").append(re.getCode()).append(",");
        if (prettyPrint) {
            sb.append("\n    ");
        }
        sb.append("\"message\": \"").append(re.getMessage()).append("\",");
        if (prettyPrint) {
            sb.append("\n    ");
        }
        sb.append("\"reason\": \"").append(re.getReason()).append("\"");
        if (prettyPrint) {
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    String[] parseUsernamePassword(String authHeader) throws ResourceException {
        if (authHeader != null && (authHeader.startsWith("Basic") || authHeader.startsWith("basic"))) {
            String base64UserPassword = authHeader.substring("basic".length() + 1);
            try {
                String userPassword = new String(Base64.decode(base64UserPassword));
                String[] split = userPassword.split(":");
                if (split.length == 2) {
                    return split;
                }
            }
            catch (ParseException e) {
                throw Rest2LDAP.asResourceException((Throwable)e);
            }
        }
        return null;
    }

    private AsyncContext getAsyncContext(ServletRequest request) {
        return request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync();
    }

    private SearchRequest buildSearchRequest(String userName) {
        Filter filter = Filter.format((String)this.authConfig.getSearchFilterTemplate(), (Object[])new Object[]{userName});
        return Requests.newSearchRequest((DN)this.authConfig.getSearchBaseDN(), (SearchScope)this.authConfig.getSearchScope(), (Filter)filter, (String[])new String[]{"1.1"});
    }

    public void destroy() {
    }

    private final class CallDoFilterResultHandler
    implements ResultHandler<BindResult> {
        private final HTTPRequestContext ctx;

        private CallDoFilterResultHandler(HTTPRequestContext ctx) {
            this.ctx = ctx;
        }

        public void handleErrorResult(ErrorResultException error) {
            CollectClientConnectionsFilter.this.onFailure((Exception)error, this.ctx);
        }

        public void handleResult(BindResult result) {
            this.ctx.clientConnection.setAuthUser(this.ctx.userName);
            try {
                CollectClientConnectionsFilter.this.doFilter(this.ctx);
            }
            catch (Exception e) {
                CollectClientConnectionsFilter.this.onFailure(e, this.ctx);
            }
        }
    }

    private final class DoBindResultHandler
    implements ResultHandler<SearchResultEntry> {
        private HTTPRequestContext ctx;

        private DoBindResultHandler(HTTPRequestContext ctx) {
            this.ctx = ctx;
        }

        public void handleErrorResult(ErrorResultException error) {
            ResultCode rc = error.getResult().getResultCode();
            if (ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED.equals((Object)rc) || ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED.equals((Object)rc)) {
                CollectClientConnectionsFilter.this.sendAuthenticationFailure(this.ctx);
            } else {
                CollectClientConnectionsFilter.this.onFailure((Exception)error, this.ctx);
            }
        }

        public void handleResult(SearchResultEntry resultEntry) {
            DN bindDN = resultEntry.getName();
            if (bindDN == null) {
                CollectClientConnectionsFilter.this.sendAuthenticationFailure(this.ctx);
            } else {
                SimpleBindRequest bindRequest = Requests.newSimpleBindRequest((String)bindDN.toString(), (byte[])this.ctx.password.getBytes(Charset.forName("UTF-8")));
                this.ctx.password = null;
                this.ctx.connection.bindAsync((BindRequest)bindRequest, null, (ResultHandler)new CallDoFilterResultHandler(this.ctx));
            }
        }
    }

    private static final class HTTPRequestContext {
        private AsyncContext asyncContext;
        private HttpServletRequest request;
        private HttpServletResponse response;
        private FilterChain chain;
        private HTTPClientConnection clientConnection;
        private Connection connection;
        private boolean prettyPrint;
        private String userName;
        private String password;

        private HTTPRequestContext() {
        }
    }
}

