/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.AttrHistorical;
import org.opends.server.replication.plugin.AttrHistoricalWithOptions;
import org.opends.server.replication.plugin.AttrValueHistorical;
import org.opends.server.replication.plugin.FakeAddOperation;
import org.opends.server.replication.plugin.FakeModdnOperation;
import org.opends.server.replication.plugin.FakeModifyOperation;
import org.opends.server.replication.plugin.FakeOperation;
import org.opends.server.replication.plugin.HistAttrModificationKey;
import org.opends.server.replication.plugin.HistoricalAttributeValue;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class EntryHistorical {
    public static final String HISTORICAL_ATTRIBUTE_NAME = "ds-sync-hist";
    public static final String HISTORICAL = "ds-synch-historical";
    public static final String ENTRYUUID_ATTRIBUTE_NAME = "entryuuid";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private long purgeDelayInMillisec = -1L;
    private ChangeNumber oldestChangeNumber = null;
    private int lastPurgedValuesCount = 0;
    private ChangeNumber entryADDDate = null;
    private ChangeNumber entryMODDNDate = null;
    private HashMap<AttributeType, AttrHistoricalWithOptions> attributesHistorical = new HashMap();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.encodeAndPurge());
        return builder.toString();
    }

    public boolean replayOperation(PreOperationModifyOperation modifyOperation, Entry modifiedEntry) {
        boolean bConflict = false;
        List<Modification> mods = modifyOperation.getModifications();
        ChangeNumber modOpChangeNumber = OperationContext.getChangeNumber(modifyOperation);
        Iterator<Modification> modsIterator = mods.iterator();
        while (modsIterator.hasNext()) {
            Modification m = modsIterator.next();
            AttrHistorical attrHist = this.getOrCreateAttrHistorical(m);
            if (!attrHist.replayOperation(modsIterator, modOpChangeNumber, modifiedEntry, m)) continue;
            bConflict = true;
        }
        return bConflict;
    }

    public void setHistoricalAttrToOperation(PreOperationModifyOperation modifyOperation) {
        Modification mod2;
        List<Modification> mods = modifyOperation.getModifications();
        Entry modifiedEntry = modifyOperation.getModifiedEntry();
        ChangeNumber changeNumber = OperationContext.getChangeNumber(modifyOperation);
        if (!modifyOperation.isSynchronizationOperation()) {
            for (Modification mod2 : mods) {
                AttrHistorical attrHist = this.getOrCreateAttrHistorical(mod2);
                if (attrHist == null) continue;
                attrHist.processLocalOrNonConflictModification(changeNumber, mod2);
            }
        }
        Attribute attr = this.encodeAndPurge();
        mod2 = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod2);
        modifiedEntry.replaceAttribute(attr);
    }

    public void setHistoricalAttrToOperation(PreOperationModifyDNOperation modifyDNOperation) {
        this.entryMODDNDate = OperationContext.getChangeNumber(modifyDNOperation);
        Entry modifiedEntry = modifyDNOperation.getUpdatedEntry();
        List<Modification> mods = modifyDNOperation.getModifications();
        Attribute attr = this.encodeAndPurge();
        Modification mod = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod);
        modifiedEntry.removeAttribute(attr.getAttributeType());
        modifiedEntry.addAttribute(attr, null);
    }

    public static void setHistoricalAttrToOperation(PreOperationAddOperation addOperation) {
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICAL_ATTRIBUTE_NAME);
        Attribute attr = Attributes.create(historicalAttrType, EntryHistorical.encodeAddHistorical(OperationContext.getChangeNumber(addOperation)));
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        attrList.add(attr);
        addOperation.setAttribute(historicalAttrType, attrList);
    }

    private static AttributeValue encodeAddHistorical(ChangeNumber cn) {
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICAL_ATTRIBUTE_NAME);
        String strValue = "dn:" + cn.toString() + ":add";
        AttributeValue val = AttributeValues.create(historicalAttrType, strValue);
        return val;
    }

    private static AttributeValue encodeMODDNHistorical(ChangeNumber cn) {
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICAL_ATTRIBUTE_NAME);
        String strValue = "dn:" + cn.toString() + ":moddn";
        AttributeValue val = AttributeValues.create(historicalAttrType, strValue);
        return val;
    }

    private AttrHistorical getOrCreateAttrHistorical(Modification mod) {
        AttrHistorical attrHist;
        Attribute modAttr = mod.getAttribute();
        if (EntryHistorical.isHistoricalAttribute(modAttr)) {
            return null;
        }
        Set<String> modOptions = modAttr.getOptions();
        AttributeType modAttrType = modAttr.getAttributeType();
        AttrHistoricalWithOptions attrHistWithOptions = this.attributesHistorical.get(modAttrType);
        if (attrHistWithOptions != null) {
            attrHist = attrHistWithOptions.get(modOptions);
        } else {
            attrHistWithOptions = new AttrHistoricalWithOptions();
            this.attributesHistorical.put(modAttrType, attrHistWithOptions);
            attrHist = null;
        }
        if (attrHist == null) {
            attrHist = AttrHistorical.createAttributeHistorical(modAttrType);
            attrHistWithOptions.put(modOptions, attrHist);
        }
        return attrHist;
    }

    public int getLastPurgedValuesCount() {
        return this.lastPurgedValuesCount;
    }

    public Attribute encodeAndPurge() {
        long purgeDate = 0L;
        this.lastPurgedValuesCount = 0;
        if (this.purgeDelayInMillisec > 0L) {
            purgeDate = TimeThread.getTime() - this.purgeDelayInMillisec;
        }
        AttributeType historicalAttrType = DirectoryServer.getSchema().getAttributeType(HISTORICAL_ATTRIBUTE_NAME);
        AttributeBuilder builder = new AttributeBuilder(historicalAttrType);
        for (Map.Entry<AttributeType, AttrHistoricalWithOptions> entryWithOptions : this.attributesHistorical.entrySet()) {
            AttributeType type = entryWithOptions.getKey();
            HashMap<Set<String>, AttrHistorical> attrwithoptions = entryWithOptions.getValue().getAttributesInfo();
            for (Map.Entry<Set<String>, AttrHistorical> entry : attrwithoptions.entrySet()) {
                ChangeNumber deleteTime;
                boolean delAttr = false;
                Set<String> options = entry.getKey();
                String optionsString = "";
                AttrHistorical attrHist = entry.getValue();
                if (options != null) {
                    StringBuilder optionsBuilder = new StringBuilder();
                    for (String s : options) {
                        optionsBuilder.append(';');
                        optionsBuilder.append(s);
                    }
                    optionsString = optionsBuilder.toString();
                }
                if ((deleteTime = attrHist.getDeleteTime()) != null) {
                    delAttr = true;
                }
                for (AttrValueHistorical attrValHist : attrHist.getValuesHistorical().keySet()) {
                    AttributeValue val;
                    String strValue;
                    if (attrValHist.getValueDeleteTime() != null) {
                        if (this.purgeDelayInMillisec > 0L && attrValHist.getValueDeleteTime().getTime() <= purgeDate) {
                            ++this.lastPurgedValuesCount;
                            continue;
                        }
                        strValue = type.getNormalizedPrimaryName() + optionsString + ":" + attrValHist.getValueDeleteTime().toString() + ":del:" + ((Object)attrValHist.getAttributeValue()).toString();
                        val = AttributeValues.create(historicalAttrType, strValue);
                        builder.add(val);
                        continue;
                    }
                    if (attrValHist.getValueUpdateTime() == null) continue;
                    if (this.purgeDelayInMillisec > 0L && attrValHist.getValueUpdateTime().getTime() <= purgeDate) {
                        ++this.lastPurgedValuesCount;
                        continue;
                    }
                    if (delAttr && attrValHist.getValueUpdateTime() == deleteTime && attrValHist.getAttributeValue() != null) {
                        strValue = type.getNormalizedPrimaryName() + optionsString + ":" + attrValHist.getValueUpdateTime().toString() + ":repl:" + ((Object)attrValHist.getAttributeValue()).toString();
                        delAttr = false;
                    } else {
                        strValue = attrValHist.getAttributeValue() == null ? type.getNormalizedPrimaryName() + optionsString + ":" + attrValHist.getValueUpdateTime().toString() + ":add" : type.getNormalizedPrimaryName() + optionsString + ":" + attrValHist.getValueUpdateTime().toString() + ":add:" + ((Object)attrValHist.getAttributeValue()).toString();
                    }
                    val = AttributeValues.create(historicalAttrType, strValue);
                    builder.add(val);
                }
                if (!delAttr) continue;
                if (this.purgeDelayInMillisec > 0L && deleteTime.getTime() <= purgeDate) {
                    ++this.lastPurgedValuesCount;
                    continue;
                }
                String strValue = type.getNormalizedPrimaryName() + optionsString + ":" + deleteTime.toString() + ":attrDel";
                AttributeValue val = AttributeValues.create(historicalAttrType, strValue);
                builder.add(val);
            }
        }
        if (this.entryADDDate != null) {
            if (this.purgeDelayInMillisec > 0L && this.entryADDDate.getTime() <= purgeDate) {
                ++this.lastPurgedValuesCount;
            } else {
                builder.add(EntryHistorical.encodeAddHistorical(this.entryADDDate));
            }
        }
        if (this.entryMODDNDate != null) {
            if (this.purgeDelayInMillisec > 0L && this.entryMODDNDate.getTime() <= purgeDate) {
                ++this.lastPurgedValuesCount;
            } else {
                builder.add(EntryHistorical.encodeMODDNHistorical(this.entryMODDNDate));
            }
        }
        return builder.toAttribute();
    }

    public void setPurgeDelay(long purgeDelay) {
        this.purgeDelayInMillisec = purgeDelay;
    }

    public boolean addedOrRenamedAfter(ChangeNumber cn) {
        return cn.older(this.entryADDDate) != false || cn.older(this.entryMODDNDate) != false;
    }

    public ChangeNumber getDNDate() {
        if (this.entryADDDate == null) {
            return this.entryMODDNDate;
        }
        if (this.entryMODDNDate == null) {
            return this.entryADDDate;
        }
        if (this.entryMODDNDate.older(this.entryADDDate).booleanValue()) {
            return this.entryMODDNDate;
        }
        return this.entryADDDate;
    }

    public static EntryHistorical newInstanceFromEntry(Entry entry) {
        AttributeType lastAttrType = null;
        Set<Object> lastOptions = new HashSet();
        AttrHistorical attrInfo = null;
        AttrHistoricalWithOptions attrInfoWithOptions = null;
        List<Attribute> histAttrWithOptionsFromEntry = EntryHistorical.getHistoricalAttr(entry);
        EntryHistorical newHistorical = new EntryHistorical();
        if (histAttrWithOptionsFromEntry == null) {
            return newHistorical;
        }
        try {
            for (Attribute histAttrFromEntry : histAttrWithOptionsFromEntry) {
                for (AttributeValue histAttrValueFromEntry : histAttrFromEntry) {
                    HistoricalAttributeValue histVal = new HistoricalAttributeValue(histAttrValueFromEntry.getValue().toString());
                    AttributeType attrType = histVal.getAttrType();
                    Set<String> options = histVal.getOptions();
                    ChangeNumber cn = histVal.getCn();
                    AttributeValue value = histVal.getAttributeValue();
                    HistAttrModificationKey histKey = histVal.getHistKey();
                    newHistorical.updateOldestCN(cn);
                    if (histVal.isADDOperation()) {
                        newHistorical.entryADDDate = cn;
                        continue;
                    }
                    if (histVal.isMODDNOperation()) {
                        newHistorical.entryMODDNDate = cn;
                        continue;
                    }
                    if (attrType == null) {
                        Message message = ReplicationMessages.ERR_UNKNOWN_ATTRIBUTE_IN_HISTORICAL.get(entry.getDN().toNormalizedString(), histVal.getAttrString());
                        ErrorLogger.logError(message);
                        continue;
                    }
                    if (attrType != lastAttrType) {
                        attrInfo = AttrHistorical.createAttributeHistorical(attrType);
                        attrInfoWithOptions = new AttrHistoricalWithOptions();
                        attrInfoWithOptions.put(options, attrInfo);
                        newHistorical.attributesHistorical.put(attrType, attrInfoWithOptions);
                        lastAttrType = attrType;
                        lastOptions = options;
                    } else if (!((Object)options).equals(lastOptions)) {
                        attrInfo = AttrHistorical.createAttributeHistorical(attrType);
                        attrInfoWithOptions.put(options, attrInfo);
                        lastOptions = options;
                    }
                    attrInfo.assign(histKey, value, cn);
                }
            }
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_BAD_HISTORICAL.get(entry.getDN().toString());
            ErrorLogger.logError(message);
        }
        return newHistorical;
    }

    public static Iterable<FakeOperation> generateFakeOperations(Entry entry) {
        TreeMap<ChangeNumber, FakeOperation> operations = new TreeMap<ChangeNumber, FakeOperation>();
        List<Attribute> attrs = EntryHistorical.getHistoricalAttr(entry);
        if (attrs != null) {
            for (Attribute attr : attrs) {
                for (AttributeValue val : attr) {
                    FakeModifyOperation modifyFakeOperation;
                    HistoricalAttributeValue histVal = new HistoricalAttributeValue(val.getValue().toString());
                    if (histVal.isADDOperation()) {
                        operations.put(histVal.getCn(), new FakeAddOperation(histVal.getCn(), entry));
                        continue;
                    }
                    if (histVal.isMODDNOperation()) {
                        operations.put(histVal.getCn(), new FakeModdnOperation(histVal.getCn(), entry));
                        continue;
                    }
                    ChangeNumber cn = histVal.getCn();
                    Modification mod = histVal.generateMod();
                    FakeOperation fakeOperation = (FakeOperation)operations.get(cn);
                    if (fakeOperation != null && fakeOperation instanceof FakeModifyOperation) {
                        modifyFakeOperation = (FakeModifyOperation)fakeOperation;
                        modifyFakeOperation.addModification(mod);
                        continue;
                    }
                    String uuidString = EntryHistorical.getEntryUUID(entry);
                    modifyFakeOperation = new FakeModifyOperation(entry.getDN(), cn, uuidString);
                    modifyFakeOperation.addModification(mod);
                    operations.put(histVal.getCn(), modifyFakeOperation);
                }
            }
        }
        return operations.values();
    }

    public static List<Attribute> getHistoricalAttr(Entry entry) {
        return entry.getAttribute(HISTORICAL_ATTRIBUTE_NAME);
    }

    public static String getEntryUUID(Entry entry) {
        AttributeType entryuuidAttrType = DirectoryServer.getSchema().getAttributeType(ENTRYUUID_ATTRIBUTE_NAME);
        List<Attribute> uuidAttrs = entry.getOperationalAttribute(entryuuidAttrType);
        return EntryHistorical.extractEntryUUID(uuidAttrs, entry.getDN());
    }

    public static String getEntryUUID(PreOperationAddOperation op) {
        Map<AttributeType, List<Attribute>> attrs = op.getOperationalAttributes();
        AttributeType entryuuidAttrType = DirectoryServer.getSchema().getAttributeType(ENTRYUUID_ATTRIBUTE_NAME);
        List<Attribute> uuidAttrs = attrs.get(entryuuidAttrType);
        return EntryHistorical.extractEntryUUID(uuidAttrs, op.getEntryDN());
    }

    public static boolean isHistoricalAttribute(Attribute attr) {
        AttributeType attrType = attr.getAttributeType();
        return attrType.getNameOrOID().equals(HISTORICAL_ATTRIBUTE_NAME);
    }

    private void updateOldestCN(ChangeNumber cn) {
        if (cn != null) {
            if (this.oldestChangeNumber == null) {
                this.oldestChangeNumber = cn;
            } else if (cn.older(this.oldestChangeNumber).booleanValue()) {
                this.oldestChangeNumber = cn;
            }
        }
    }

    public ChangeNumber getOldestCN() {
        return this.oldestChangeNumber;
    }

    private static String extractEntryUUID(List<Attribute> entryUUIDAttributes, DN entryDN) {
        Attribute uuid;
        if (entryUUIDAttributes != null && !(uuid = entryUUIDAttributes.get(0)).isEmpty()) {
            AttributeValue uuidVal = uuid.iterator().next();
            return uuidVal.getValue().toString();
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugWarning("Replication requires an entryUUID attribute in order to perform conflict resolution, but none was found in entry \"%s\": generating virtual entryUUID instead", entryDN);
        }
        String normDNString = entryDN.toNormalizedString();
        return UUID.nameUUIDFromBytes(StaticUtils.getBytes(normDNString)).toString();
    }
}

