/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public class ChangeTimeHeartbeatMsg
extends ReplicationMsg {
    private final ChangeNumber changeNumber;

    public ChangeTimeHeartbeatMsg(ChangeNumber cn) {
        this.changeNumber = cn;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public ChangeTimeHeartbeatMsg(byte[] in, short version) throws DataFormatException {
        ByteSequenceReader reader = ByteString.wrap(in).asReader();
        try {
            if (reader.get() != 33) {
                throw new IllegalArgumentException();
            }
            if (version >= 7) {
                this.changeNumber = ChangeNumber.valueOf(reader.getByteSequence(14));
            } else {
                this.changeNumber = ChangeNumber.valueOf(reader.getString(28));
                reader.get();
            }
            if (reader.remaining() > 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            throw new DataFormatException("byte[] is not a valid CT_HEARTBEAT msg");
        }
    }

    @Override
    public byte[] getBytes(short protocolVersion) {
        if (protocolVersion >= 7) {
            ByteStringBuilder builder = new ByteStringBuilder(15);
            builder.append((byte)33);
            this.changeNumber.toByteString(builder);
            return builder.toByteArray();
        }
        ByteStringBuilder builder = new ByteStringBuilder(30);
        builder.append((byte)33);
        builder.append(this.changeNumber.toString());
        builder.append((byte)0);
        return builder.toByteArray();
    }
}

