/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.RoutableMsg;

public class DoneMsg
extends RoutableMsg {
    public DoneMsg(int serverID, int i) {
        super(serverID, i);
    }

    public DoneMsg(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 13) {
                throw new DataFormatException("input is not a valid DoneMessage");
            }
            int pos = 1;
            int length = DoneMsg.getNextLength(in, pos);
            String senderString = new String(in, pos, length, "UTF-8");
            this.senderID = Integer.valueOf(senderString);
            pos += length + 1;
            length = DoneMsg.getNextLength(in, pos);
            String destinationString = new String(in, pos, length, "UTF-8");
            this.destination = Integer.valueOf(destinationString);
            pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    @Override
    public byte[] getBytes(short protocolVersion) {
        try {
            byte[] senderBytes = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] destinationBytes = String.valueOf(this.destination).getBytes("UTF-8");
            int length = 1 + senderBytes.length + 1 + destinationBytes.length + 1;
            byte[] resultByteArray = new byte[length];
            resultByteArray[0] = 13;
            int pos = 1;
            pos = DoneMsg.addByteArray(senderBytes, resultByteArray, pos);
            pos = DoneMsg.addByteArray(destinationBytes, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

